/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.noise;

import com.moulberry.axiom.noise.NoiseInterface;
import com.moulberry.axiom.noise.SimplexNoise;
import com.moulberry.axiom.noise.WhiteNoise;

public class SplatterNoise
implements NoiseInterface {
    private final SimplexNoise simplexNoise;
    private final WhiteNoise whiteNoise;
    private final float scaleX;
    private final float scaleY;
    private final float scaleZ;

    public SplatterNoise(long seed, float scaleX, float scaleY, float scaleZ) {
        this.simplexNoise = new SimplexNoise(seed);
        this.whiteNoise = new WhiteNoise(seed + 10L);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
    }

    @Override
    public float evaluate(double x, double y) {
        float simplex = this.simplexNoise.evaluate(x, y);
        float white = this.whiteNoise.evaluate(x * (double)this.scaleX, y * (double)this.scaleY) * 0.4f + 0.3f;
        if ((double)white < 0.5) {
            return simplex * (white *= 2.0f);
        }
        white = (white - 0.5f) * 2.0f;
        return simplex * (1.0f - white) + white;
    }

    @Override
    public float evaluate(double x, double y, double z) {
        float simplex = this.simplexNoise.evaluate(x, y, z);
        float white = this.whiteNoise.evaluate(x * (double)this.scaleX, y * (double)this.scaleY, z * (double)this.scaleZ) * 0.4f + 0.3f;
        if ((double)white < 0.5) {
            return simplex * (white *= 2.0f);
        }
        white = (white - 0.5f) * 2.0f;
        return simplex * (1.0f - white) + white;
    }
}

