/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.marker;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.AxiomClient;
import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.hooks.ScreenRenderHook;
import com.moulberry.axiom.marker.MarkerData;
import com.moulberry.axiom.packets.AxiomClientboundMarkerData;
import com.moulberry.axiom.packets.AxiomServerboundDeleteEntity;
import com.moulberry.axiom.packets.AxiomServerboundManipulateEntity;
import com.moulberry.axiom.packets.AxiomServerboundMarkerNbtRequest;
import com.moulberry.axiom.packets.AxiomServerboundSpawnEntity;
import com.moulberry.axiom.packets.SupportedProtocol;
import com.moulberry.axiom.render.EffectRenderer;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.screen.EditMarkerScreen;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.ChatUtils;
import com.moulberry.axiom.utils.InputHelper;
import com.moulberry.axiom.utils.ProjectedText;
import com.moulberry.axiom.utils.RenderHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5625;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class MarkerEntityManipulator {
    private static final Map<UUID, Gizmo> gizmos = new HashMap<UUID, Gizmo>();
    private static final Map<UUID, MarkerData> markerDataMap = new HashMap<UUID, MarkerData>();
    private static final Map<UUID, class_243> pendingTeleports = new HashMap<UUID, class_243>();
    private static MarkerData activeEntity = null;
    private static boolean hoveredGizmoPart = false;
    private static final List<class_243> undoStates = new ArrayList<class_243>();
    private static final List<class_243> redoStates = new ArrayList<class_243>();
    private static boolean movementDirty = false;
    private static int teleportTicks = 0;
    private static boolean copyMarkerEntity = false;

    public static void tick() {
        if (teleportTicks > 0) {
            --teleportTicks;
        }
        class_746 player = class_310.method_1551().field_1724;
        class_638 level = class_310.method_1551().field_1687;
        if (player == null || level == null || !AxiomClient.isAxiomActive() || !Axiom.configuration.entityManipulation.showMarkerEntities) {
            if (activeEntity != null) {
                Gizmo gizmo = gizmos.get(activeEntity.uuid());
                if (gizmo != null) {
                    gizmo.enableAxes = false;
                    gizmo.moveToVec(activeEntity.position());
                }
                teleportTicks = 0;
                activeEntity = null;
                movementDirty = false;
                undoStates.clear();
                redoStates.clear();
            }
            pendingTeleports.clear();
            return;
        }
        if (!pendingTeleports.isEmpty()) {
            ArrayList<AxiomServerboundManipulateEntity.ManipulateEntry> entries = new ArrayList<AxiomServerboundManipulateEntity.ManipulateEntry>();
            for (Map.Entry<UUID, class_243> entry : pendingTeleports.entrySet()) {
                MarkerData markerData = markerDataMap.get(entry.getKey());
                class_2487 mergeData = new class_2487();
                class_243 delta = entry.getValue().method_1020(markerData.position());
                if (delta.equals((Object)class_243.field_1353)) continue;
                class_2487 merge = null;
                if (!mergeData.method_33133()) {
                    merge = new class_2487();
                    merge.method_10566("data", (class_2520)mergeData);
                }
                entries.add(new AxiomServerboundManipulateEntity.ManipulateEntry(entry.getKey(), entry.getValue(), merge));
            }
            new AxiomServerboundManipulateEntity(entries).send();
        }
        pendingTeleports.clear();
    }

    public static void render(class_4184 camera, long time, class_4587 poseStack, Matrix4f projection) {
        class_243 lookDirection;
        hoveredGizmoPart = false;
        if (!Axiom.configuration.entityManipulation.showMarkerEntities) {
            return;
        }
        boolean inEditor = EditorUI.isActive();
        class_243 class_2432 = lookDirection = inEditor ? null : Tool.getLookDirection();
        boolean isLeftDown = !inEditor && (Axiom.configuration.entityManipulation.swapLeftRightClick ? Tool.isMouseDown(1) : Tool.isMouseDown(0));
        boolean isCtrlDown = !inEditor && InputHelper.isCtrlOrCmdDownRaw();
        int rangeSq = Axiom.configuration.entityManipulation.markerEntityRange * Axiom.configuration.entityManipulation.markerEntityRange;
        for (Map.Entry<UUID, Gizmo> entry : gizmos.entrySet()) {
            boolean isActiveEntity;
            UUID uuid = entry.getKey();
            Gizmo gizmo = entry.getValue();
            class_243 before = gizmo.getTargetVec();
            boolean bl = isActiveEntity = activeEntity != null && uuid.equals(activeEntity.uuid());
            if (before.method_1025(camera.method_71156()) > (double)rangeSq && !isActiveEntity) continue;
            if (gizmo.enableAxes) {
                gizmo.setAxisDirections(camera.method_71156().field_1352 > gizmo.getTargetVec().field_1352, camera.method_71156().field_1351 > gizmo.getTargetVec().field_1351, camera.method_71156().field_1350 > gizmo.getTargetVec().field_1350);
            }
            gizmo.update(time, lookDirection, isLeftDown, isCtrlDown, true);
            class_243 position = gizmo.getTargetVec();
            if (!class_310.method_1551().field_1690.field_1842) {
                if (!inEditor) {
                    gizmo.render(poseStack, camera, isCtrlDown);
                }
                MarkerData markerData = markerDataMap.get(uuid);
                if (!gizmo.isGrabbed()) {
                    poseStack.method_22903();
                    poseStack.method_22904(position.field_1352 - camera.method_71156().field_1352, position.field_1351 - camera.method_71156().field_1351, position.field_1350 - camera.method_71156().field_1350);
                    ProjectedText.setupProjectedText();
                    ProjectedText.renderProjectedText(markerData.name() == null ? "Unnamed Marker" : markerData.name(), poseStack, projection, 0.0f, 0.15f, 0.0f);
                    ProjectedText.finishProjectedText();
                    poseStack.method_22909();
                }
                if ((isActiveEntity || activeEntity == null) && markerData.minRegion() != null && markerData.maxRegion() != null) {
                    boolean renderCustomFace;
                    class_243 minRegion = markerData.minRegion();
                    class_243 maxRegion = markerData.maxRegion();
                    boolean renderCustomLine = markerData.lineArgb() != 0;
                    boolean bl2 = renderCustomFace = markerData.faceArgb() != 0;
                    if (!renderCustomLine) {
                        EffectRenderer.renderBoundingBox(camera, time, poseStack, minRegion, maxRegion, 4);
                    }
                    if (renderCustomLine || renderCustomFace) {
                        double minX = Math.min(minRegion.method_10216(), maxRegion.method_10216()) - 1.0E-4;
                        double minY = Math.min(minRegion.method_10214(), maxRegion.method_10214()) - 1.0E-4;
                        double minZ = Math.min(minRegion.method_10215(), maxRegion.method_10215()) - 1.0E-4;
                        float sizeX = (float)(Math.abs(minRegion.method_10216() - maxRegion.method_10216()) + 2.0E-4);
                        float sizeY = (float)(Math.abs(minRegion.method_10214() - maxRegion.method_10214()) + 2.0E-4);
                        float sizeZ = (float)(Math.abs(minRegion.method_10215() - maxRegion.method_10215()) + 2.0E-4);
                        float thickness = markerData.lineThickness() < 1.0f ? 2.0f : markerData.lineThickness();
                        float actualLineWidth = RenderHelper.baseLineWidth * thickness / 2.0f;
                        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
                        AxiomRenderer.setLineWidthLegacy(actualLineWidth);
                        poseStack.method_22903();
                        poseStack.method_22904(minX - camera.method_71156().field_1352, minY - camera.method_71156().field_1351, minZ - camera.method_71156().field_1350);
                        RenderHelper.tryApplyModelViewMatrix();
                        VertexConsumerProvider provider = VertexConsumerProvider.shared();
                        if (renderCustomLine) {
                            int argb = markerData.lineArgb();
                            float alpha = (float)(argb >> 24 & 0xFF) / 255.0f;
                            float red = (float)(argb >> 16 & 0xFF) / 255.0f;
                            float green = (float)(argb >> 8 & 0xFF) / 255.0f;
                            float blue = (float)(argb & 0xFF) / 255.0f;
                            if ((double)alpha < 0.1) {
                                alpha = 1.0f;
                            }
                            class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_63455);
                            Shapes.lineBox(poseStack, (class_4588)bufferBuilder, 0.0f, 0.0f, 0.0f, sizeX, sizeY, sizeZ, red, green, blue, alpha, red, green, blue, actualLineWidth);
                            AxiomRenderPipelines.LINES_WITH_CUSTOM_WIDTH.render(provider.build());
                        }
                        if (renderCustomFace) {
                            int faceArgb = markerData.faceArgb();
                            if ((faceArgb >> 24 & 0xFF) == 0) {
                                faceArgb |= 0x40000000;
                            }
                            Shapes.shadedBox(provider, poseStack.method_23760().method_23761(), sizeX, sizeY, sizeZ, faceArgb);
                            AxiomRenderPipelines.POSITION_COLOR.render(provider.build());
                        }
                        poseStack.method_22909();
                    }
                }
            }
            if (gizmo.isHovered()) {
                hoveredGizmoPart = true;
            }
            if (!isActiveEntity) continue;
            if (gizmo.isGrabbed()) {
                movementDirty = true;
            } else {
                if (movementDirty) {
                    movementDirty = false;
                    teleportTicks = 10;
                    MarkerEntityManipulator.applyTeleport(uuid, position);
                    MarkerEntityManipulator.addTranslationUndoState(position);
                }
                if (teleportTicks == 0) {
                    gizmo.moveToVec(activeEntity.position());
                }
            }
            if (position.equals((Object)before)) continue;
            String paddedPositionX = String.format("%.4f", position.field_1352);
            String paddedPositionY = String.format("%.4f", position.field_1351);
            String paddedPositionZ = String.format("%.4f", position.field_1350);
            ScreenRenderHook.setOverlayText((class_2561)class_2561.method_43470((String)"Position: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(paddedPositionX + " ")).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(paddedPositionY + " ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)paddedPositionZ).method_27692(class_124.field_1075)));
        }
    }

    public static void clear() {
        teleportTicks = 0;
        activeEntity = null;
        movementDirty = false;
        gizmos.clear();
        markerDataMap.clear();
        undoStates.clear();
        redoStates.clear();
        pendingTeleports.clear();
    }

    public static void update(AxiomClientboundMarkerData markerData) {
        for (MarkerData entry : markerData.entries) {
            if (activeEntity != null && entry.uuid().equals(activeEntity.uuid())) {
                activeEntity = entry;
            }
            markerDataMap.put(entry.uuid(), entry);
            Gizmo gizmo = gizmos.get(entry.uuid());
            if (gizmo == null) {
                gizmo = new Gizmo(entry.position());
                gizmo.enableAxes = false;
                gizmo.minVisualScale = 2.0f;
                gizmo.translationSnapping = 16;
                gizmo.centerColour = 16576167;
                gizmos.put(entry.uuid(), gizmo);
                continue;
            }
            if (entry == activeEntity && teleportTicks != 0) continue;
            gizmo.moveToVec(entry.position());
        }
        if (activeEntity != null && markerData.removedMarkers.contains(activeEntity.uuid())) {
            MarkerEntityManipulator.disableActive();
        }
        gizmos.keySet().removeAll(markerData.removedMarkers);
        markerDataMap.keySet().removeAll(markerData.removedMarkers);
    }

    private static void addTranslationUndoState(class_243 position) {
        class_243 first = undoStates.get(undoStates.size() - 1);
        if (first.equals((Object)position)) {
            return;
        }
        if (undoStates.size() >= 2) {
            class_243 second = undoStates.get(undoStates.size() - 2);
            boolean merge = false;
            if (first.field_1352 == position.field_1352 && first.field_1351 == position.field_1351 && second.field_1352 == position.field_1352 && second.field_1351 == position.field_1351) {
                merge = Math.abs(first.field_1350 - position.field_1350) < 1.0 && Math.abs(second.field_1350 - position.field_1350) < 1.0;
            } else if (first.field_1352 == position.field_1352 && first.field_1350 == position.field_1350 && second.field_1352 == position.field_1352 && second.field_1350 == position.field_1350) {
                merge = Math.abs(first.field_1351 - position.field_1351) < 1.0 && Math.abs(second.field_1351 - position.field_1351) < 1.0;
            } else if (first.field_1351 == position.field_1351 && first.field_1350 == position.field_1350 && second.field_1351 == position.field_1351 && second.field_1350 == position.field_1350) {
                boolean bl = merge = Math.abs(first.field_1352 - position.field_1352) < 1.0 && Math.abs(second.field_1352 - position.field_1352) < 1.0;
            }
            if (merge) {
                undoStates.set(undoStates.size() - 1, position);
                redoStates.clear();
                return;
            }
        }
        undoStates.add(position);
        if (undoStates.size() > 256) {
            undoStates.remove(0);
        }
        redoStates.clear();
    }

    public static void disableActive() {
        if (activeEntity != null) {
            Gizmo gizmo = gizmos.get(activeEntity.uuid());
            if (gizmo != null) {
                gizmo.enableAxes = false;
                gizmo.moveToVec(activeEntity.position());
            }
            teleportTicks = 0;
            activeEntity = null;
            movementDirty = false;
            undoStates.clear();
            redoStates.clear();
        }
    }

    public static void deleteActive() {
        if (activeEntity != null) {
            new AxiomServerboundDeleteEntity(List.of(activeEntity.uuid())).send();
        }
        MarkerEntityManipulator.disableActive();
    }

    @Nullable
    public static MarkerData getActiveMarkerData() {
        return activeEntity;
    }

    public static boolean hasActiveGizmo() {
        return activeEntity != null;
    }

    public static boolean hoveredGizmoPart() {
        return hoveredGizmoPart;
    }

    public static boolean canUndo() {
        return undoStates.size() >= 2;
    }

    public static boolean canRedo() {
        return redoStates.size() >= 1;
    }

    private static void applyTeleport(UUID uuid, class_243 position) {
        Gizmo gizmo = gizmos.get(uuid);
        if (gizmo != null) {
            gizmo.moveToVec(position);
        }
        pendingTeleports.put(uuid, position);
    }

    public static void spawnNewMarkerRegion(class_2338 first, class_2338 second) {
        double minX = Math.min(first.method_10263(), second.method_10263());
        double minY = Math.min(first.method_10264(), second.method_10264());
        double minZ = Math.min(first.method_10260(), second.method_10260());
        double maxX = Math.max(first.method_10263(), second.method_10263()) + 1;
        double maxY = Math.max(first.method_10264(), second.method_10264()) + 1;
        double maxZ = Math.max(first.method_10260(), second.method_10260()) + 1;
        class_243 center = new class_243((minX + maxX) / 2.0, (minY + maxY) / 2.0, (minZ + maxZ) / 2.0);
        class_2499 min2 = new class_2499();
        min2.add((Object)class_2519.method_23256((String)("~" + (minX - center.field_1352))));
        min2.add((Object)class_2519.method_23256((String)("~" + (minY - center.field_1351))));
        min2.add((Object)class_2519.method_23256((String)("~" + (minZ - center.field_1350))));
        class_2499 max2 = new class_2499();
        max2.add((Object)class_2519.method_23256((String)("~" + (maxX - center.field_1352))));
        max2.add((Object)class_2519.method_23256((String)("~" + (maxY - center.field_1351))));
        max2.add((Object)class_2519.method_23256((String)("~" + (maxZ - center.field_1350))));
        class_2487 data = new class_2487();
        data.method_10566("min", (class_2520)min2);
        data.method_10566("max", (class_2520)max2);
        class_2487 tag = new class_2487();
        tag.method_10582("id", "minecraft:marker");
        tag.method_10566("data", (class_2520)data);
        new AxiomServerboundSpawnEntity(List.of(new AxiomServerboundSpawnEntity.SpawnEntry(UUID.randomUUID(), center, 0.0f, 0.0f, null, tag))).send();
    }

    public static List<String> getKeyHints() {
        ArrayList<String> keyHints = new ArrayList<String>();
        keyHints.add("RMB - Edit/Move");
        keyHints.add("Scroll - Nudge");
        Gizmo gizmo = gizmos.get(activeEntity.uuid());
        if (gizmo != null && gizmo.isGrabbed()) {
            keyHints.add("Hold Ctrl - Inc Snapping");
            keyHints.add("Hold Shift - No Snapping");
        }
        keyHints.add(Keybinds.COPY_INGAME.shortKeyIdentifier() + " - Copy");
        keyHints.add("Delete - Remove");
        boolean canUndo = MarkerEntityManipulator.canUndo();
        boolean canRedo = MarkerEntityManipulator.canRedo();
        if (canUndo && canRedo) {
            keyHints.add("Ctrl+Z/Y - Undo/Redo");
        } else if (canUndo) {
            keyHints.add("Ctrl+Z - Undo");
        } else if (canRedo) {
            keyHints.add("Ctrl+Y - Redo");
        }
        return keyHints;
    }

    public static UserAction.ActionResult callAction(UserAction userAction, Object object) {
        if (EditorUI.isActive() || !AxiomClient.isAxiomActive() || !Axiom.configuration.entityManipulation.showMarkerEntities) {
            return UserAction.ActionResult.NOT_HANDLED;
        }
        switch (userAction) {
            case COPY: {
                if (activeEntity != null) {
                    if (!ClientEvents.serverSupportsProtocol(SupportedProtocol.MARKER_NBT_REQUEST)) {
                        ChatUtils.error("Server doesn't support requesting marker nbt");
                    } else {
                        copyMarkerEntity = true;
                        new AxiomServerboundMarkerNbtRequest(activeEntity.uuid(), AxiomServerboundMarkerNbtRequest.REASON_COPY).send();
                    }
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case UNDO: {
                if (activeEntity != null) {
                    Gizmo gizmo = gizmos.get(activeEntity.uuid());
                    if (gizmo != null && gizmo.isGrabbed()) {
                        return UserAction.ActionResult.USED_STOP;
                    }
                    if (undoStates.size() >= 2) {
                        class_243 current = undoStates.remove(undoStates.size() - 1);
                        redoStates.add(current);
                        class_243 head = undoStates.get(undoStates.size() - 1);
                        MarkerEntityManipulator.applyTeleport(activeEntity.uuid(), head);
                        teleportTicks = 10;
                    }
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case REDO: {
                if (activeEntity != null) {
                    Gizmo gizmo = gizmos.get(activeEntity.uuid());
                    if (gizmo != null && gizmo.isGrabbed()) {
                        return UserAction.ActionResult.USED_STOP;
                    }
                    if (redoStates.size() >= 1) {
                        class_243 head = redoStates.remove(redoStates.size() - 1);
                        undoStates.add(head);
                        MarkerEntityManipulator.applyTeleport(activeEntity.uuid(), head);
                        teleportTicks = 10;
                    }
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case SCROLL: {
                if (activeEntity != null) {
                    UserAction.ScrollAmount amount = (UserAction.ScrollAmount)object;
                    Gizmo gizmo = gizmos.get(activeEntity.uuid());
                    class_243 look = Tool.getLookDirection();
                    if (gizmo != null && look != null) {
                        boolean isCtrlDown = InputHelper.isCtrlOrCmdDownRaw();
                        gizmo.handleScroll(amount.scrollX(), amount.scrollY(), isCtrlDown, look);
                        movementDirty = true;
                        String paddedPositionX = String.format("%.4f", gizmo.getTargetVec().field_1352);
                        String paddedPositionY = String.format("%.4f", gizmo.getTargetVec().field_1351);
                        String paddedPositionZ = String.format("%.4f", gizmo.getTargetVec().field_1350);
                        ScreenRenderHook.setOverlayText((class_2561)class_2561.method_43470((String)"Position: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(paddedPositionX + " ")).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(paddedPositionY + " ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)paddedPositionZ).method_27692(class_124.field_1075)));
                    }
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case LEFT_MOUSE: {
                if (Axiom.configuration.entityManipulation.swapLeftRightClick) {
                    return MarkerEntityManipulator.handleRightClick();
                }
                return MarkerEntityManipulator.handleLeftClick();
            }
            case RIGHT_MOUSE: {
                if (Axiom.configuration.entityManipulation.swapLeftRightClick) {
                    return MarkerEntityManipulator.handleLeftClick();
                }
                return MarkerEntityManipulator.handleRightClick();
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @NotNull
    private static UserAction.ActionResult handleRightClick() {
        if (hoveredGizmoPart) {
            Gizmo gizmo;
            if (activeEntity != null && (gizmo = gizmos.get(activeEntity.uuid())) != null && gizmo.isHovered()) {
                if (!ClientEvents.serverSupportsProtocol(SupportedProtocol.MARKER_NBT_REQUEST)) {
                    ChatUtils.error("Server doesn't support requesting marker nbt");
                } else {
                    copyMarkerEntity = false;
                    new AxiomServerboundMarkerNbtRequest(activeEntity.uuid(), AxiomServerboundMarkerNbtRequest.REASON_RIGHT_CLICK).send();
                }
                return UserAction.ActionResult.USED_STOP;
            }
            if (class_310.method_1551().method_1560() == null) {
                return UserAction.ActionResult.NOT_HANDLED;
            }
            class_243 cameraPos = class_310.method_1551().method_1560().method_33571();
            int rangeSq = Axiom.configuration.entityManipulation.markerEntityRange * Axiom.configuration.entityManipulation.markerEntityRange;
            for (Map.Entry<UUID, Gizmo> entry : gizmos.entrySet()) {
                boolean isActiveEntity;
                UUID uuid = entry.getKey();
                Gizmo gizmo2 = entry.getValue();
                class_243 before = gizmo2.getTargetVec();
                boolean bl = isActiveEntity = activeEntity != null && uuid.equals(activeEntity.uuid());
                if (before.method_1025(cameraPos) > (double)rangeSq && !isActiveEntity || !gizmo2.isHovered()) continue;
                if (activeEntity != null) {
                    Gizmo activeGizmo = gizmos.get(activeEntity.uuid());
                    if (activeGizmo != null) {
                        activeGizmo.enableAxes = false;
                        activeGizmo.moveToVec(activeEntity.position());
                    }
                    teleportTicks = 0;
                    activeEntity = null;
                    movementDirty = false;
                    undoStates.clear();
                    redoStates.clear();
                }
                gizmo2.enableAxes = true;
                activeEntity = markerDataMap.get(uuid);
                movementDirty = false;
                undoStates.clear();
                redoStates.clear();
                undoStates.add(activeEntity.position());
                if (!ClientEvents.serverSupportsProtocol(SupportedProtocol.MARKER_NBT_REQUEST)) {
                    ChatUtils.error("Server doesn't support requesting marker nbt");
                } else {
                    copyMarkerEntity = false;
                    new AxiomServerboundMarkerNbtRequest(activeEntity.uuid(), AxiomServerboundMarkerNbtRequest.REASON_RIGHT_CLICK).send();
                }
                return UserAction.ActionResult.USED_STOP;
            }
        }
        if (activeEntity != null) {
            class_239 hitResult = class_310.method_1551().field_1765;
            if (hitResult instanceof class_3965) {
                class_3965 blockHitResult = (class_3965)hitResult;
                if (hitResult.method_17783() == class_239.class_240.field_1332) {
                    class_2338 position = blockHitResult.method_17777().method_10093(blockHitResult.method_17780());
                    MarkerEntityManipulator.applyTeleport(activeEntity.uuid(), class_243.method_24953((class_2382)position));
                    teleportTicks = 10;
                }
            }
            return UserAction.ActionResult.USED_STOP;
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    public static void receivedNbtData(UUID uuid, class_2487 data) {
        if (activeEntity != null && activeEntity.uuid().equals(uuid)) {
            if (copyMarkerEntity) {
                class_2487 markerTag = new class_2487();
                markerTag.method_10566("data", (class_2520)data);
                String nbt = new class_5625("", 0, new ArrayList()).method_32283((class_2520)markerTag);
                String command = "/summon marker ~ ~ ~ " + nbt;
                class_310.method_1551().field_1774.method_1455(command);
                class_746 player = class_310.method_1551().field_1724;
                player.method_7353((class_2561)class_2561.method_43470((String)("Copied summon command to clipboard (" + command.length() + " characters)")).method_27692(class_124.field_1054), false);
                player.method_7353((class_2561)class_2561.method_43470((String)"You can use Ctrl+V to paste the entity").method_27692(class_124.field_1054), false);
            } else {
                class_310.method_1551().method_1507((class_437)new EditMarkerScreen(uuid, data));
            }
        }
    }

    @NotNull
    private static UserAction.ActionResult handleLeftClick() {
        boolean ret = false;
        if (activeEntity != null) {
            Gizmo gizmo = gizmos.get(activeEntity.uuid());
            if (gizmo != null) {
                if (gizmo.leftClick()) {
                    return UserAction.ActionResult.USED_STOP;
                }
                gizmo.enableAxes = false;
                gizmo.moveToVec(activeEntity.position());
                ret = true;
            }
            teleportTicks = 0;
            activeEntity = null;
            movementDirty = false;
            undoStates.clear();
            redoStates.clear();
        }
        if (class_310.method_1551().method_1560() == null) {
            return UserAction.ActionResult.NOT_HANDLED;
        }
        class_243 cameraPos = class_310.method_1551().method_1560().method_33571();
        int rangeSq = Axiom.configuration.entityManipulation.markerEntityRange * Axiom.configuration.entityManipulation.markerEntityRange;
        for (Map.Entry<UUID, Gizmo> entry : gizmos.entrySet()) {
            boolean isActiveEntity;
            UUID uuid = entry.getKey();
            Gizmo gizmo = entry.getValue();
            class_243 before = gizmo.getTargetVec();
            boolean bl = isActiveEntity = activeEntity != null && uuid.equals(activeEntity.uuid());
            if (before.method_1025(cameraPos) > (double)rangeSq && !isActiveEntity || !gizmo.leftClick()) continue;
            activeEntity = markerDataMap.get(uuid);
            movementDirty = false;
            undoStates.clear();
            redoStates.clear();
            undoStates.add(activeEntity.position());
            return UserAction.ActionResult.USED_STOP;
        }
        if (ret) {
            return UserAction.ActionResult.USED_STOP;
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }
}

