/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.gizmo;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.utils.RenderHelper;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.joml.Intersectionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ExtrudedGizmo {
    private final Vector3f normal;
    private final class_2338 from;
    public final Gizmo extrudeGizmoFrom;

    public ExtrudedGizmo(class_746 player, Gizmo extrudeGizmoFrom) {
        this.normal = player.method_5720().method_46409().mul(-1.0f);
        this.from = extrudeGizmoFrom.getTargetPosition();
        this.extrudeGizmoFrom = extrudeGizmoFrom;
    }

    public void render(class_4587 matrices, class_4184 camera, class_243 lookDirection) {
        class_2338 target = this.getBlockPos(lookDirection);
        if (target == null) {
            return;
        }
        class_243 offset = class_243.method_24953((class_2382)target);
        float distanceMultiplier = (float)camera.method_71156().method_1022(offset) / 20.0f;
        if (distanceMultiplier < 0.5f) {
            distanceMultiplier = 0.5f;
        }
        float boxSize = 0.3f * distanceMultiplier;
        matrices.method_22903();
        matrices.method_22904(offset.field_1352 - camera.method_71156().field_1352, offset.field_1351 - camera.method_71156().field_1351, offset.field_1350 - camera.method_71156().field_1350);
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_63455);
        class_4587.class_4665 pose = matrices.method_23760();
        class_243 fromDelta = this.from.method_46558().method_1020(offset);
        float length = (float)fromDelta.method_1033();
        float nx = (float)fromDelta.field_1352 / length;
        float ny = (float)fromDelta.field_1351 / length;
        float nz = (float)fromDelta.field_1350 / length;
        bufferBuilder.method_56824(pose, 0.0f, 0.0f, 0.0f).method_39415(-16777216).method_60831(pose, nx, ny, nz).method_75298(RenderHelper.baseLineWidth);
        bufferBuilder.method_56824(pose, (float)fromDelta.field_1352, (float)fromDelta.field_1351, (float)fromDelta.field_1350).method_39415(-16777216).method_60831(pose, nx, ny, nz).method_75298(RenderHelper.baseLineWidth);
        AxiomRenderPipelines.LINES_WITHOUT_WRITE_DEPTH.render(provider.build());
        matrices.method_46416(-boxSize, -boxSize, -boxSize);
        Shapes.shadedBox(provider, matrices.method_23760().method_23761(), 2.0f * boxSize, 2.0f * boxSize, 2.0f * boxSize, -1);
        AxiomRenderPipelines.POSITION_COLOR_IGNORE_DEPTH.render(provider.build());
        matrices.method_22909();
    }

    @Nullable
    public class_2338 getBlockPos(class_243 lookDirection) {
        Vector3f pointOnPlane;
        Vector3f ray;
        class_746 player = class_310.method_1551().field_1724;
        Vector3f origin = player.method_33571().method_46409();
        float t2 = Intersectionf.intersectRayPlane((Vector3fc)origin, (Vector3fc)(ray = lookDirection.method_46409()), (Vector3fc)(pointOnPlane = class_243.method_24953((class_2382)this.from).method_46409()), (Vector3fc)this.normal, (float)1.0E-5f);
        if (t2 < 0.0f) {
            return null;
        }
        Vector3f intersection = origin.add((Vector3fc)ray.mul(t2));
        int x = (int)Math.floor(intersection.x);
        int y = (int)Math.floor(intersection.y);
        int z = (int)Math.floor(intersection.z);
        return new class_2338(x, y, z);
    }
}

