/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows.operations;

import com.moulberry.axiom.block_maps.FamilyMap;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.editor.BlockList;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.widgets.BlockStateWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.operations.TypeReplaceOperation;
import imgui.ImGui;
import java.util.function.Predicate;
import net.minecraft.class_2246;
import net.minecraft.class_2680;

public class TypeReplaceBlocksWindow {
    private static final BlockStateWidget fromWidget = new BlockStateWidget(class_2246.field_10340);
    private static final BlockStateWidget toWidget = new BlockStateWidget(class_2246.field_10474);

    public static void render(BlockList blockList) {
        if (!EditorWindowType.TYPE_REPLACE.isOpen()) {
            return;
        }
        if (EditorWindowType.TYPE_REPLACE.begin("###TypeReplaceBlocks", true)) {
            boolean disable;
            boolean docked = ImGui.isWindowDocked();
            float start = ImGui.getCursorPosX();
            float width = 140.0f;
            if (ImGui.beginTable("##Table", 2, 33280)) {
                ImGui.tableNextColumn();
                String from = AxiomI18n.get("axiom.widget.from_block");
                String to = AxiomI18n.get("axiom.widget.to_block");
                if (!docked) {
                    ImGui.textDisabled(from);
                    ImGui.tableNextColumn();
                    ImGui.textDisabled(to);
                    ImGui.tableNextColumn();
                }
                fromWidget.renderBlockSwitcher(blockList, "From");
                ImGui.tableNextColumn();
                toWidget.renderBlockSwitcher(blockList, "To");
                ImGui.sameLine(0.0f, 0.0f);
                width = Math.max(width, ImGui.getCursorPosX() - start);
                ImGui.dummy(0.0f, 0.0f);
                ImGui.endTable();
            }
            if (disable = Selection.getSelectionBuffer().isEmpty()) {
                ImGui.beginDisabled();
            }
            if (ImGui.button(AxiomI18n.get("axiom.editorui.window.replace.do_replace"), width, 0.0f)) {
                class_2680 first = fromWidget.getBlockState().getVanillaState();
                class_2680 second = toWidget.getBlockState().getVanillaState();
                FamilyMap.AxiomBlockFamily firstFamily = FamilyMap.getFamilyForBase(first.method_26204());
                FamilyMap.AxiomBlockFamily secondFamily = FamilyMap.getFamilyForBase(second.method_26204());
                if (firstFamily != null && secondFamily != null) {
                    TypeReplaceOperation.replace(firstFamily, secondFamily);
                }
            }
            if (disable) {
                ImGui.endDisabled();
            }
        }
        EditorWindowType.TYPE_REPLACE.end();
    }

    static {
        Predicate<CustomBlockState> blockFamilyFilter = blockState -> FamilyMap.getFamilyForBase(blockState.getVanillaState().method_26204()) != null;
        fromWidget.setFilter(blockFamilyFilter);
        toWidget.setFilter(blockFamilyFilter);
    }
}

