/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows.operations;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.operations.RebuildOperation;
import imgui.ImGui;

public class AnimatedRebuildWindow {
    private static final float[] startDelay = new float[]{0.5f};
    private static final float[] maxDelay = new float[]{0.25f};
    private static final float[] airDelay = new float[]{2.0f};
    private static final float[] sameBlockDelay = new float[]{0.2f};
    private static final float[] differentBlockDelay = new float[]{0.5f};
    private static final float[] randomExtraDelay = new float[]{0.1f};
    private static final float[] horizontalDelayMultiplier = new float[]{1.0f};
    private static final float[] verticalDelayMultiplier = new float[]{1.0f};

    public static void render() {
        if (!EditorWindowType.ANIMATED_REBUILD.isOpen()) {
            return;
        }
        if (EditorWindowType.ANIMATED_REBUILD.begin("###AnimatedRebuild", true)) {
            ImGui.text("\u26a0 Ensure you create a backup of your build before using this operation on it");
            ImGuiHelper.separatorWithText("Parameters");
            ImGui.sliderFloat("Start Delay (Seconds)", startDelay, 0.0f, 2.0f);
            ImGui.sliderFloat("Max Delay (Seconds)", maxDelay, 0.0f, 2.0f);
            ImGui.sliderFloat("Air Block Delay (Seconds)", airDelay, 0.0f, 2.0f);
            ImGui.sliderFloat("Same Block Delay (Seconds)", sameBlockDelay, 0.0f, 2.0f);
            ImGui.sliderFloat("Different Block Delay (Seconds)", differentBlockDelay, 0.0f, 2.0f);
            ImGui.sliderFloat("Random Extra Delay (Seconds)", randomExtraDelay, 0.0f, 2.0f);
            ImGui.sliderFloat("Horizontal Multiplier", horizontalDelayMultiplier, 0.0f, 2.0f);
            ImGui.sliderFloat("Vertical Multiplier", verticalDelayMultiplier, 0.0f, 2.0f);
            ImGuiHelper.separatorWithText("Starting Point");
            ImGui.textWrapped("Place Structure Blocks to specify the starting points of the animation. If no Structure Blocks are present then the center is used instead");
            ImGuiHelper.separatorWithText("Presets");
            if (ImGui.button("Default")) {
                AnimatedRebuildWindow.maxDelay[0] = 0.25f;
                AnimatedRebuildWindow.airDelay[0] = 2.0f;
                AnimatedRebuildWindow.sameBlockDelay[0] = 0.2f;
                AnimatedRebuildWindow.differentBlockDelay[0] = 0.5f;
                AnimatedRebuildWindow.randomExtraDelay[0] = 0.1f;
                AnimatedRebuildWindow.horizontalDelayMultiplier[0] = 1.0f;
                AnimatedRebuildWindow.verticalDelayMultiplier[0] = 1.0f;
            }
            ImGui.sameLine();
            if (ImGui.button("Horizontal Sheets")) {
                AnimatedRebuildWindow.maxDelay[0] = 1.0f;
                AnimatedRebuildWindow.airDelay[0] = 1.0f;
                AnimatedRebuildWindow.sameBlockDelay[0] = 1.0f;
                AnimatedRebuildWindow.differentBlockDelay[0] = 1.0f;
                AnimatedRebuildWindow.randomExtraDelay[0] = 0.0f;
                AnimatedRebuildWindow.horizontalDelayMultiplier[0] = 0.0f;
                AnimatedRebuildWindow.verticalDelayMultiplier[0] = 1.0f;
            }
            ImGui.sameLine();
            if (ImGui.button("Very Random")) {
                AnimatedRebuildWindow.maxDelay[0] = 0.25f;
                AnimatedRebuildWindow.airDelay[0] = 0.5f;
                AnimatedRebuildWindow.sameBlockDelay[0] = 0.1f;
                AnimatedRebuildWindow.differentBlockDelay[0] = 0.2f;
                AnimatedRebuildWindow.randomExtraDelay[0] = 2.0f;
                AnimatedRebuildWindow.horizontalDelayMultiplier[0] = 1.0f;
                AnimatedRebuildWindow.verticalDelayMultiplier[0] = 1.0f;
            }
            ImGuiHelper.separatorWithText("Animated Rebuild");
            boolean disabled = Selection.getSelectionBuffer().isEmpty();
            if (disabled) {
                ImGui.beginDisabled();
            }
            if (ImGui.button("Do Animated Rebuild") && !disabled) {
                RebuildOperation.rebuild(new RebuildOperation.RebuildParameters(startDelay[0], maxDelay[0], airDelay[0], sameBlockDelay[0], differentBlockDelay[0], randomExtraDelay[0], horizontalDelayMultiplier[0], verticalDelayMultiplier[0]));
            }
            if (disabled) {
                ImGui.endDisabled();
            }
        }
        EditorWindowType.ANIMATED_REBUILD.end();
    }
}

