/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.views;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.AxiomClient;
import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.editor.views.View;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.utils.NbtHelper;
import com.moulberry.axiom.utils.StringUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_310;

public class ViewManager {
    public static final int MAX_VIEWS = 16;
    private static final List<View> views = new ArrayList<View>();
    static UUID activeView = null;
    static int activeFrames = 0;
    private static String location;
    private static String altLocation;
    private static int saveTimer;

    public static List<View> getViews() {
        return views;
    }

    public static void clear() {
        views.clear();
        ViewManager.addMainView();
    }

    public static void tickSaving() {
        if (location == null) {
            saveTimer = 0;
            return;
        }
        if (saveTimer > 0 && --saveTimer == 0) {
            ViewManager.trySave(true);
        }
    }

    public static void trySave(boolean force) {
        if (!force && saveTimer <= 0) {
            return;
        }
        saveTimer = 0;
        if (location == null) {
            return;
        }
        try {
            Path altPath;
            Path viewDataPath = Axiom.getInstance().getConfigDirectory().resolve("views").resolve(location);
            Path path = altPath = altLocation == null ? null : Axiom.getInstance().getConfigDirectory().resolve("views").resolve(altLocation);
            if (altPath != null && !Files.exists(viewDataPath, new LinkOption[0]) && Files.exists(altPath, new LinkOption[0])) {
                viewDataPath = altPath;
            }
            if (ViewManager.areViewsEmpty()) {
                Files.deleteIfExists(viewDataPath);
                if (altPath != null) {
                    Files.deleteIfExists(altPath);
                }
                return;
            }
            class_2487 compoundTag = new class_2487();
            if (activeView != null) {
                NbtHelper.putUUID(compoundTag, "ActiveView", activeView);
            }
            class_2499 viewsTag = new class_2499();
            for (View view : views) {
                viewsTag.add((Object)view.save());
            }
            compoundTag.method_10566("Views", (class_2520)viewsTag);
            Files.createDirectories(viewDataPath.getParent(), new FileAttribute[0]);
            class_2507.method_30614((class_2487)compoundTag, (Path)viewDataPath);
            if (altPath != null && altPath != viewDataPath && !Files.exists(altPath, new LinkOption[0])) {
                try {
                    Files.createLink(altPath, viewDataPath);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            Axiom.LOGGER.error("Error saving views", e);
        }
    }

    private static boolean areViewsEmpty() {
        if (views.isEmpty()) {
            return true;
        }
        if (views.size() == 1) {
            View view = views.get(0);
            return !view.pinLocation && !view.pinLevel;
        }
        return false;
    }

    public static void updateLocation() {
        if (location != null) {
            ViewManager.trySave(false);
        }
        String oldLocation = location;
        location = null;
        altLocation = null;
        if (class_310.method_1551().method_1496()) {
            location = class_310.method_1551().method_1576().field_23784.method_27005();
        } else {
            SocketAddress address = class_310.method_1551().method_1562().method_48296().method_10755();
            if (address instanceof InetSocketAddress) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
                location = inetSocketAddress.getAddress().getHostAddress();
            } else {
                location = address.toString();
            }
            if (ClientEvents.lastServerAddress != null) {
                altLocation = ClientEvents.lastServerAddress.method_2952();
                altLocation = StringUtils.sanitizePath(altLocation);
            }
        }
        location = StringUtils.sanitizePath(location);
        if (!Objects.equals(oldLocation, location)) {
            views.clear();
            if (location != null) {
                Path viewDataPath = Axiom.getInstance().getConfigDirectory().resolve("views").resolve(location);
                if (!Files.exists(viewDataPath, new LinkOption[0])) {
                    if (altLocation == null) {
                        return;
                    }
                    viewDataPath = Axiom.getInstance().getConfigDirectory().resolve("views").resolve(altLocation);
                    if (!Files.exists(viewDataPath, new LinkOption[0])) {
                        return;
                    }
                }
                try {
                    class_2487 compoundTag = class_2507.method_30613((Path)viewDataPath, (class_2505)class_2505.method_53898());
                    if (compoundTag.method_10545("ActiveView")) {
                        activeView = NbtHelper.getUUID(compoundTag, "ActiveView");
                    }
                    class_2499 tagList = NbtHelper.getList(compoundTag, "Views", 10);
                    for (class_2520 viewTag : tagList) {
                        if (!(viewTag instanceof class_2487)) continue;
                        class_2487 viewCompoundTag = (class_2487)viewTag;
                        views.add(View.load(viewCompoundTag));
                    }
                }
                catch (Exception e) {
                    Axiom.LOGGER.error("Failed to load views", e);
                }
            }
            if (views.isEmpty()) {
                ViewManager.addMainView();
            }
            boolean activeViewIsValid = false;
            for (View view : views) {
                if (!view.uuid.equals(activeView)) continue;
                activeViewIsValid = true;
                break;
            }
            if (!activeViewIsValid) {
                activeView = ViewManager.views.get((int)0).uuid;
            }
        }
    }

    public static void addNewView() {
        if (AxiomClient.hasPermission(AxiomPermission.EDITOR_VIEWS) && views.size() < 16) {
            views.add(new View(AxiomI18n.get("axiom.editorui.view.new_view_name"), UUID.randomUUID(), (class_1657)class_310.method_1551().field_1724));
            ViewManager.dirty();
        }
    }

    private static void addMainView() {
        if (views.isEmpty() || AxiomClient.hasPermission(AxiomPermission.EDITOR_VIEWS) && views.size() < 16) {
            UUID uuid = UUID.randomUUID();
            views.add(new View(AxiomI18n.get("axiom.editorui.view.main_name"), uuid, (class_1657)class_310.method_1551().field_1724));
            activeView = uuid;
            ViewManager.dirty();
        }
    }

    public static void dirty() {
        if (saveTimer <= 0) {
            saveTimer = 200;
        }
    }

    static {
        ViewManager.addMainView();
        location = null;
        altLocation = null;
        saveTimer = 0;
    }
}

