/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.styles;

import imgui.ImGui;
import imgui.ImGuiStyle;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import it.unimi.dsi.fastutil.ints.Int2FloatRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntRBTreeMap;
import java.util.Base64;
import java.util.List;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;

public class StyleHelper {
    private static final List<VarGetter1> VAR_GETTERS = List.of(ImGuiStyle::getWindowBorderSize, ImGuiStyle::getChildBorderSize, ImGuiStyle::getPopupBorderSize, ImGuiStyle::getFrameBorderSize, ImGuiStyle::getTabBorderSize, ImGuiStyle::getWindowRounding, ImGuiStyle::getChildRounding, ImGuiStyle::getPopupRounding, ImGuiStyle::getFrameRounding, ImGuiStyle::getTabRounding, ImGuiStyle::getScrollbarRounding, ImGuiStyle::getGrabRounding);
    private static final List<VarSetter1> VAR_SETTERS = List.of(ImGuiStyle::setWindowBorderSize, ImGuiStyle::setChildBorderSize, ImGuiStyle::setPopupBorderSize, ImGuiStyle::setFrameBorderSize, ImGuiStyle::setTabBorderSize, ImGuiStyle::setWindowRounding, ImGuiStyle::setChildRounding, ImGuiStyle::setPopupRounding, ImGuiStyle::setFrameRounding, ImGuiStyle::setTabRounding, ImGuiStyle::setScrollbarRounding, ImGuiStyle::setGrabRounding);

    public static ModifiedStyleValues calcModifiedStyleValues(ImGuiStyle base, ImGuiStyle current) {
        Int2IntRBTreeMap changedColors = new Int2IntRBTreeMap();
        float[][] baseColors = base.getColors();
        float[][] currentColors = current.getColors();
        for (int i = 0; i < baseColors.length; ++i) {
            int currentColor;
            int baseColor = StyleHelper.convertToInt(baseColors[i]);
            if (baseColor == (currentColor = StyleHelper.convertToInt(currentColors[i]))) continue;
            changedColors.put(i, currentColor);
        }
        Int2FloatRBTreeMap changedVars = new Int2FloatRBTreeMap();
        for (int i = 0; i < VAR_GETTERS.size(); ++i) {
            float currentValue;
            VarGetter1 getter = VAR_GETTERS.get(i);
            float baseValue = getter.get(base);
            if (baseValue == (currentValue = getter.get(current))) continue;
            changedVars.put(i, currentValue);
        }
        return new ModifiedStyleValues((Int2IntMap)changedColors, (Int2FloatMap)changedVars);
    }

    private static int convertToInt(float[] rgba) {
        return ImGui.colorConvertFloat4ToU32(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    public static void applyModifiedStyleValues(ImGuiStyle current, ModifiedStyleValues modifiedStyleValues) {
        for (Int2IntMap.Entry entry : modifiedStyleValues.changedColors.int2IntEntrySet()) {
            current.setColor(entry.getIntKey(), entry.getIntValue());
        }
        for (Int2IntMap.Entry entry : modifiedStyleValues.changedVars.int2FloatEntrySet()) {
            VAR_SETTERS.get(entry.getIntKey()).set(current, entry.getFloatValue());
        }
    }

    public static void copyStyleValues(ImGuiStyle base, ImGuiStyle current) {
        current.setColors(base.getColors());
        current.setWindowBorderSize(base.getWindowBorderSize());
        current.setChildBorderSize(base.getChildBorderSize());
        current.setPopupBorderSize(base.getPopupBorderSize());
        current.setFrameBorderSize(base.getFrameBorderSize());
        current.setTabBorderSize(base.getTabBorderSize());
        current.setWindowRounding(base.getWindowRounding());
        current.setChildRounding(base.getChildRounding());
        current.setPopupRounding(base.getPopupRounding());
        current.setFrameRounding(base.getFrameRounding());
        current.setTabRounding(base.getTabRounding());
        current.setScrollbarRounding(base.getScrollbarRounding());
        current.setGrabRounding(base.getGrabRounding());
    }

    public static interface VarGetter1 {
        public float get(ImGuiStyle var1);
    }

    public record ModifiedStyleValues(Int2IntMap changedColors, Int2FloatMap changedVars) {
        public void write(class_2540 byteBuf) {
            byteBuf.method_10804(this.changedColors.size());
            for (Int2IntMap.Entry entry : this.changedColors.int2IntEntrySet()) {
                byteBuf.method_10804(entry.getIntKey());
                byteBuf.method_53002(entry.getIntValue());
            }
            byteBuf.method_10804(this.changedVars.size());
            for (Int2IntMap.Entry entry : this.changedVars.int2FloatEntrySet()) {
                byteBuf.method_10804(entry.getIntKey());
                byteBuf.method_52941(entry.getFloatValue());
            }
        }

        @Nullable
        public static ModifiedStyleValues read(class_2540 byteBuf) {
            try {
                Int2IntRBTreeMap changedColors = new Int2IntRBTreeMap();
                int changedColorCount = byteBuf.method_10816();
                for (int i = 0; i < changedColorCount; ++i) {
                    changedColors.put(byteBuf.method_10816(), byteBuf.readInt());
                }
                Int2FloatRBTreeMap changedVars = new Int2FloatRBTreeMap();
                int changedVarCount = byteBuf.method_10816();
                for (int i = 0; i < changedVarCount; ++i) {
                    changedVars.put(byteBuf.method_10816(), byteBuf.readFloat());
                }
                return new ModifiedStyleValues((Int2IntMap)changedColors, (Int2FloatMap)changedVars);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static interface VarSetter1 {
        public void set(ImGuiStyle var1, float var2);
    }

    public record Theme(String name, String baseTheme, ModifiedStyleValues values) {
        public String convertToBase64() {
            class_2540 friendlyByteBuf = new class_2540(Unpooled.buffer());
            friendlyByteBuf.method_52998(31325);
            friendlyByteBuf.method_52997(0);
            friendlyByteBuf.method_10788(this.name, 64);
            friendlyByteBuf.method_10788(this.baseTheme, 64);
            this.values.write(friendlyByteBuf);
            byte[] bytes = new byte[friendlyByteBuf.writerIndex()];
            friendlyByteBuf.method_52952(0, bytes);
            return "AS" + Base64.getEncoder().encodeToString(bytes);
        }

        @Nullable
        public static Theme convertFromBase64(String base64) {
            try {
                if (!base64.startsWith("AS")) {
                    return null;
                }
                base64 = base64.substring(2);
                byte[] bytes = Base64.getDecoder().decode(base64);
                class_2540 byteBuf = new class_2540(Unpooled.wrappedBuffer((byte[])bytes));
                if (byteBuf.readShort() != 31325) {
                    return null;
                }
                byteBuf.readByte();
                String name = byteBuf.method_10800(64);
                String baseTheme = byteBuf.method_10800(64);
                ModifiedStyleValues modifiedStyleValues = ModifiedStyleValues.read(byteBuf);
                if (modifiedStyleValues == null) {
                    return null;
                }
                return new Theme(name, baseTheme, modifiedStyleValues);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

