/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.displayentity;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.collections.JoinedList;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.utils.ItemStackDataHelper;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.minecraft.class_10430;
import net.minecraft.class_10432;
import net.minecraft.class_10434;
import net.minecraft.class_10435;
import net.minecraft.class_10437;
import net.minecraft.class_10439;
import net.minecraft.class_10448;
import net.minecraft.class_10451;
import net.minecraft.class_10455;
import net.minecraft.class_10460;
import net.minecraft.class_10461;
import net.minecraft.class_10478;
import net.minecraft.class_10489;
import net.minecraft.class_10544;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1800;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_4590;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_8104;
import net.minecraft.class_811;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ItemList {
    public static ItemList INSTANCE = new ItemList();
    public List<Entry> customEntriesDefinedByPacket = new ArrayList<Entry>();
    private String lastSearch = "";
    private boolean lastOnlyCustomModels = false;
    private List<Entry> searchedItems;
    private final List<Entry> itemsStartsWith = new ArrayList<Entry>();
    private final List<Entry> itemsContains = new ArrayList<Entry>();
    private List<Entry> itemsAll = List.of();
    private List<Entry> itemsAllLengthSorted;
    private List<Entry> itemsCustom;
    private List<Entry> itemsCustomLengthSorted;
    private boolean isDirty = false;
    private static final HashSet<Class<?>> unknownUnbakedClasses = new HashSet();

    private ItemList() {
        this.searchedItems = this.itemsAll;
        this.itemsAllLengthSorted = List.of();
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> {
            if (client) {
                this.isDirty = true;
            }
        });
    }

    public void markDirty() {
        this.isDirty = true;
    }

    private void reload() {
        this.isDirty = false;
        ArrayList<Entry> itemsAll = new ArrayList<Entry>();
        ArrayList<Entry> itemsCustom = new ArrayList<Entry>();
        ArrayList<Entry> itemsCustomImportant = new ArrayList<Entry>();
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            class_7706.method_47330((class_7699)player.field_3944.method_45735(), (player.method_7338() && (Boolean)class_310.method_1551().field_1690.method_47395().method_41753() != false ? 1 : 0) != 0, (class_7225.class_7874)player.method_73183().method_30349());
        }
        class_3300 resourceManager = class_310.method_1551().method_1478();
        Vector3f defaultTranslation = new Vector3f();
        Quaternionf defaultLeftRotation = new Quaternionf();
        Vector3f defaultScale = new Vector3f(1.0f, 1.0f, 1.0f);
        Quaternionf defaultRightRotation = new Quaternionf();
        HashSet<String> registeredModels = new HashSet<String>();
        boolean loggedError = false;
        for (class_1799 stack : class_7706.method_47344().method_45414()) {
            if (stack.method_7960()) continue;
            class_2960 location = class_7923.field_41178.method_10221((Object)stack.method_7909());
            String name = AxiomI18n.get(stack.method_7909().method_7876());
            Entry defaultItemEntry = new Entry(stack, location, ItemList.createSearchKey(name), null, null);
            itemsAll.add(defaultItemEntry);
            List resourceStack = resourceManager.method_14489(class_2960.method_60655((String)location.method_12836(), (String)("items/" + location.method_12832() + ".json")));
            Gson gson = new Gson();
            for (class_3298 resource : resourceStack) {
                try {
                    BufferedReader bufferedReader = resource.method_43039();
                    try {
                        JsonObject object = (JsonObject)class_3518.method_15276((Gson)gson, (Reader)bufferedReader, JsonObject.class);
                        ItemList.registerAdditionalCustomModelsModern(stack, object, registeredModels, defaultTranslation, defaultLeftRotation, defaultScale, defaultRightRotation, location, itemsCustomImportant, itemsCustom);
                    }
                    finally {
                        if (bufferedReader == null) continue;
                        bufferedReader.close();
                    }
                }
                catch (Exception e) {
                    if (loggedError) continue;
                    Axiom.LOGGER.error("Error finding custom model data in resourcepack", e);
                    loggedError = true;
                }
            }
        }
        itemsCustom.addAll(0, itemsCustomImportant);
        itemsCustom.addAll(0, this.customEntriesDefinedByPacket);
        itemsAll.addAll(0, itemsCustom);
        this.itemsAll = Collections.unmodifiableList(itemsAll);
        this.searchedItems = this.itemsAll;
        this.itemsCustom = Collections.unmodifiableList(itemsCustom);
        ArrayList<Entry> itemsAllLengthSorted = new ArrayList<Entry>(itemsAll);
        itemsAllLengthSorted.sort(Comparator.comparingInt(entry -> entry.location.method_12832().length()));
        this.itemsAllLengthSorted = Collections.unmodifiableList(itemsAllLengthSorted);
        ArrayList<Entry> itemsCustomLengthSorted = new ArrayList<Entry>(itemsCustom);
        itemsCustomLengthSorted.sort(Comparator.comparingInt(entry -> entry.location.method_12832().length()));
        this.itemsCustomLengthSorted = Collections.unmodifiableList(itemsCustomLengthSorted);
        this.lastSearch = "";
        this.lastOnlyCustomModels = false;
    }

    private static void registerAdditionalCustomModelsModern(class_1799 stack, JsonObject object, HashSet<String> registeredModels, Vector3f defaultTranslation, Quaternionf defaultLeftRotation, Vector3f defaultScale, Quaternionf defaultRightRotation, class_2960 location, ArrayList<Entry> itemsCustomImportant, ArrayList<Entry> itemsCustom) {
        DataResult model = class_10434.field_55327.parse((DynamicOps)JsonOps.INSTANCE, (Object)object);
        if (!model.isSuccess()) {
            return;
        }
        class_10434 clientItem = (class_10434)model.getOrThrow();
        ItemList.registerAdditionalCustomModelsModernUsingModel(stack, clientItem.comp_3385(), false, registeredModels, defaultTranslation, defaultLeftRotation, defaultScale, defaultRightRotation, location, itemsCustomImportant, itemsCustom);
    }

    private static void registerAdditionalCustomModelsModernUsingModel(class_1799 stack, class_10439.class_10441 unbaked, boolean hadOverride, HashSet<String> registeredModels, Vector3f defaultTranslation, Quaternionf defaultLeftRotation, Vector3f defaultScale, Quaternionf defaultRightRotation, class_2960 location, ArrayList<Entry> itemsCustomImportant, ArrayList<Entry> itemsCustom) {
        String modelName = null;
        if (unbaked instanceof class_10430.class_10431) {
            class_10430.class_10431 blockModel = (class_10430.class_10431)unbaked;
            modelName = blockModel.comp_3383().toString();
        } else {
            if (unbaked instanceof class_10432.class_10433) {
                return;
            }
            if (unbaked instanceof class_10435.class_10436) {
                class_10435.class_10436 composite = (class_10435.class_10436)unbaked;
                for (class_10439.class_10441 model : composite.comp_3386()) {
                    ItemList.registerAdditionalCustomModelsModernUsingModel(stack.method_7972(), model, hadOverride, registeredModels, defaultTranslation, defaultLeftRotation, defaultScale, defaultRightRotation, location, itemsCustomImportant, itemsCustom);
                }
                return;
            }
            if (unbaked instanceof class_10437.class_10438) {
                class_10460 class_104602;
                class_10437.class_10438 conditional = (class_10437.class_10438)unbaked;
                boolean wasConditionAlreadyTrue = conditional.comp_3387().method_65638(stack, null, null, 0, class_811.field_4319);
                if (hadOverride) {
                    class_10439.class_10441 model = wasConditionAlreadyTrue ? conditional.comp_3388() : conditional.comp_3389();
                    ItemList.registerAdditionalCustomModelsModernUsingModel(stack.method_7972(), model, true, registeredModels, defaultTranslation, defaultLeftRotation, defaultScale, defaultRightRotation, location, itemsCustomImportant, itemsCustom);
                }
                if (!((class_104602 = conditional.comp_3387()) instanceof class_10461)) {
                    return;
                }
                class_10461 customModelDataProperty = (class_10461)class_104602;
                boolean modifiedCondition = !wasConditionAlreadyTrue;
                class_1799 modifiedStack = stack.method_7972();
                class_9280 customModelData = (class_9280)modifiedStack.method_58694(class_9334.field_49637);
                if (customModelData == null) {
                    customModelData = class_9280.field_55212;
                }
                ArrayList<Boolean> booleans = new ArrayList<Boolean>(customModelData.comp_3355());
                while (booleans.size() <= customModelDataProperty.comp_3407()) {
                    booleans.add(false);
                }
                booleans.set(customModelDataProperty.comp_3407(), modifiedCondition);
                class_9280 newCustomModelData = new class_9280(customModelData.comp_3354(), booleans, customModelData.comp_3356(), customModelData.comp_3357());
                modifiedStack.method_57379(class_9334.field_49637, (Object)newCustomModelData);
                class_10439.class_10441 model = modifiedCondition ? conditional.comp_3388() : conditional.comp_3389();
                ItemList.registerAdditionalCustomModelsModernUsingModel(modifiedStack, model, true, registeredModels, defaultTranslation, defaultLeftRotation, defaultScale, defaultRightRotation, location, itemsCustomImportant, itemsCustom);
                return;
            }
            if (unbaked instanceof class_10544.class_10545) {
                return;
            }
            if (unbaked instanceof class_10448.class_10450) {
                class_1800 value2;
                class_10448.class_10450 rangeSelect = (class_10448.class_10450)unbaked;
                if (hadOverride && rangeSelect.comp_3398().isPresent()) {
                    boolean alreadyMatches = false;
                    float value2 = rangeSelect.comp_3395().method_65644(stack, null, null, 0) * rangeSelect.comp_3396();
                    if (!Float.isNaN(value2)) {
                        for (class_10448.class_10449 entry : rangeSelect.comp_3397()) {
                            if (!(entry.comp_3393() <= value2)) continue;
                            alreadyMatches = true;
                            break;
                        }
                    }
                    if (!alreadyMatches) {
                        ItemList.registerAdditionalCustomModelsModernUsingModel(stack.method_7972(), (class_10439.class_10441)rangeSelect.comp_3398().get(), true, registeredModels, defaultTranslation, defaultLeftRotation, defaultScale, defaultRightRotation, location, itemsCustomImportant, itemsCustom);
                    }
                }
                if (!((value2 = rangeSelect.comp_3395()) instanceof class_10478)) {
                    return;
                }
                class_10478 customModelDataProperty = (class_10478)value2;
                ArrayList list = new ArrayList(rangeSelect.comp_3397());
                list.sort(class_10448.class_10449.field_55360);
                for (class_10448.class_10449 entry : list) {
                    float conditionValue = entry.comp_3393() / rangeSelect.comp_3396();
                    class_1799 modifiedStack = stack.method_7972();
                    class_9280 customModelData = (class_9280)modifiedStack.method_58694(class_9334.field_49637);
                    if (customModelData == null) {
                        customModelData = class_9280.field_55212;
                    }
                    ArrayList<Float> floats = new ArrayList<Float>(customModelData.comp_3354());
                    while (floats.size() <= customModelDataProperty.comp_3411()) {
                        floats.add(Float.valueOf(0.0f));
                    }
                    floats.set(customModelDataProperty.comp_3411(), Float.valueOf(conditionValue));
                    class_9280 newCustomModelData = new class_9280(floats, customModelData.comp_3355(), customModelData.comp_3356(), customModelData.comp_3357());
                    modifiedStack.method_57379(class_9334.field_49637, (Object)newCustomModelData);
                    ItemList.registerAdditionalCustomModelsModernUsingModel(modifiedStack, entry.comp_3394(), true, registeredModels, defaultTranslation, defaultLeftRotation, defaultScale, defaultRightRotation, location, itemsCustomImportant, itemsCustom);
                }
            } else {
                if (unbaked instanceof class_10451.class_10453) {
                    Object object;
                    class_10451.class_10453 select2 = (class_10451.class_10453)unbaked;
                    if (hadOverride && select2.comp_3402().isPresent()) {
                        boolean alreadyMatches = false;
                        Object value = select2.comp_3401().comp_3403().method_65676(stack, null, null, 0, class_811.field_4319);
                        if (value != null) {
                            for (class_10451.class_10452 aCase : select2.comp_3401().comp_3404()) {
                                if (!aCase.comp_3399().contains(value)) continue;
                                alreadyMatches = true;
                                break;
                            }
                        }
                        if (!alreadyMatches) {
                            ItemList.registerAdditionalCustomModelsModernUsingModel(stack.method_7972(), (class_10439.class_10441)select2.comp_3402().get(), true, registeredModels, defaultTranslation, defaultLeftRotation, defaultScale, defaultRightRotation, location, itemsCustomImportant, itemsCustom);
                        }
                    }
                    if (!((object = select2.comp_3401().comp_3403()) instanceof class_10489)) {
                        return;
                    }
                    class_10489 customModelDataProperty = (class_10489)object;
                    for (class_10451.class_10452 entry : select2.comp_3401().comp_3404()) {
                        Object conditionValue;
                        if (entry.comp_3399().isEmpty() || !((conditionValue = entry.comp_3399().get(0)) instanceof String)) continue;
                        String string = (String)conditionValue;
                        class_1799 modifiedStack = stack.method_7972();
                        class_9280 customModelData = (class_9280)modifiedStack.method_58694(class_9334.field_49637);
                        if (customModelData == null) {
                            customModelData = class_9280.field_55212;
                        }
                        ArrayList<String> strings = new ArrayList<String>(customModelData.comp_3356());
                        while (strings.size() <= customModelDataProperty.comp_3415()) {
                            strings.add("");
                        }
                        strings.set(customModelDataProperty.comp_3415(), string);
                        class_9280 newCustomModelData = new class_9280(customModelData.comp_3354(), customModelData.comp_3355(), strings, customModelData.comp_3357());
                        modifiedStack.method_57379(class_9334.field_49637, (Object)newCustomModelData);
                        ItemList.registerAdditionalCustomModelsModernUsingModel(modifiedStack, entry.comp_3400(), true, registeredModels, defaultTranslation, defaultLeftRotation, defaultScale, defaultRightRotation, location, itemsCustomImportant, itemsCustom);
                    }
                    return;
                }
                if (unbaked instanceof class_10455.class_10456) {
                    return;
                }
                if (unknownUnbakedClasses.add(unbaked.getClass())) {
                    System.err.println("Axiom: Unknown unbaked model type, unhandled: " + String.valueOf(unbaked.getClass()));
                    return;
                }
            }
        }
        if (!hadOverride || modelName == null || !registeredModels.add(modelName)) {
            return;
        }
        stack = stack.method_7972();
        ItemStackDataHelper.setHoverName(stack, (class_2561)class_2561.method_43470((String)modelName).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1054)));
        String searchKey = modelName.replaceAll("[^a-zA-Z]", "");
        if (searchKey.isEmpty()) {
            searchKey = AxiomI18n.get(stack.method_7909().method_7876());
        }
        Entry entry = new Entry(stack, location, ItemList.createSearchKey(searchKey), null, null);
        itemsCustom.add(entry);
    }

    private static void registerAdditionalCustomModelsLegacy(class_1799 stack, JsonObject object, HashSet<String> registeredModels, Vector3f defaultTranslation, Quaternionf defaultLeftRotation, Vector3f defaultScale, Quaternionf defaultRightRotation, class_2960 location, ArrayList<Entry> itemsCustomImportant, ArrayList<Entry> itemsCustom) {
        JsonArray overrides = object.getAsJsonArray("overrides");
        if (overrides == null) {
            return;
        }
        for (JsonElement override : overrides) {
            try {
                JsonPrimitive jsonPrimitive;
                String searchKey;
                JsonElement leftRotation;
                JsonPrimitive jsonPrimitive2;
                JsonObject overrideObj = override.getAsJsonObject();
                JsonObject predicate = overrideObj.getAsJsonObject("predicate");
                JsonElement customModelData = predicate.get("custom_model_data");
                if (customModelData == null) continue;
                int customModelDataInt = customModelData.getAsInt();
                class_1799 customStack = stack.method_7972();
                String model = overrideObj.get("model").getAsString();
                JsonElement jsonElement = overrideObj.get("axiom:hide");
                if (jsonElement instanceof JsonPrimitive && (jsonPrimitive2 = (JsonPrimitive)jsonElement).getAsBoolean() || !registeredModels.add(model)) continue;
                ItemStackDataHelper.setCustomModelData(customStack, customModelDataInt);
                ItemStackDataHelper.setHoverName(customStack, (class_2561)class_2561.method_43470((String)model).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1054)));
                class_4590 defaultItemDisplayTransformation = null;
                JsonElement jsonElement2 = overrideObj.get("axiom:default_transform");
                if (jsonElement2 instanceof JsonObject) {
                    JsonArray jsonArray;
                    JsonObject defaultTransform = (JsonObject)jsonElement2;
                    Vector3f translation = defaultTranslation;
                    leftRotation = defaultLeftRotation;
                    Vector3f scale = defaultScale;
                    Quaternionf rightRotation = defaultRightRotation;
                    JsonElement jsonElement3 = defaultTransform.get("translation");
                    if (jsonElement3 instanceof JsonArray && (jsonArray = (JsonArray)jsonElement3).size() == 3) {
                        translation = new Vector3f(jsonArray.get(0).getAsFloat(), jsonArray.get(1).getAsFloat(), jsonArray.get(2).getAsFloat());
                    }
                    if ((jsonElement3 = defaultTransform.get("left_rotation")) instanceof JsonArray && (jsonArray = (JsonArray)jsonElement3).size() == 4) {
                        leftRotation = new Quaternionf(jsonArray.get(0).getAsFloat(), jsonArray.get(1).getAsFloat(), jsonArray.get(2).getAsFloat(), jsonArray.get(3).getAsFloat());
                    }
                    if ((jsonElement3 = defaultTransform.get("scale")) instanceof JsonArray && (jsonArray = (JsonArray)jsonElement3).size() == 3) {
                        scale = new Vector3f(jsonArray.get(0).getAsFloat(), jsonArray.get(1).getAsFloat(), jsonArray.get(2).getAsFloat());
                    }
                    if ((jsonElement3 = defaultTransform.get("right_rotation")) instanceof JsonArray && (jsonArray = (JsonArray)jsonElement3).size() == 4) {
                        rightRotation = new Quaternionf(jsonArray.get(0).getAsFloat(), jsonArray.get(1).getAsFloat(), jsonArray.get(2).getAsFloat(), jsonArray.get(3).getAsFloat());
                    }
                    defaultItemDisplayTransformation = new class_4590((Vector3fc)translation, (Quaternionfc)leftRotation, (Vector3fc)scale, (Quaternionfc)rightRotation);
                }
                class_8104 defaultItemDisplayBrightness = null;
                leftRotation = overrideObj.get("axiom:default_brightness");
                if (leftRotation instanceof JsonObject) {
                    JsonObject jsonObject = (JsonObject)leftRotation;
                    defaultItemDisplayBrightness = new class_8104(jsonObject.get("block").getAsInt(), jsonObject.get("sky").getAsInt());
                }
                if ((searchKey = model.replaceAll("[^a-zA-Z]", "")).isEmpty()) {
                    searchKey = AxiomI18n.get(stack.method_7909().method_7876());
                }
                Entry entry = new Entry(customStack, location, ItemList.createSearchKey(searchKey), defaultItemDisplayTransformation, defaultItemDisplayBrightness);
                JsonElement jsonElement4 = overrideObj.get("axiom:important");
                if (jsonElement4 instanceof JsonPrimitive && (jsonPrimitive = (JsonPrimitive)jsonElement4).getAsBoolean()) {
                    itemsCustomImportant.add(entry);
                    continue;
                }
                itemsCustom.add(entry);
            }
            catch (Exception exception) {}
        }
    }

    public static String createSearchKey(String string) {
        StringBuilder searchKey = new StringBuilder();
        for (char c : string.toLowerCase(Locale.ROOT).toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            searchKey.append(c);
        }
        return searchKey.toString();
    }

    public void search(String search, boolean onlyCustomModels) {
        if (this.isDirty) {
            this.reload();
        }
        if ((search = ItemList.createSearchKey(search)).equals(this.lastSearch) && this.lastOnlyCustomModels == onlyCustomModels) {
            return;
        }
        if (search.isBlank()) {
            this.searchedItems = onlyCustomModels ? this.itemsCustom : this.itemsAll;
            this.lastOnlyCustomModels = onlyCustomModels;
            this.lastSearch = search;
            return;
        }
        if (!(this.searchedItems instanceof JoinedList) || !search.startsWith(this.lastSearch) || this.lastOnlyCustomModels != onlyCustomModels) {
            this.itemsStartsWith.clear();
            this.itemsContains.clear();
            for (Entry entry2 : onlyCustomModels ? this.itemsCustomLengthSorted : this.itemsAllLengthSorted) {
                if (entry2.searchKey.startsWith(search)) {
                    this.itemsStartsWith.add(entry2);
                    continue;
                }
                if (!entry2.searchKey.contains(search)) continue;
                this.itemsContains.add(entry2);
            }
            this.searchedItems = new JoinedList<Entry>(this.itemsStartsWith, this.itemsContains);
        } else {
            String searchF = search;
            this.itemsContains.removeIf(entry -> !entry.searchKey.contains(searchF));
            this.itemsStartsWith.removeIf(entry -> {
                if (entry.searchKey.startsWith(searchF)) {
                    return false;
                }
                if (entry.searchKey.contains(searchF)) {
                    this.itemsContains.add((Entry)entry);
                }
                return true;
            });
        }
        this.lastSearch = search;
        this.lastOnlyCustomModels = onlyCustomModels;
    }

    public String getLastSearch() {
        return this.lastSearch;
    }

    public List<Entry> getItems() {
        if (this.isDirty) {
            this.reload();
        }
        return this.searchedItems;
    }

    public record Entry(class_1799 itemStack, class_2960 location, String searchKey, @Nullable class_4590 defaultItemDisplayTransformation, @Nullable class_8104 defaultItemDisplayBrightness) {
    }
}

