/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.buildertools;

import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.buildertools.BuilderTool;
import com.moulberry.axiom.buildertools.BuilderToolManager;
import com.moulberry.axiom.buildertools.BuilderToolSelectionState;
import com.moulberry.axiom.buildertools.PendingAction;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.hooks.ScreenRenderHook;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.packets.AxiomServerboundSpawnEntity;
import com.moulberry.axiom.packets.SupportedProtocol;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.utils.IntMatrix;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import com.moulberry.axiom.world_modification.HistoryEntry;
import com.moulberry.axiom.world_modification.undo.DeleteEntityAdditionalUndoOperation;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1530;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Matrix4f;

public class CloneBuilderTool
implements BuilderTool {
    private final BuilderToolSelectionState selectionState = new BuilderToolSelectionState();
    private final IntMatrix transformMatrix = new IntMatrix();
    private boolean reclone = false;
    private class_2338.class_2339 regionOffset = null;
    private SelectionBuffer selectionBuffer = null;
    private ChunkedBlockRegion blockRegion = null;
    private Long2ObjectMap<CompressedBlockEntity> blockEntities = null;
    private final PendingAction pendingAction = new PendingAction();
    private int pendingCopyId = 0;

    @Override
    public void renderScreen(class_332 guiGraphics, int screenWidth, int screenHeight, float partialTick) {
        if (this.blockRegion != null) {
            if (this.reclone) {
                BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.clone.finish"), class_310.method_1551().field_1690.field_1886, 0);
                BuilderTool.renderScrollHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.clone.scroll"), 1);
            } else {
                BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.cancel"), class_310.method_1551().field_1690.field_1886, 0);
                BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.confirm"), class_310.method_1551().field_1690.field_1904, 1);
                BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.move_to"), class_310.method_1551().field_1690.field_1871, 2);
            }
            return;
        }
        this.selectionState.renderScreen(guiGraphics, screenWidth, screenHeight);
    }

    @Override
    public void handleInput(boolean nudgeForwards, boolean nudgeBackwards, boolean delete) {
        if (nudgeForwards) {
            this.nudge(1);
        }
        if (nudgeBackwards) {
            this.nudge(-1);
        }
        if (delete) {
            if (this.selectionBuffer == null) {
                this.selectionState.createSelectionBuffer().callDelete(HistoryEntry.MODIFIER_CAN_BE_UNDONE_INGAME);
            }
            this.reset(false);
        }
    }

    @Override
    public void renderWorld(class_4184 camera, long time, class_4587 matrices, Matrix4f projection) {
        if (this.regionOffset != null) {
            boolean flipPressed;
            boolean rotatePressed = Keybinds.ROTATE_PLACEMENT.isPressed(false);
            ChunkedBlockRegion newBlockRegion = BuilderTool.handleMoveableBlockBuffer(camera, time, matrices, projection, this.blockRegion, (class_2338)this.regionOffset, this.transformMatrix, rotatePressed, flipPressed = Keybinds.FLIP_PLACEMENT.isPressed(false));
            if (this.blockRegion != newBlockRegion) {
                this.blockRegion = newBlockRegion;
                this.reclone = false;
            }
            return;
        }
        if (this.selectionState.hasSelection()) {
            boolean rotatePressed = Keybinds.ROTATE_PLACEMENT.isPressed(false);
            boolean flipPressed = Keybinds.FLIP_PLACEMENT.isPressed(false);
            if (rotatePressed || flipPressed) {
                this.initiateClone();
            }
            if (this.blockRegion != null) {
                if (rotatePressed) {
                    this.blockRegion = this.blockRegion.rotate(class_2350.class_2351.field_11052, -1);
                    this.transformMatrix.rotateY(-1);
                }
                if (flipPressed) {
                    class_2350 direction = BuilderTool.calculateDirection();
                    this.blockRegion = this.blockRegion.flip(direction.method_10166());
                    this.transformMatrix.flip(direction.method_10166());
                }
            } else {
                if (rotatePressed) {
                    this.pendingAction.rotateY(-1);
                }
                if (flipPressed) {
                    class_2350 direction = BuilderTool.calculateDirection();
                    switch (direction.method_10166()) {
                        case field_11048: {
                            this.pendingAction.flipX();
                            break;
                        }
                        case field_11052: {
                            this.pendingAction.flipY();
                            break;
                        }
                        case field_11051: {
                            this.pendingAction.flipZ();
                        }
                    }
                }
            }
        }
        this.selectionState.renderWorld(camera, time, matrices, projection);
    }

    @Override
    public boolean setPos1(class_2338 position) {
        if (this.regionOffset == null) {
            this.selectionState.setPos1(position);
            this.showTextInActionBar();
        }
        return true;
    }

    @Override
    public boolean setPos2(class_2338 position) {
        if (this.regionOffset == null) {
            this.selectionState.setPos2(position);
            this.showTextInActionBar();
        }
        return true;
    }

    @Override
    public void leftClick(class_239 hitResult) {
        if (this.regionOffset != null) {
            this.reset(false);
        } else if (hitResult.method_17783() == class_239.class_240.field_1332 && hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            this.selectionState.leftClick(blockHitResult);
            this.showTextInActionBar();
        }
    }

    @Override
    public void rightClick(class_239 hitResult) {
        if (this.regionOffset != null) {
            if (this.reclone) {
                return;
            }
            this.apply();
            this.reclone = true;
        } else if (hitResult.method_17783() == class_239.class_240.field_1332 && hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            this.selectionState.rightClick(blockHitResult);
            this.showTextInActionBar();
        }
    }

    @Override
    public void middleClick(class_239 hitResult) {
        if (hitResult.method_17783() == class_239.class_240.field_1333 && this.regionOffset != null && class_310.method_1551().field_1724 != null) {
            this.regionOffset.method_10101((class_2382)class_310.method_1551().field_1724.method_24515());
            this.reclone = false;
            this.showTextInActionBar();
        } else if (hitResult.method_17783() == class_239.class_240.field_1332 && hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            if (this.regionOffset != null) {
                BuilderTool.setOffsetFromBlock(blockHitResult, this.regionOffset, this.selectionBuffer.min(), this.selectionBuffer.max());
                this.reclone = false;
            } else {
                this.selectionState.middleClick(blockHitResult);
            }
            this.showTextInActionBar();
        }
    }

    private void apply() {
        if (this.regionOffset != null) {
            Long2ObjectOpenHashMap blockEntities;
            class_2338 offset = this.regionOffset.method_10062();
            class_2338 min2 = this.blockRegion.min();
            class_2338 max2 = this.blockRegion.max();
            int minX = Math.min(min2.method_10263(), max2.method_10263());
            int minY = Math.min(min2.method_10264(), max2.method_10264());
            int minZ = Math.min(min2.method_10260(), max2.method_10260());
            int maxX = Math.max(min2.method_10263(), max2.method_10263());
            int maxY = Math.max(min2.method_10264(), max2.method_10264());
            int maxZ = Math.max(min2.method_10260(), max2.method_10260());
            float partialX = (float)((maxX - minX) % 2) / 2.0f;
            float partialY = (float)((maxY - minY) % 2) / 2.0f;
            float partialZ = (float)((maxZ - minZ) % 2) / 2.0f;
            int shiftX = (int)(-Math.floor(this.transformMatrix.transformDoubleX(partialX, partialY, partialZ)));
            int shiftY = (int)(-Math.floor(this.transformMatrix.transformDoubleY(partialX, partialY, partialZ)));
            int shiftZ = (int)(-Math.floor(this.transformMatrix.transformDoubleZ(partialX, partialY, partialZ)));
            offset = offset.method_10069(shiftX, shiftY, shiftZ);
            String description = AxiomI18n.get("axiom.history_description.cloned", NumberFormat.getInstance().format(this.blockRegion.count()));
            if (this.blockEntities.isEmpty() || this.transformMatrix.isIdentity()) {
                blockEntities = this.blockEntities;
            } else {
                blockEntities = new Long2ObjectOpenHashMap();
                for (Long2ObjectMap.Entry entry : this.blockEntities.long2ObjectEntrySet()) {
                    int nz;
                    int ny;
                    int z;
                    int y;
                    long pos = entry.getLongKey();
                    int x = class_2338.method_10061((long)pos);
                    int nx = this.transformMatrix.transformX(x, y = class_2338.method_10071((long)pos), z = class_2338.method_10083((long)pos));
                    if (this.blockRegion.getBlockStateOrAir(nx, ny = this.transformMatrix.transformY(x, y, z), nz = this.transformMatrix.transformZ(x, y, z)).method_26215()) continue;
                    blockEntities.put(class_2338.method_10064((int)nx, (int)ny, (int)nz), (Object)((CompressedBlockEntity)entry.getValue()));
                }
            }
            if (this.blockRegion.isEmpty()) {
                return;
            }
            DeleteEntityAdditionalUndoOperation additionalUndoOperation = null;
            ArrayList<AxiomServerboundSpawnEntity.SpawnEntry> spawnEntries = new ArrayList<AxiomServerboundSpawnEntity.SpawnEntry>();
            class_638 level = class_310.method_1551().field_1687;
            if (level != null && ClientEvents.serverSupportsProtocol(SupportedProtocol.CREATE_ENTITY) && BuilderToolManager.copyEntities) {
                class_238 bounds = class_238.method_54784((class_2338)this.selectionBuffer.min(), (class_2338)this.selectionBuffer.max());
                class_2338 selectionBufferCenter = this.selectionBuffer.center();
                int originalOffsetX = selectionBufferCenter.method_10263();
                int originalOffsetY = selectionBufferCenter.method_10264();
                int originalOffsetZ = selectionBufferCenter.method_10260();
                List entities = level.method_8333((class_1297)class_310.method_1551().field_1724, bounds, BuilderTool::shouldEntityByCopied);
                if (!entities.isEmpty()) {
                    ArrayList<UUID> uuids = new ArrayList<UUID>();
                    for (class_1297 entity : entities) {
                        float newPitch;
                        float newYaw;
                        class_243 position;
                        class_243 entityPos;
                        if (entity instanceof class_1530) {
                            class_1530 hangingEntity = (class_1530)entity;
                            entityPos = class_243.method_24953((class_2382)hangingEntity.method_59940());
                        } else {
                            entityPos = entity.method_73189();
                        }
                        double x = entityPos.field_1352 - (double)originalOffsetX - 0.5;
                        double y = entityPos.field_1351 - (double)originalOffsetY - 0.5;
                        double z = entityPos.field_1350 - (double)originalOffsetZ - 0.5;
                        if (this.transformMatrix.isIdentity()) {
                            position = new class_243(x + (double)offset.method_10263() + 0.5, y + (double)offset.method_10264() + 0.5, z + (double)offset.method_10260() + 0.5);
                            newYaw = entity.method_36454();
                            newPitch = entity.method_36455();
                        } else {
                            double nx = this.transformMatrix.transformDoubleX(x, y, z);
                            double ny = this.transformMatrix.transformDoubleY(x, y, z);
                            double nz = this.transformMatrix.transformDoubleZ(x, y, z);
                            position = new class_243(nx + (double)offset.method_10263() + 0.5, ny + (double)offset.method_10264() + 0.5, nz + (double)offset.method_10260() + 0.5);
                            class_243 viewVector = entity.method_5828(1.0f);
                            double viewX = this.transformMatrix.transformDoubleX(viewVector.field_1352, viewVector.field_1351, viewVector.field_1350);
                            double viewY = this.transformMatrix.transformDoubleY(viewVector.field_1352, viewVector.field_1351, viewVector.field_1350);
                            double viewZ = this.transformMatrix.transformDoubleZ(viewVector.field_1352, viewVector.field_1351, viewVector.field_1350);
                            double viewXZ = Math.sqrt(viewX * viewX + viewZ * viewZ);
                            newPitch = class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)viewY, (double)viewXZ) * 57.2957763671875))));
                            newYaw = class_3532.method_15393((float)((float)(class_3532.method_15349((double)viewZ, (double)viewX) * 57.2957763671875) - 90.0f));
                            newPitch = (float)Math.round(newPitch * 256.0f) / 256.0f;
                            newYaw = (float)Math.round(newYaw * 256.0f) / 256.0f;
                        }
                        UUID newUuid = UUID.randomUUID();
                        spawnEntries.add(new AxiomServerboundSpawnEntity.SpawnEntry(newUuid, position, newYaw, newPitch, entity.method_5667(), null));
                        uuids.add(newUuid);
                    }
                    additionalUndoOperation = new DeleteEntityAdditionalUndoOperation(uuids);
                }
            }
            int flags = HistoryEntry.MODIFIER_CAN_BE_UNDONE_INGAME;
            if (BuilderToolManager.keepExisting) {
                flags |= HistoryEntry.MODIFIER_KEEP_EXISTING;
            }
            RegionHelper.pushBlockRegionChangeOffset(this.blockRegion, (Long2ObjectMap<CompressedBlockEntity>)blockEntities, offset, description, flags, additionalUndoOperation);
            if (!spawnEntries.isEmpty()) {
                new AxiomServerboundSpawnEntity(spawnEntries).send();
            }
        }
    }

    @Override
    public boolean scroll(int scroll) {
        if (!this.selectionState.hasSelection()) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        this.reclone = false;
        if (this.regionOffset == null) {
            if (ClientEvents.builderToolNudgeScrollKeyBind.method_1434()) {
                this.nudge(scroll);
                return true;
            }
            this.initiateClone();
        }
        if (this.regionOffset != null) {
            this.regionOffset.method_10104(BuilderTool.calculateDirection(), scroll);
            this.showTextInActionBar();
        } else {
            this.pendingAction.move(BuilderTool.calculateDirection(), scroll);
        }
        return true;
    }

    private void nudge(int amount) {
        if (this.regionOffset != null) {
            return;
        }
        this.selectionState.nudge(amount);
        this.showTextInActionBar();
    }

    private void showTextInActionBar() {
        if (this.regionOffset != null) {
            class_2338 center = this.selectionBuffer.center();
            ScreenRenderHook.setOverlayText((class_2561)class_2561.method_43470((String)"Offset: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(this.regionOffset.method_10263() - center.method_10263() + " ")).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(this.regionOffset.method_10264() - center.method_10264() + " ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)("" + (this.regionOffset.method_10260() - center.method_10260()))).method_27692(class_124.field_1075)));
        } else {
            this.selectionState.showTextInActionBar();
        }
    }

    private void initiateClone() {
        int copyId;
        if (this.pendingCopyId != 0) {
            return;
        }
        SelectionBuffer selection = this.selectionState.createSelectionBuffer();
        class_2338 selectionOffset = selection.center();
        if (selection.isEmpty() || selectionOffset == null) {
            return;
        }
        int offsetX = selectionOffset.method_10263();
        int offsetY = selectionOffset.method_10264();
        int offsetZ = selectionOffset.method_10260();
        int randomId = ThreadLocalRandom.current().nextInt();
        this.pendingCopyId = copyId = randomId == 0 ? 1 : randomId;
        this.pendingAction.reset();
        this.reclone = false;
        selection.callCopy(false, BuilderToolManager.copyAir).thenAccept(copyResult -> {
            if (this.pendingCopyId != copyId) {
                return;
            }
            this.pendingCopyId = 0;
            if (copyResult.chunkedBlockRegion().isEmpty()) {
                this.reset(false);
                return;
            }
            this.transformMatrix.identity();
            this.blockRegion = copyResult.chunkedBlockRegion();
            this.blockEntities = copyResult.blockEntities();
            if (this.selectionBuffer != null) {
                this.selectionBuffer.close();
            }
            this.selectionBuffer = selection;
            this.regionOffset = new class_2338.class_2339(offsetX, offsetY, offsetZ);
            this.regionOffset.method_10100(this.pendingAction.moveX, this.pendingAction.moveY, this.pendingAction.moveZ);
            this.showTextInActionBar();
            this.blockRegion = this.blockRegion.rotate(class_2350.class_2351.field_11052, this.pendingAction.rotateY);
            this.transformMatrix.rotateY(this.pendingAction.rotateY);
            if (this.pendingAction.flipX) {
                this.blockRegion = this.blockRegion.flip(class_2350.class_2351.field_11048);
                this.transformMatrix.flip(class_2350.class_2351.field_11048);
            }
            if (this.pendingAction.flipY) {
                this.blockRegion = this.blockRegion.flip(class_2350.class_2351.field_11052);
                this.transformMatrix.flip(class_2350.class_2351.field_11052);
            }
            if (this.pendingAction.flipZ) {
                this.blockRegion = this.blockRegion.flip(class_2350.class_2351.field_11051);
                this.transformMatrix.flip(class_2350.class_2351.field_11051);
            }
            this.pendingAction.reset();
        });
    }

    @Override
    public boolean shouldRenderBlockOutline(class_2338 blockPos) {
        if (this.regionOffset != null) {
            return false;
        }
        return !this.selectionState.selectionContains(blockPos);
    }

    @Override
    public String getName() {
        return AxiomI18n.get("axiom.buildertool.clone");
    }

    @Override
    public List<String> getKeyHints() {
        if (this.regionOffset != null) {
            return List.of("Ctrl+R - Rotate", "Ctrl+F - Flip");
        }
        return List.of();
    }

    @Override
    public boolean canBeReset() {
        return this.selectionState.hasSelection() || this.regionOffset != null;
    }

    @Override
    public void reset(boolean apply) {
        if (apply && this.selectionState.hasSelection() && this.regionOffset != null && !this.reclone) {
            this.apply();
        }
        this.selectionState.resetSelection();
        this.reclone = false;
        this.pendingCopyId = 0;
        this.pendingAction.reset();
        this.blockRegion = null;
        this.transformMatrix.identity();
        this.regionOffset = null;
        if (this.selectionBuffer != null) {
            this.selectionBuffer.close();
            this.selectionBuffer = null;
        }
    }

    @Override
    public BuilderToolSelectionState.Restore getSelectionRestore() {
        return this.selectionState.getSelectionRestore();
    }

    @Override
    public void applySelectionRestore(BuilderToolSelectionState.Restore restore) {
        this.selectionState.restoreFrom(restore);
    }

    @Override
    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.BUILDERTOOL_CLONE, AxiomPermission.BUILD_SECTION);
    }
}

