/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.moulberry.axiom.utils.ARGB32;
import com.moulberry.axiom.utils.StringUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_12206;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2477;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class BiomeDataManager {
    private static final BiomeDataManager INSTANCE = new BiomeDataManager();
    private WeakReference<class_2378<class_1959>> biomeRegistryReference = null;
    private List<BiomeDataEntry> biomes = new ArrayList<BiomeDataEntry>();
    private Map<class_5321<class_1959>, BiomeDataEntry> biomeMap = new HashMap<class_5321<class_1959>, BiomeDataEntry>();
    private boolean justRefreshed = false;

    public static BiomeDataManager get() {
        Optional registry;
        class_634 connection = class_310.method_1551().method_1562();
        Optional optional = registry = connection == null ? Optional.empty() : connection.method_29091().method_46759(class_7924.field_41236);
        if (registry.isEmpty()) {
            return null;
        }
        BiomeDataManager.INSTANCE.justRefreshed = false;
        class_2378 currentRegistry = (class_2378)registry.get();
        if (BiomeDataManager.INSTANCE.biomeRegistryReference == null || !BiomeDataManager.INSTANCE.biomeRegistryReference.refersTo((class_2378<class_1959>)currentRegistry)) {
            INSTANCE.refresh((class_2378<class_1959>)currentRegistry);
        }
        return INSTANCE;
    }

    private static int getFogColor(class_1959 biome) {
        return (Integer)biome.method_75734().method_75663(class_12206.field_63742, (Object)((Integer)class_12206.field_63742.method_75650()));
    }

    private void refresh(class_2378<class_1959> registry) {
        this.biomes.clear();
        this.biomeMap.clear();
        this.biomeRegistryReference = new WeakReference<class_2378<class_1959>>(registry);
        int plainsFog = BiomeDataManager.getFogColor((class_1959)((class_6880.class_6883)registry.method_46746(class_1972.field_9451).orElseThrow()).comp_349());
        int plainsFogRed = ARGB32.red(plainsFog);
        int plainsFogGreen = ARGB32.green(plainsFog);
        int plainsFogBlue = ARGB32.blue(plainsFog);
        for (Map.Entry entry : registry.method_29722()) {
            int biomeFogBlue;
            int blueDistance;
            int biomeFogGreen;
            int greenDistance;
            class_5321 biomeKey = (class_5321)entry.getKey();
            String biomeKeyPath = biomeKey.method_29177().method_12832();
            class_2960 location = biomeKey.method_29177();
            String biomeTranslationKey = "biome." + location.method_12836() + "." + location.method_12832();
            String biomeString = class_2477.method_10517().method_4679(biomeTranslationKey, StringUtils.convertResourceToPretty(location));
            class_1959 biome = (class_1959)entry.getValue();
            int biomeFog = BiomeDataManager.getFogColor(biome);
            int biomeFogRed = ARGB32.red(biomeFog);
            int redDistance = plainsFogRed - biomeFogRed;
            double biomeFogDistance = Math.sqrt(redDistance * redDistance + (greenDistance = plainsFogGreen - (biomeFogGreen = ARGB32.green(biomeFog))) * greenDistance + (blueDistance = plainsFogBlue - (biomeFogBlue = ARGB32.blue(biomeFog))) * blueDistance);
            int biomeColour = biomeFogDistance > 200.0 ? biomeFog : (biomeKeyPath.contains("ocean") || biomeKeyPath.contains("river") ? biome.method_8687() : biome.method_8698());
            if (biomeKey == class_1972.field_9473) {
                biomeColour = 0;
            } else if (biomeKey == class_1972.field_9434) {
                biomeColour = 16177072;
            } else if (biomeKey == class_1972.field_28107) {
                biomeColour = 8743515;
            } else if (biomeKey == class_1972.field_29218) {
                biomeColour = 3800852;
            } else if (biomeKey == class_1972.field_37543) {
                biomeColour = 0x101010;
            } else if (biomeKey == class_1972.field_9462) {
                biomeColour = 8676244;
            } else if (biomeKey == class_1972.field_42720) {
                biomeColour = 16764128;
            } else if (biomeKey == class_1972.field_9424) {
                biomeColour = 16772039;
            } else if (biomeKey == class_1972.field_9414) {
                biomeColour = 12641781;
            } else if (biomeKey == class_1972.field_9440) {
                biomeColour = 0x7FFF00;
            } else if (biomeKey == class_1972.field_9471) {
                biomeColour = 5664066;
            } else if (biomeKey == class_1972.field_38748) {
                biomeColour = 5217576;
            } else if (biomeKey == class_1972.field_9415) {
                biomeColour = 16753920;
            } else if (biomeKey == class_1972.field_9461) {
                biomeColour = 0x6A0A0A;
            } else if (biomeKey == class_1972.field_22076) {
                biomeColour = 14666;
            } else if (biomeKey == class_1972.field_22077) {
                biomeColour = 0x8B0000;
            } else if (biomeKey == class_1972.field_22075) {
                biomeColour = 4251856;
            } else if (biomeKey == class_1972.field_23859) {
                biomeColour = 0x696969;
            } else if (biomeKey == class_1972.field_9411 || biomeKey == class_1972.field_9465 || biomeKey == class_1972.field_9442 || biomeKey == class_1972.field_9447 || biomeKey == class_1972.field_9457) {
                biomeColour = 13148872;
            } else if (biomeKey == class_1972.field_34472) {
                biomeColour = 13428479;
            } else if (biomeKey == class_1972.field_34471) {
                biomeColour = 11788543;
            } else if (biomeKey == class_1972.field_35115) {
                biomeColour = 0x99CCFF;
            } else if (biomeKey == class_1972.field_34474) {
                biomeColour = 8437759;
            } else if (biomeKey == class_1972.field_9454) {
                biomeColour = 6730495;
            } else if (biomeKey == class_1972.field_9478) {
                biomeColour = 5089023;
            } else if (biomeKey == class_1972.field_9453) {
                biomeColour = 1674751;
            }
            BiomeDataEntry biomeDataEntry = new BiomeDataEntry((class_5321<class_1959>)biomeKey, biomeString, biomeColour);
            this.biomes.add(biomeDataEntry);
            this.biomeMap.put((class_5321<class_1959>)biomeKey, biomeDataEntry);
        }
        this.biomes.sort(Comparator.comparing(k -> {
            class_5321<class_1959> key = k.key();
            return key.method_29177().toString();
        }));
        this.justRefreshed = true;
    }

    public BiomeDataEntry getData(class_5321<class_1959> key) {
        return this.biomeMap.get(key);
    }

    public List<BiomeDataEntry> biomes() {
        return this.biomes;
    }

    public boolean justRefreshed() {
        return this.justRefreshed;
    }

    public record BiomeDataEntry(class_5321<class_1959> key, String prettyName, int colour) {
    }
}

