/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.StaticValues;
import com.moulberry.axiom.configuration.AxiomConfig;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.restrictions.ClientRestrictions;
import com.moulberry.axiom.utils.ChatUtils;
import com.moulberry.axiom.utils.StringUtils;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.replaymod.replay.ReplayModReplay;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11515;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_4696;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class AxiomClient {
    public static Set<UUID> ignoredDisplayEntities = Set.of();

    public static boolean isAxiomActive(class_1934 gameType) {
        if (!StaticValues.gameHasTicked) {
            return false;
        }
        if (Axiom.getInstance() == null || Axiom.getInstance().serverConfig == null) {
            return false;
        }
        if (!(ClientEvents.allowedOnServer && ClientEvents.serverSupportsAxiom && ClientEvents.processedServerSupportsAxiom && ClientEvents.processedAllowedOnServer && !ClientEvents.remotelyDisabled)) {
            return false;
        }
        if (FabricLoader.getInstance().isModLoaded("replaymod") && ReplayModReplay.instance.getReplayHandler() != null) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        class_636 gameMode = class_310.method_1551().field_1761;
        if (gameMode == null) {
            return false;
        }
        return gameMode.method_2920() == gameType;
    }

    public static void updateItemBlockRenderTypes() {
        AxiomConfig.SubcategoryBlockAttributes attributes = Axiom.configuration.blockAttributes;
        if (attributes.showStructureVoidBlocks) {
            class_4696.field_21469.put(class_2246.field_10369, class_11515.field_60925);
        }
        if (attributes.showLightBlocks) {
            class_4696.field_21469.put(class_2246.field_31037, class_11515.field_60925);
        }
        if (attributes.showMovingPistonBlocks) {
            class_4696.field_21469.put(class_2246.field_10008, class_11515.field_60926);
        }
    }

    public static boolean hasPermission(AxiomPermission axiomPermission) {
        return ClientRestrictions.permissions.contains(axiomPermission);
    }

    public static boolean hasPermissions(EnumSet<AxiomPermission> permissions) {
        return ClientRestrictions.permissions.containsAll(permissions);
    }

    public static boolean isAxiomActive() {
        return AxiomClient.isAxiomActive(EditorUI.isEnabled() ? class_1934.field_9219 : class_1934.field_9220);
    }

    public static void loadCommercialLicenseHistory(class_5321<class_1937> resourceKey) {
        String newHistoryIdentifier;
        if (class_310.method_1551().method_1496()) {
            String resource = StringUtils.convertResourceToPretty(resourceKey.method_29177());
            newHistoryIdentifier = "Singleplayer/" + class_310.method_1551().method_1576().field_23784.method_27005() + "/" + resource;
        } else {
            String addressIdentifier;
            SocketAddress address = class_310.method_1551().method_1562().method_48296().method_10755();
            if (address instanceof InetSocketAddress) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
                addressIdentifier = inetSocketAddress.getAddress().getHostAddress();
            } else {
                addressIdentifier = address.toString();
            }
            String resource = StringUtils.convertResourceToPretty(resourceKey.method_29177());
            newHistoryIdentifier = "Multiplayer/" + addressIdentifier + "/" + resource;
        }
        Dispatcher.tryLoadHistory(newHistoryIdentifier);
    }

    public static void onAxiomEnabled(class_310 client) {
        class_2561 conflicts;
        if (!Axiom.configuration.internal.shownIntroduction) {
            return;
        }
        if (Axiom.configuration.internal.hadEditorUIOpen && client.field_1761 != null && client.field_1761.method_2920() == class_1934.field_9219) {
            EditorUI.enable();
        }
        if ((conflicts = AxiomClient.getEditorUiKeybindConflicts(client)) != null) {
            ChatUtils.error((class_2561)class_2561.method_43470((String)"The Editor UI keybind has conflicts: ").method_10852(conflicts));
        } else if (Axiom.configuration.internal.showOpenConfigTip) {
            ChatUtils.info("Tip: Access the Axiom config by running /axiomconfig");
        } else if (Axiom.configuration.internal.showOpenContextMenuTip) {
            ChatUtils.info((class_2561)class_2561.method_43470((String)"Tip: Access the Axiom context menu by holding [").method_10852((class_2561)class_2561.method_43472((String)"axiom.keybind.context").method_27693("]")));
        } else if (Axiom.configuration.internal.showOpenEditorTip) {
            ChatUtils.info((class_2561)class_2561.method_43470((String)"Tip: Access the Axiom Editor UI by pressing [").method_10852((class_2561)class_2561.method_43472((String)"axiom.keybind.toggle_editor_ui").method_27693("]")));
        }
    }

    @Nullable
    private static class_2561 getEditorUiKeybindConflicts(class_310 client) {
        class_304 toggleEditor = ClientEvents.toggleEditorUiKeyBind;
        if (!toggleEditor.method_1415()) {
            boolean hasCollision = false;
            class_5250 mutableComponent = class_2561.method_43473();
            for (class_304 other : client.field_1690.field_1839) {
                if (other == toggleEditor || !toggleEditor.method_1435(other)) continue;
                if (hasCollision) {
                    mutableComponent.method_27693(", ");
                }
                hasCollision = true;
                mutableComponent.method_10852((class_2561)class_2561.method_43471((String)other.method_1431()));
            }
            return hasCollision ? mutableComponent : null;
        }
        return null;
    }
}

