/*
 * Decompiled with CFR 0.152.
 */
package com.j0ker2j0ker.swd.client.util;

import com.j0ker2j0ker.swd.client.SwdClient;
import com.j0ker2j0ker.swd.client.util.RegionStorage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class SaveManager {
    private static final Queue<ChunkSaveTask> saveQueue = new ConcurrentLinkedQueue<ChunkSaveTask>();
    private static Thread saveThread = null;
    public static boolean isSaving = false;
    public static String name;
    public static String path;
    public static String regionPath;
    private static final class_310 mc;

    public static void toggle() {
        if (isSaving) {
            SaveManager.stop();
        } else {
            SaveManager.start();
        }
    }

    public static void start() {
        if (!isSaving && mc.method_1558() != null && SaveManager.mc.field_1724 != null) {
            isSaving = true;
            if (SwdClient.CONFIG.saveWorldTo.isEmpty()) {
                name = SaveManager.mc.method_1558().field_3761.replaceAll("[\\\\/:*?\"<>|]", "_");
                if (Files.exists(Paths.get("saves", new String[0]).resolve(name), new LinkOption[0])) {
                    int i = 1;
                    while (Files.exists(Paths.get("saves", new String[0]).resolve(name + " " + i), new LinkOption[0])) {
                        ++i;
                    }
                    name = name + " " + i;
                }
            } else {
                name = SwdClient.CONFIG.saveWorldTo;
            }
            path = mc.method_1586().method_19636().resolve(name).toString();
            regionPath = Paths.get(path, "region").toString();
            try {
                if (!Files.exists(Path.of(path, new String[0]), new LinkOption[0])) {
                    Files.createDirectories(Path.of(regionPath, new String[0]), new FileAttribute[0]);
                    SaveManager.createLevelDat(Path.of(path, new String[0]), name, SaveManager.mc.field_1724);
                    if (mc.method_1558().method_49306() != null) {
                        byte[] icon = mc.method_1558().method_49306();
                        FileOutputStream fos = new FileOutputStream(Paths.get(path, new String[0]).resolve("icon.png").toFile());
                        fos.write(icon);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            SaveManager.printStatus("\u00a7a> Started saving chunks...");
            SaveManager.saveChunksAround(12);
        }
    }

    public static void stop() {
        if (!isSaving) {
            return;
        }
        isSaving = false;
        SaveManager.printStatus("\u00a7c> Stopped saving chunks.");
    }

    public static void printStatus(String msg) {
        if (mc != null && SaveManager.mc.field_1705 != null) {
            SaveManager.mc.field_1705.method_1758(class_2561.method_30163((String)msg), false);
        }
    }

    public static void saveChunksAround(int radius) {
        class_638 world = SaveManager.mc.field_1687;
        if (world == null || SaveManager.mc.field_1724 == null) {
            return;
        }
        int playerChunkX = SaveManager.mc.field_1724.method_31476().field_9181;
        int playerChunkZ = SaveManager.mc.field_1724.method_31476().field_9180;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                int chunkX = playerChunkX + dx;
                int chunkZ = playerChunkZ + dz;
                class_2818 chunk = world.method_2935().method_21730(chunkX, chunkZ);
                if (chunk == null) continue;
                SaveManager.saveChunkToRegion(path, chunk, false);
            }
        }
    }

    public static void saveChunkToRegion(String worldFolder, class_2818 wc, boolean showMessage) {
        class_2487 nbt = SaveManager.buildChunkNbt(wc);
        saveQueue.add(new ChunkSaveTask(wc.method_12004(), nbt));
        if (saveThread == null || !saveThread.isAlive()) {
            Path regionDir = Paths.get(worldFolder, "region");
            saveThread = new Thread(() -> SaveManager.processQueue(regionDir));
            saveThread.start();
        }
        if (showMessage) {
            SaveManager.printStatus("\u00a7a> Saving chunk " + String.valueOf(wc.method_12004()));
        }
    }

    private static void processQueue(Path regionDir) {
        try (RegionStorage storage = new RegionStorage(regionDir);){
            while (!saveQueue.isEmpty() && isSaving) {
                ChunkSaveTask task = saveQueue.poll();
                if (task == null) continue;
                storage.write(task.pos, task.nbt);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createLevelDat(Path worldFolder, String worldName, class_746 p) throws IOException {
        Files.createDirectories(worldFolder, new FileAttribute[0]);
        Files.createDirectories(worldFolder.resolve("region"), new FileAttribute[0]);
        class_2487 data = new class_2487();
        data.method_10569("DataVersion", 4671);
        data.method_10582("LevelName", worldName);
        data.method_10544("LastPlayed", System.currentTimeMillis());
        data.method_10569("version", 19133);
        data.method_10569("GameType", 1);
        data.method_10569("SpawnX", p.method_31477());
        data.method_10569("SpawnY", p.method_31478());
        data.method_10569("SpawnZ", p.method_31479());
        data.method_10569("Difficulty", 1);
        data.method_10567("initialized", (byte)1);
        data.method_10567("hardcore", (byte)0);
        data.method_10567("allowCommands", (byte)1);
        class_2487 version = new class_2487();
        version.method_10582("Name", "1.21.11");
        version.method_10569("Id", 4671);
        version.method_10582("Series", "main");
        version.method_10567("Snapshot", (byte)0);
        data.method_10566("Version", (class_2520)version);
        class_2487 gameRules = new class_2487();
        gameRules.method_10582("doDaylightCycle", "true");
        gameRules.method_10582("doWeatherCycle", "true");
        data.method_10566("GameRules", (class_2520)gameRules);
        class_2487 dataPacks = new class_2487();
        class_2499 enabled = new class_2499();
        enabled.add((Object)class_2519.method_23256((String)"vanilla"));
        dataPacks.method_10566("Enabled", (class_2520)enabled);
        dataPacks.method_10566("Disabled", (class_2520)new class_2499());
        data.method_10566("DataPacks", (class_2520)dataPacks);
        class_2487 player = new class_2487();
        player.method_10582("Dimension", "minecraft:overworld");
        class_2499 pos = new class_2499();
        pos.add((Object)class_2489.method_23241((double)p.method_23317()));
        pos.add((Object)class_2489.method_23241((double)p.method_23318()));
        pos.add((Object)class_2489.method_23241((double)p.method_23321()));
        player.method_10566("Pos", (class_2520)pos);
        data.method_10566("Player", (class_2520)player);
        class_2487 worldGenSettings = new class_2487();
        worldGenSettings.method_10544("seed", 0L);
        worldGenSettings.method_10567("generate_features", (byte)0);
        worldGenSettings.method_10567("bonus_chest", (byte)0);
        class_2487 dimensions = new class_2487();
        class_2487 overworld = new class_2487();
        overworld.method_10582("type", "minecraft:overworld");
        class_2487 generator = new class_2487();
        generator.method_10582("type", "minecraft:flat");
        class_2487 settings = new class_2487();
        settings.method_10566("layers", (class_2520)new class_2499());
        settings.method_10582("biome", "minecraft:plains");
        settings.method_10567("structure", (byte)0);
        generator.method_10566("settings", (class_2520)settings);
        overworld.method_10566("generator", (class_2520)generator);
        dimensions.method_10566("minecraft:overworld", (class_2520)overworld);
        class_2487 nether = new class_2487();
        nether.method_10582("type", "minecraft:the_nether");
        generator = new class_2487();
        generator.method_10582("type", "minecraft:noise");
        generator.method_10582("settings", "minecraft:nether");
        class_2487 biomeSource = new class_2487();
        biomeSource.method_10582("type", "minecraft:multi_noise");
        biomeSource.method_10582("preset", "minecraft:nether");
        generator.method_10566("biome_source", (class_2520)biomeSource);
        nether.method_10566("generator", (class_2520)generator);
        dimensions.method_10566("minecraft:the_nether", (class_2520)nether);
        class_2487 end = new class_2487();
        end.method_10582("type", "minecraft:the_end");
        generator = new class_2487();
        generator.method_10582("type", "minecraft:noise");
        generator.method_10582("settings", "minecraft:end");
        biomeSource = new class_2487();
        biomeSource.method_10582("type", "minecraft:the_end");
        generator.method_10566("biome_source", (class_2520)biomeSource);
        end.method_10566("generator", (class_2520)generator);
        dimensions.method_10566("minecraft:the_end", (class_2520)end);
        worldGenSettings.method_10566("dimensions", (class_2520)dimensions);
        data.method_10566("WorldGenSettings", (class_2520)worldGenSettings);
        class_2487 dragonFight = new class_2487();
        dragonFight.method_10567("NeedsStateScanning", (byte)0);
        dragonFight.method_10567("DragonKilled", (byte)0);
        dragonFight.method_10567("PreviouslyKilled", (byte)0);
        dragonFight.method_10567("IsRespawning", (byte)0);
        data.method_10566("DragonFight", (class_2520)dragonFight);
        class_2487 root = new class_2487();
        root.method_10566("Data", (class_2520)data);
        Path levelDat = worldFolder.resolve("level.dat");
        class_2507.method_30614((class_2487)root, (Path)levelDat);
        long now = System.currentTimeMillis();
        ByteBuffer buf = ByteBuffer.allocate(8).putLong(now);
        Files.write(worldFolder.resolve("session.lock"), buf.array(), new OpenOption[0]);
    }

    public static class_2487 buildChunkNbt(class_2818 wc) {
        class_1923 pos = wc.method_12004();
        class_2487 chunk = new class_2487();
        chunk.method_10569("DataVersion", 4671);
        chunk.method_10569("xPos", pos.field_9181);
        chunk.method_10569("zPos", pos.field_9180);
        chunk.method_10582("Status", "full");
        chunk.method_10544("LastUpdate", 0L);
        chunk.method_10544("InhabitedTime", 0L);
        class_2499 sections = new class_2499();
        class_2826[] sectionArray = wc.method_12006();
        for (int secIndex = 0; secIndex < sectionArray.length; ++secIndex) {
            class_2826 section = sectionArray[secIndex];
            if (section == null || section.method_38292()) continue;
            class_2487 sec = new class_2487();
            sec.method_10569("Y", secIndex + wc.method_32891());
            class_2499 paletteList = new class_2499();
            HashMap<class_2680, Integer> paletteIndex = new HashMap<class_2680, Integer>();
            int[] indices = new int[4096];
            int i = 0;
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        class_2680 state = section.method_12254(x, y, z);
                        Integer idx = (Integer)paletteIndex.get(state);
                        if (idx == null) {
                            idx = paletteList.size();
                            paletteIndex.put(state, idx);
                            class_2487 entry = new class_2487();
                            entry.method_10582("Name", class_7923.field_41175.method_10221((Object)state.method_26204()).toString());
                            if (!state.method_28501().isEmpty()) {
                                class_2487 props = new class_2487();
                                for (class_2769 prop : state.method_28501()) {
                                    props.method_10582(prop.method_11899(), String.valueOf(state.method_11654(prop)));
                                }
                                entry.method_10566("Properties", (class_2520)props);
                            }
                            paletteList.add((Object)entry);
                        }
                        indices[i++] = idx;
                    }
                }
            }
            int paletteSize = paletteList.size();
            int bits = paletteSize <= 1 ? 4 : Math.max(4, SaveManager.ceilLog2(paletteSize));
            class_2487 blockStates = new class_2487();
            blockStates.method_10566("palette", (class_2520)paletteList);
            long[] data = SaveManager.packIndicesVanilla(indices, bits);
            blockStates.method_10566("data", (class_2520)new class_2501(data));
            sec.method_10566("block_states", (class_2520)blockStates);
            class_2487 biomes = new class_2487();
            class_2499 biomePalette = new class_2499();
            biomePalette.add((Object)class_2519.method_23256((String)"minecraft:plains"));
            biomes.method_10566("palette", (class_2520)biomePalette);
            biomes.method_10566("data", (class_2520)new class_2501(new long[]{0L}));
            sec.method_10566("biomes", (class_2520)biomes);
            sections.add((Object)sec);
        }
        chunk.method_10566("sections", (class_2520)sections);
        class_2499 blockEntities = new class_2499();
        wc.method_12214().forEach((posE, be) -> {
            class_2487 beNbt = be.method_38242((class_7225.class_7874)wc.method_12200().method_30349());
            beNbt.method_10569("x", posE.method_10263());
            beNbt.method_10569("y", posE.method_10264());
            beNbt.method_10569("z", posE.method_10260());
            blockEntities.add((Object)beNbt);
        });
        chunk.method_10566("block_entities", (class_2520)blockEntities);
        chunk.method_10566("entities", (class_2520)new class_2499());
        chunk.method_10566("Heightmaps", (class_2520)new class_2487());
        chunk.method_10567("isLightOn", (byte)0);
        return chunk;
    }

    private static int ceilLog2(int n) {
        int v = n - 1;
        return 32 - Integer.numberOfLeadingZeros(v);
    }

    private static long[] packIndicesVanilla(int[] indices, int bits) {
        if (bits <= 0 || bits > 32) {
            throw new IllegalArgumentException("bits must be 1..32");
        }
        int entriesPerLong = 64 / bits;
        int total = indices.length;
        int longs = (total + entriesPerLong - 1) / entriesPerLong;
        long[] data = new long[longs];
        long mask = (1L << bits) - 1L;
        int entryInLong = 0;
        int longIndex = 0;
        for (int idx : indices) {
            int shift = entryInLong * bits;
            int n = longIndex++;
            data[n] = data[n] | ((long)idx & mask) << shift;
            if (++entryInLong != entriesPerLong) continue;
            entryInLong = 0;
        }
        return data;
    }

    static {
        mc = class_310.method_1551();
    }

    @Environment(value=EnvType.CLIENT)
    private record ChunkSaveTask(class_1923 pos, class_2487 nbt) {
    }
}

