/*
 * Decompiled with CFR 0.152.
 */
package com.j0ker2j0ker.swd.client;

import com.j0ker2j0ker.swd.client.util.SaveManager;
import com.j0ker2j0ker.swd.client.util.SwdConfig;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class SwdClient
implements ClientModInitializer {
    public static SwdConfig CONFIG;

    public void onInitializeClient() {
        CONFIG = SwdConfig.load();
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (client.method_1576() == null) {
                SaveManager.stop();
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (SaveManager.isSaving) {
                SaveManager.stop();
                SaveManager.start();
            }
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> CONFIG.save());
        this.registerCommands();
    }

    private void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"swd").then(ClientCommandManager.literal((String)"help").executes(ctx -> {
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(class_2561.method_30163((String)"/swd help - Shows this menu.\n/swd saveWorldTo <World Name> - Set the name of the saved world. If a world with this name already exists, the new chunks overwrite parts of that world. Reset it with /swd default.\n/swd default - Worlds will now be saved with the default name again."));
            return 1;
        }))).then(ClientCommandManager.literal((String)"saveWorldTo").then(ClientCommandManager.argument((String)"World Name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String text = StringArgumentType.getString((CommandContext)ctx, (String)"World Name");
            Object old = SwdClient.CONFIG.saveWorldTo;
            old = Objects.equals(old, "") ? "default" : "\"" + (String)old + "\"";
            SwdClient.CONFIG.saveWorldTo = text;
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(class_2561.method_30163((String)("Your worlds will now be saved as \"" + text + "\". It was on " + (String)old + " before. Reset it with /swd default.\n\u00a7cWarning: If a world with the name \"" + text + "\" already exists, the chunks will overwrite parts of it instead of creating a new world.")));
            return 1;
        })))).then(ClientCommandManager.literal((String)"default").executes(ctx -> {
            Object old = SwdClient.CONFIG.saveWorldTo;
            old = Objects.equals(old, "") ? "default" : "\"" + (String)old + "\"";
            SwdClient.CONFIG.saveWorldTo = "";
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(class_2561.method_30163((String)("Your worlds will now be saved as default. It was on " + (String)old + " before.")));
            return 1;
        }))));
    }
}

