/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.tapestry.config.gui.widget;

import java.util.Objects;
import me.chrr.tapestry.config.gui.OptionProxy;
import me.chrr.tapestry.config.gui.widget.OptionWidget;
import me.chrr.tapestry.config.value.Constraint;
import net.minecraft.class_11876;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_332;
import net.minecraft.class_9848;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class SliderOptionWidget<N extends Number>
extends OptionWidget<N> {
    private static final int SLIDER_WIDTH = 96;
    private int sliderMinX = 0;
    private int sliderMaxX = 0;
    private boolean isSliding = false;
    public final N min;
    public final N max;
    public final N step;

    public SliderOptionWidget(OptionProxy<N> optionProxy, Constraint.Range<N> range) {
        super(optionProxy);
        this.min = (Number)range.min();
        this.max = (Number)range.max();
        this.step = Objects.requireNonNull((Number)range.step());
    }

    public boolean method_25404(class_11908 event) {
        if (this.method_25370()) {
            switch (event.comp_4795()) {
                case 263: {
                    this.optionProxy.value = this.incrementBySteps((Number)this.optionProxy.value, -1);
                    return true;
                }
                case 262: {
                    this.optionProxy.value = this.incrementBySteps((Number)this.optionProxy.value, 1);
                    return true;
                }
            }
        }
        return false;
    }

    public void method_25348(class_11909 event, boolean isDoubleClick) {
        this.isSliding = event.method_74245() == 0 && event.comp_4798() >= (double)this.sliderMinX && event.comp_4798() <= (double)this.sliderMaxX;
        this.updateSlider(event);
    }

    public void method_25357(class_11909 event) {
        this.isSliding = false;
    }

    protected void method_25349(class_11909 event, double mouseX, double mouseY) {
        this.updateSlider(event);
    }

    protected void updateSlider(class_11909 event) {
        if (!this.isSliding || event.method_74245() != 0) {
            return;
        }
        float progress = Math.clamp(((float)event.comp_4798() - (float)this.sliderMinX) / 96.0f, 0.0f, 1.0f);
        this.optionProxy.value = this.getValueFromProgress(progress);
    }

    @Override
    protected void renderOptionWidget(class_332 graphics, int mouseX, int mouseY, float delta) {
        int sliderWidth = this.method_25367() ? 96 : 24;
        int availableWidth = this.method_25368() - sliderWidth - 4;
        this.renderOptionLabel(graphics, availableWidth);
        this.renderValueLabel(graphics, sliderWidth + 4, availableWidth);
        int color = -1;
        int shadow = class_9848.method_61321((int)color, (float)0.25f);
        this.sliderMaxX = this.method_55442() - 2 - 4;
        this.sliderMinX = this.sliderMaxX - sliderWidth;
        int sliderY = this.method_46427() + this.method_25364() / 2;
        int thumbWidth = 2;
        int thumbHeight = this.method_25364() - 12;
        float progress = Math.clamp(this.getProgressFromValue((Number)this.optionProxy.value), 0.0f, 1.0f);
        int thumbX = this.sliderMinX + (int)((float)sliderWidth * progress) - thumbWidth / 2;
        int thumbY = this.method_46427() + 2 + 4;
        graphics.method_25294(this.sliderMinX + 1, sliderY + 1, this.sliderMaxX + 1, sliderY + 2, shadow);
        graphics.method_25294(this.sliderMinX, sliderY, this.sliderMaxX, sliderY + 1, color);
        graphics.method_25294(thumbX + 1, thumbY + 1, thumbX + thumbWidth + 1, thumbY + thumbHeight + 1, shadow);
        graphics.method_25294(thumbX, thumbY, thumbX + thumbWidth, thumbY + thumbHeight, color);
        if (this.isSliding) {
            graphics.method_74037(class_11876.field_62457);
        } else if (this.method_49606() && mouseX >= this.sliderMinX && mouseX <= this.sliderMaxX) {
            graphics.method_74037(this.method_37303() ? class_11876.field_62455 : class_11876.field_62459);
        }
    }

    protected abstract float getProgressFromValue(N var1);

    protected abstract N getValueFromProgress(float var1);

    protected abstract N incrementBySteps(N var1, int var2);

    public static class Float
    extends SliderOptionWidget<java.lang.Float> {
        public Float(OptionProxy<java.lang.Float> optionProxy, Constraint.Range<java.lang.Float> range) {
            super(optionProxy, range);
        }

        @Override
        protected float getProgressFromValue(java.lang.Float value) {
            return (value.floatValue() - ((java.lang.Float)this.min).floatValue()) / (((java.lang.Float)this.max).floatValue() - ((java.lang.Float)this.min).floatValue());
        }

        @Override
        protected java.lang.Float getValueFromProgress(float progress) {
            return java.lang.Float.valueOf((float)Math.round((((java.lang.Float)this.min).floatValue() + progress * (((java.lang.Float)this.max).floatValue() - ((java.lang.Float)this.min).floatValue())) / ((java.lang.Float)this.step).floatValue()) * ((java.lang.Float)this.step).floatValue());
        }

        @Override
        protected java.lang.Float incrementBySteps(java.lang.Float value, int steps) {
            return java.lang.Float.valueOf(Math.clamp(value.floatValue() + ((java.lang.Float)this.step).floatValue() * (float)steps, ((java.lang.Float)this.min).floatValue(), ((java.lang.Float)this.max).floatValue()));
        }
    }

    public static class Int
    extends SliderOptionWidget<Integer> {
        public Int(OptionProxy<Integer> optionProxy, Constraint.Range<Integer> range) {
            super(optionProxy, range);
        }

        @Override
        protected float getProgressFromValue(Integer value) {
            return ((float)value.intValue() - (float)((Integer)this.min).intValue()) / ((float)((Integer)this.max).intValue() - (float)((Integer)this.min).intValue());
        }

        @Override
        protected Integer getValueFromProgress(float progress) {
            return (int)((float)((Integer)this.min).intValue() + progress * (float)((Integer)this.max - (Integer)this.min)) / (Integer)this.step * (Integer)this.step;
        }

        @Override
        protected Integer incrementBySteps(Integer value, int steps) {
            return Math.clamp((long)value.intValue() + (long)((Integer)this.step).intValue() * (long)steps, (Integer)this.min, (Integer)this.max);
        }
    }
}

