/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.tapestry.config;

import com.google.gson.JsonObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import me.chrr.tapestry.config.Config;
import me.chrr.tapestry.config.ConfigEnvironment;
import me.chrr.tapestry.config.ConfigIo;
import me.chrr.tapestry.config.NamingStrategy;
import me.chrr.tapestry.config.Option;
import me.chrr.tapestry.config.annotation.Header;
import me.chrr.tapestry.config.annotation.Hidden;
import me.chrr.tapestry.config.annotation.SerializeName;
import me.chrr.tapestry.config.annotation.TranslationPrefix;
import me.chrr.tapestry.config.annotation.UpgradeRewriter;
import me.chrr.tapestry.config.value.Constraint;
import me.chrr.tapestry.config.value.TrackedValue;
import me.chrr.tapestry.config.value.Value;
import me.chrr.tapestry.config.value.VirtualValue;
import net.minecraft.class_2561;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class ReflectedConfig
implements Config {
    private final List<Option<?>> options = new ArrayList();
    private class_2561 title = class_2561.method_43473();
    private @Nullable ConfigIo.UpgradeRewriter upgradeRewriter = null;
    private @Nullable Path currentConfigPath = null;
    private @Nullable TranslationPrefix translationPrefix = null;

    protected <T> Value<T> value(T defaultValue) {
        return new TrackedValue(defaultValue.getClass(), defaultValue);
    }

    protected <U, V> Value<V> map(Value<U> value, Function<U, V> aToB, Function<V, U> bToA) {
        V defaultValue = aToB.apply(value.getDefaultValue());
        return new VirtualValue<Object>(defaultValue.getClass(), defaultValue, () -> aToB.apply(value.get()), v -> value.set(bToA.apply(v)));
    }

    private void reflectOptions() {
        this.upgradeRewriter = this.reflectUpgradeRewriter();
        this.translationPrefix = this.getClass().getAnnotation(TranslationPrefix.class);
        NamingStrategy namingStrategy = NamingStrategy.SNAKE_CASE;
        SerializeName.Strategy serializeNameStrategyAnnotation = this.getClass().getAnnotation(SerializeName.Strategy.class);
        if (serializeNameStrategyAnnotation != null) {
            namingStrategy = serializeNameStrategyAnnotation.value();
        }
        this.title = this.getTranslatedName("title");
        for (Field field : this.getClass().getFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            this.options.add(this.reflectOptionFromField(field, namingStrategy));
        }
    }

    private @Nullable ConfigIo.UpgradeRewriter reflectUpgradeRewriter() {
        ConfigIo.UpgradeRewriter upgradeRewriter = null;
        for (final Method method : this.getClass().getDeclaredMethods()) {
            final UpgradeRewriter annotation = method.getAnnotation(UpgradeRewriter.class);
            if (annotation == null) continue;
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("Upgrade rewriter '" + method.getName() + "' is not static");
            }
            if (upgradeRewriter != null) {
                throw new IllegalArgumentException("Config class '" + this.getClass().getName() + "' defines more than one upgrade rewriter");
            }
            method.setAccessible(true);
            upgradeRewriter = new ConfigIo.UpgradeRewriter(){

                @Override
                public void upgrade(int fromVersion, JsonObject config) {
                    try {
                        method.invoke(null, fromVersion, config);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException("Failed to invoke upgrade rewriter", e);
                    }
                }

                @Override
                public int getLatestVersion() {
                    return annotation.currentVersion();
                }
            };
        }
        return upgradeRewriter;
    }

    private Option<?> reflectOptionFromField(Field field, NamingStrategy defaultNamingStrategy) {
        try {
            Class<?> type = field.getType();
            if (!Value.class.isAssignableFrom(type)) {
                throw new IllegalArgumentException("All (non-transient) public fields in a config class should be Value<?>, which " + String.valueOf(type) + " isn't");
            }
            Value value = (Value)field.get(this);
            return this.reflectOptionFromValue(value, field, defaultNamingStrategy);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Couldn't initialize config field " + String.valueOf(field));
        }
    }

    private <T> Option<T> reflectOptionFromValue(Value<T> value, Field field, NamingStrategy defaultNamingStrategy) {
        NamingStrategy namingStrategy;
        Option<T> option = new Option<T>(value);
        SerializeName serializeName = field.getAnnotation(SerializeName.class);
        SerializeName.Strategy strategy = this.getClass().getAnnotation(SerializeName.Strategy.class);
        NamingStrategy namingStrategy2 = namingStrategy = strategy != null ? strategy.value() : defaultNamingStrategy;
        if (value instanceof TrackedValue) {
            TrackedValue trackedValue = (TrackedValue)value;
            option.serializedName = serializeName != null ? serializeName.value() : namingStrategy.transform(field.getName());
            Class valueType = trackedValue.getValueType();
            if (valueType.isEnum()) {
                if (value.constraint == null) {
                    value.constraint = new Constraint.Values(Arrays.asList(valueType.getEnumConstants()));
                }
                if (!value.didSetTextProvider) {
                    value.textProvider = v -> this.getTranslatedName("value." + namingStrategy.transform(valueType.getSimpleName()) + "." + namingStrategy.transform(v.toString()));
                }
            }
        }
        if (field.isAnnotationPresent(Hidden.class)) {
            option.hidden = true;
        } else {
            option.displayName = this.getTranslatedName("option." + namingStrategy.transform(field.getName()));
        }
        Header header = field.getAnnotation(Header.class);
        if (header != null) {
            option.header = this.getTranslatedName("category." + header.value());
        }
        return option;
    }

    private class_2561 getTranslatedName(String key) {
        if (this.translationPrefix == null) {
            return class_2561.method_43470((String)key);
        }
        return class_2561.method_43471((String)(this.translationPrefix.value() + "." + key));
    }

    @Override
    public void save() {
        ConfigIo.saveToPath(this, Objects.requireNonNull(this.currentConfigPath));
    }

    public static <T extends ReflectedConfig> T load(ConfigEnvironment environment, Class<T> configClass, String file, List<String> aliases) {
        try {
            Path configFile;
            Constructor<T> constructor = configClass.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            ReflectedConfig config = (ReflectedConfig)constructor.newInstance(new Object[0]);
            config.reflectOptions();
            Path confDir = environment.getConfigDir();
            config.currentConfigPath = configFile = confDir.resolve(file);
            ConfigIo.loadFromPathOrSaveDefault(config, configFile, aliases.stream().map(confDir::resolve).toList());
            return (T)config;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Config class '" + configClass.getName() + "' does not have a default constructor", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Config class '" + configClass.getName() + "' could not be instantiated", e);
        }
    }

    @Override
    public Collection<Option<?>> getOptions() {
        return this.options;
    }

    @Override
    public class_2561 getTitle() {
        return this.title;
    }

    @Override
    public @Nullable ConfigIo.UpgradeRewriter getUpgradeRewriter() {
        return this.upgradeRewriter;
    }
}

