/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.tapestry.config;

import java.util.Arrays;
import org.jspecify.annotations.NullMarked;

@NullMarked
public enum NamingStrategy {
    KEEP,
    SNAKE_CASE,
    CAMEL_CASE;


    public String transform(String name) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> name;
            case 1 -> String.join((CharSequence)"_", NamingStrategy.splitName(name)).toLowerCase();
            case 2 -> {
                StringBuilder builder = new StringBuilder();
                String[] words = NamingStrategy.splitName(name);
                builder.append(words[0]);
                Arrays.stream(words).skip(1L).forEach(word -> builder.append(NamingStrategy.capitalize(word)));
                yield builder.toString();
            }
        };
    }

    private static String[] splitName(String name) {
        return name.replaceAll("[^\\p{Alnum}]+", " ").replaceAll("([\\p{Lower}\\d])(\\p{Upper})", "$1 $2").replaceAll("(\\p{Upper}+)(\\p{Upper}\\p{Lower})", "$1 $2").replaceAll("(\\p{Alpha})(\\d)|(\\d)(\\p{Alpha})", "$1$3 $2$4").trim().split("\\s+");
    }

    private static String capitalize(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }
}

