/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.tapestry.config;

import com.google.gson.FormattingStyle;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.Strictness;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import me.chrr.tapestry.config.Config;
import me.chrr.tapestry.config.Option;
import me.chrr.tapestry.config.value.Value;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ConfigIo
extends Enum<ConfigIo> {
    private static final Logger LOGGER;
    public static final Gson GSON;
    private static final /* synthetic */ ConfigIo[] $VALUES;

    public static ConfigIo[] values() {
        return (ConfigIo[])$VALUES.clone();
    }

    public static ConfigIo valueOf(String name) {
        return Enum.valueOf(ConfigIo.class, name);
    }

    public static void loadFromPathOrSaveDefault(Config config, Path file, List<Path> aliases) {
        if (Files.exists(file, new LinkOption[0])) {
            ConfigIo.loadFromPath(config, file);
            return;
        }
        for (Path alias : aliases) {
            if (!Files.isRegularFile(alias, new LinkOption[0])) continue;
            ConfigIo.loadFromPath(config, alias);
            ConfigIo.saveToPath(config, file);
            try {
                Files.delete(alias);
            }
            catch (IOException e) {
                LOGGER.error("Failed to delete old config file at '{}'", (Object)alias, (Object)e);
            }
            LOGGER.info("Migrated config from '{}' to '{}'", (Object)alias, (Object)file);
            return;
        }
        LOGGER.info("No config file found, saving default config to '{}'", (Object)file);
        ConfigIo.saveToPath(config, file);
    }

    public static void loadFromPath(Config config, Path path) {
        try {
            JsonObject object = JsonParser.parseString((String)Files.readString(path)).getAsJsonObject();
            UpgradeRewriter upgradeRewriter = config.getUpgradeRewriter();
            if (upgradeRewriter != null && object.has("version")) {
                int version = object.get("version").getAsInt();
                upgradeRewriter.upgrade(version, object);
                object.addProperty("version", (Number)upgradeRewriter.getLatestVersion());
                LOGGER.info("Upgraded config at '{}' to version {}", (Object)path, (Object)upgradeRewriter.getLatestVersion());
                String json = GSON.toJson((JsonElement)object);
                Files.write(path, json.getBytes(), new OpenOption[0]);
            }
            for (Option<?> option : config.getOptions()) {
                if (option.serializedName == null || !object.has(option.serializedName)) continue;
                ConfigIo.readIntoValue(option.value, object.get(option.serializedName));
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load config from '{}'", (Object)path, (Object)e);
        }
    }

    public static <T> void readIntoValue(Value<T> value, JsonElement element) {
        value.set(GSON.fromJson(element, value.getValueType()));
    }

    public static void saveToPath(Config config, Path path) {
        JsonObject object = new JsonObject();
        UpgradeRewriter upgradeRewriter = config.getUpgradeRewriter();
        if (upgradeRewriter != null) {
            object.addProperty("version", (Number)upgradeRewriter.getLatestVersion());
        }
        for (Option<?> option : config.getOptions()) {
            if (option.serializedName == null) continue;
            object.add(option.serializedName, GSON.toJsonTree(option.value.get(), option.value.getValueType()));
        }
        try {
            String json = GSON.toJson((JsonElement)object);
            Files.write(path, json.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config to '{}'", (Object)path, (Object)e);
        }
    }

    private static /* synthetic */ ConfigIo[] $values() {
        return new ConfigIo[0];
    }

    static {
        $VALUES = ConfigIo.$values();
        LOGGER = LogManager.getLogger((String)"Tapestry/ConfigIo");
        GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).setFormattingStyle(FormattingStyle.PRETTY).create();
    }

    public static interface UpgradeRewriter {
        public void upgrade(int var1, JsonObject var2);

        public int getLatestVersion();
    }
}

