/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.screen;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import me.chrr.scribble.KeyboardUtil;
import me.chrr.scribble.Scribble;
import me.chrr.scribble.ScribbleConfig;
import me.chrr.scribble.SetReturnScreen;
import me.chrr.scribble.book.BookFile;
import me.chrr.scribble.book.FileChooser;
import me.chrr.scribble.book.RichText;
import me.chrr.scribble.gui.TextArea;
import me.chrr.scribble.gui.button.ColorSwatchWidget;
import me.chrr.scribble.gui.button.IconButtonWidget;
import me.chrr.scribble.gui.button.ModifierButtonWidget;
import me.chrr.scribble.gui.edit.RichEditBox;
import me.chrr.scribble.gui.edit.RichMultiLineTextField;
import me.chrr.scribble.history.CommandManager;
import me.chrr.scribble.history.HistoryListener;
import me.chrr.scribble.history.command.Command;
import me.chrr.scribble.history.command.EditCommand;
import me.chrr.scribble.history.command.PageDeleteCommand;
import me.chrr.scribble.history.command.PageInsertCommand;
import me.chrr.scribble.screen.ScribbleBookScreen;
import net.minecraft.class_11385;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2820;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_8016;
import net.minecraft.class_9262;
import net.minecraft.class_9301;
import net.minecraft.class_9334;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ScribbleBookEditScreen
extends ScribbleBookScreen<RichText>
implements HistoryListener {
    private static final class_124[] COLORS = new class_124[]{class_124.field_1074, class_124.field_1063, class_124.field_1080, class_124.field_1068, class_124.field_1079, class_124.field_1061, class_124.field_1065, class_124.field_1054, class_124.field_1077, class_124.field_1060, class_124.field_1062, class_124.field_1075, class_124.field_1058, class_124.field_1078, class_124.field_1064, class_124.field_1076};
    private final class_1657 player;
    private final class_1799 itemStack;
    private final class_1268 hand;
    private final List<RichText> pages;
    private final CommandManager commandManager = new CommandManager(this);
    private @Nullable RichEditBox lastFocusedEditBox = null;
    private boolean dirty = false;
    private @Nullable IconButtonWidget undoButton;
    private @Nullable IconButtonWidget redoButton;
    private final List<IconButtonWidget> insertPageButtons = new ArrayList<IconButtonWidget>();
    private @Nullable ModifierButtonWidget boldButton;
    private @Nullable ModifierButtonWidget italicButton;
    private @Nullable ModifierButtonWidget underlineButton;
    private @Nullable ModifierButtonWidget strikethroughButton;
    private @Nullable ModifierButtonWidget obfuscatedButton;
    private List<ColorSwatchWidget> colorSwatches = List.of();

    public ScribbleBookEditScreen(class_1657 player, class_1799 itemStack, class_1268 hand, class_9301 book) {
        super((class_2561)class_2561.method_43471((String)"book.edit.title"));
        this.player = player;
        this.itemStack = itemStack;
        this.hand = hand;
        this.pages = new ArrayList<RichText>();
        book.method_57517(class_310.method_1551().method_33883()).forEach(page -> this.pages.add(RichText.fromFormattedString(page)));
        if (this.pages.isEmpty()) {
            for (int i = 0; i < this.pagesToShow; ++i) {
                this.pages.add(RichText.EMPTY);
            }
        }
    }

    @Override
    protected boolean shouldShowActionButtons() {
        return Scribble.config().showActionButtons.get() != ScribbleConfig.ShowActionButtons.NEVER;
    }

    @Override
    protected void initActionButtons(int x, int y) {
        this.undoButton = (IconButtonWidget)this.method_37063((class_364)new IconButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.action.undo"), () -> {
            this.commandManager.tryUndo();
            this.invalidateActionButtons();
        }, x, y, 24, 90, 12, 12));
        this.redoButton = (IconButtonWidget)this.method_37063((class_364)new IconButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.action.redo"), () -> {
            this.commandManager.tryRedo();
            this.invalidateActionButtons();
        }, x, y + 12, 36, 90, 12, 12));
        this.method_37063((class_364)new IconButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.action.save_book_to_file"), () -> FileChooser.chooseFile(true, this::saveToFile), x, y + 24 + 4, 48, 90, 12, 12));
        this.method_37063((class_364)new IconButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.action.load_book_from_file"), () -> this.confirmIf(this.dirty || !this.isEmpty(), "overwrite_warning", () -> FileChooser.chooseFile(false, this::loadFromFile)), x, y + 36 + 4, 60, 90, 12, 12));
        this.invalidateActionButtons();
    }

    private void invalidateActionButtons() {
        if (this.undoButton != null && this.redoButton != null) {
            this.undoButton.field_22763 = this.commandManager.canUndo();
            this.redoButton.field_22763 = this.commandManager.canRedo();
        }
    }

    @Override
    protected void initPageButtons(int y) {
        this.insertPageButtons.clear();
        for (int i = 0; i < this.pagesToShow; ++i) {
            int xOffset = this.pagesToShow == 1 ? 0 : (i == 0 ? 32 : (i == this.pagesToShow - 1 ? -32 : 0));
            class_5250 insertText = this.pagesToShow == 1 ? class_2561.method_43471((String)"text.scribble.action.insert_new_page") : class_2561.method_43471((String)"text.scribble.action.insert_new_page_here");
            class_5250 deleteText = class_2561.method_43471((String)"text.scribble.action.delete_page");
            int pageOffset = i;
            this.insertPageButtons.add((IconButtonWidget)this.method_37063((class_364)new IconButtonWidget((class_2561)insertText, () -> {
                PageInsertCommand command = new PageInsertCommand(this.currentPage + pageOffset);
                command.execute(this);
                this.commandManager.push(command);
            }, this.getBackgroundX() + 78 + xOffset + i * 126, y + 2, 12, 90, 12, 12)));
            this.method_37063((class_364)new IconButtonWidget((class_2561)deleteText, () -> {
                PageDeleteCommand command = new PageDeleteCommand(this.currentPage + pageOffset, this.pages.get(this.currentPage + pageOffset));
                command.execute(this);
                this.commandManager.push(command);
            }, this.getBackgroundX() + 94 + xOffset + i * 126, y + 2, 0, 90, 12, 12));
        }
    }

    @Override
    public void updateCurrentPages() {
        super.updateCurrentPages();
        this.insertPageButtons.forEach(button -> {
            button.field_22764 = this.getTotalPages() < 100;
        });
    }

    @Override
    protected void initMenuControls(int y) {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"book.signButton"), button -> {
            class_11385 screen = new class_11385(null, this.player, this.hand, this.getPagesAsStrings(true));
            ((SetReturnScreen)screen).scribble$setReturnScreen(this);
            this.field_22787.method_1507((class_437)screen);
        }).method_46433(this.field_22789 / 2 - 98 - 2, y).method_46432(98).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
            this.field_22787.method_1507(null);
            this.saveChanges();
        }).method_46433(this.field_22789 / 2 + 2, y).method_46432(98).method_46431());
    }

    protected void method_56131() {
        super.method_48265((class_364)this.textAreas.getFirst());
    }

    @Override
    protected TextArea<RichText> createTextArea(int x, int y, int width, int height, int pageOffset) {
        RichEditBox editBox = (RichEditBox)new RichEditBox.Builder().onHistoryPush(command -> this.pushCommand(pageOffset, (Command)command)).onInvalidateFormat(this::invalidateFormattingButtons).method_71515(false).method_71514(-16777216).method_71516(-16777216).method_71513(false).method_71511(false).method_71508(x - 4).method_71512(y - 4).method_71509(this.field_22793, width + 8, height + 6, class_5244.field_39003);
        editBox.method_44402(1024);
        Objects.requireNonNull(this.field_22793);
        editBox.method_71506(height / 9);
        editBox.setRichValueListener(text -> {
            RichText existing = this.pages.get(this.currentPage + pageOffset);
            if (existing != text) {
                this.pages.set(this.currentPage + pageOffset, (RichText)text);
                this.dirty = true;
            }
        });
        return editBox;
    }

    private void updateFocusedEditBox() {
        RichEditBox focusedEditBox;
        class_364 class_3642 = this.method_25399();
        if (class_3642 instanceof RichEditBox && this.lastFocusedEditBox != (focusedEditBox = (RichEditBox)class_3642)) {
            this.lastFocusedEditBox = focusedEditBox;
            this.textAreas.stream().map(textArea -> (RichEditBox)textArea).filter(editBox -> !editBox.method_25370()).forEach(editBox -> editBox.getRichTextField().resetCursor(false));
            focusedEditBox.getRichTextField().sendUpdateFormat();
        }
    }

    protected void method_48263(class_8016 componentPath) {
        super.method_48263(componentPath);
        this.updateFocusedEditBox();
    }

    public void method_25395(@Nullable class_364 guiEventListener) {
        super.method_25395(guiEventListener);
        this.updateFocusedEditBox();
    }

    public void confirmIf(boolean condition, String name, Runnable runnable) {
        if (!condition) {
            runnable.run();
            return;
        }
        BooleanConsumer onConfirmed = confirmed -> {
            this.field_22787.method_1507((class_437)this);
            if (confirmed) {
                runnable.run();
            }
        };
        this.field_22787.method_1507((class_437)new class_410(onConfirmed, (class_2561)class_2561.method_43471((String)("text.scribble." + name + ".title")), (class_2561)class_2561.method_43471((String)("text.scribble." + name + ".description"))));
    }

    private void saveToFile(Path path) {
        try {
            BookFile bookFile = new BookFile(this.player.method_5477().getString(), this.getPagesAsStrings(true));
            bookFile.writeJson(path);
        }
        catch (Exception e) {
            Scribble.LOGGER.error("could not save book to file", (Throwable)e);
        }
    }

    private void loadFromFile(Path path) {
        try {
            BookFile bookFile = BookFile.readFile(path);
            this.pages.clear();
            this.pages.addAll(bookFile.pages().stream().map(RichText::fromFormattedString).toList());
            this.commandManager.clear();
            this.dirty = true;
            this.showPage(0, false);
            this.updateCurrentPages();
        }
        catch (Exception e) {
            Scribble.LOGGER.error("could not load book from file", (Throwable)e);
        }
    }

    @Override
    public void method_25419() {
        this.confirmIf(this.dirty, "quit_without_saving", () -> super.method_25419());
    }

    @Override
    public boolean method_25404(class_11908 keyEvent) {
        if (keyEvent.method_74240() && !keyEvent.method_74238()) {
            if (KeyboardUtil.isKey(keyEvent.comp_4795(), "Z") && !keyEvent.method_74239() && this.undoButton != null && this.undoButton.field_22763) {
                this.commandManager.tryUndo();
                this.invalidateActionButtons();
                return true;
            }
            if ((KeyboardUtil.isKey(keyEvent.comp_4795(), "Z") && keyEvent.method_74239() || KeyboardUtil.isKey(keyEvent.comp_4795(), "Y") && !keyEvent.method_74239()) && this.redoButton != null && this.redoButton.field_22763) {
                this.commandManager.tryRedo();
                this.invalidateActionButtons();
                return true;
            }
        }
        return super.method_25404(keyEvent);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (((Boolean)Scribble.config().showFormattingButtons.get()).booleanValue()) {
            int x = this.field_22789 / 2 + this.getBackgroundWidth() / 2 - 20;
            int y = this.getBackgroundY() + 12;
            this.obfuscatedButton = (ModifierButtonWidget)this.method_37063((class_364)new ModifierButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.modifier.obfuscated"), toggled -> this.applyFormat(class_124.field_1051, (boolean)toggled), x, y + 70, 0, 70, 22, 18));
            this.strikethroughButton = (ModifierButtonWidget)this.method_37063((class_364)new ModifierButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.modifier.strikethrough"), toggled -> this.applyFormat(class_124.field_1055, (boolean)toggled), x, y + 53, 0, 53, 22, 17));
            this.underlineButton = (ModifierButtonWidget)this.method_37063((class_364)new ModifierButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.modifier.underline"), toggled -> this.applyFormat(class_124.field_1073, (boolean)toggled), x, y + 36, 0, 36, 22, 17));
            this.italicButton = (ModifierButtonWidget)this.method_37063((class_364)new ModifierButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.modifier.italic"), toggled -> this.applyFormat(class_124.field_1056, (boolean)toggled), x, y + 19, 0, 19, 22, 17));
            this.boldButton = (ModifierButtonWidget)this.method_37063((class_364)new ModifierButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.modifier.bold"), toggled -> this.applyFormat(class_124.field_1067, (boolean)toggled), x, y, 0, 0, 22, 19));
            this.colorSwatches = new ArrayList<ColorSwatchWidget>(COLORS.length);
            for (int i = 0; i < COLORS.length; ++i) {
                int dx = i % 2 * 8;
                int dy = i / 2 * 8;
                class_124 color = COLORS[i];
                this.colorSwatches.add((ColorSwatchWidget)this.method_37063((class_364)new ColorSwatchWidget((class_2561)class_2561.method_43471((String)("text.scribble.color." + color.method_537())), color, () -> this.applyFormat(color, true), x + 3 + dx, y + 95 + dy, 8, 8)));
            }
            this.invalidateFormattingButtons();
        }
    }

    private void applyFormat(class_124 formatting, boolean enabled) {
        if (this.lastFocusedEditBox == null) {
            return;
        }
        this.lastFocusedEditBox.applyFormat(formatting, enabled);
    }

    private void setSwatchColor(@Nullable class_124 color) {
        for (ColorSwatchWidget swatch : this.colorSwatches) {
            swatch.setToggled(swatch.getColor() == color);
        }
    }

    private void invalidateFormattingButtons() {
        RichEditBox editBox = this.lastFocusedEditBox;
        if (editBox == null) {
            return;
        }
        if (this.boldButton == null || this.italicButton == null || this.underlineButton == null || this.strikethroughButton == null || this.obfuscatedButton == null) {
            return;
        }
        this.boldButton.toggled = editBox.modifiers.contains(class_124.field_1067);
        this.italicButton.toggled = editBox.modifiers.contains(class_124.field_1056);
        this.underlineButton.toggled = editBox.modifiers.contains(class_124.field_1073);
        this.strikethroughButton.toggled = editBox.modifiers.contains(class_124.field_1055);
        this.obfuscatedButton.toggled = editBox.modifiers.contains(class_124.field_1051);
        this.setSwatchColor(editBox.color);
    }

    @Override
    protected RichText getPage(int page) {
        return this.pages.get(page);
    }

    @Override
    protected int getTotalPages() {
        return this.pages.size();
    }

    @Override
    public void showPage(int page, boolean insertIfMissing) {
        super.showPage(page, insertIfMissing);
        this.method_25395((class_364)this.textAreas.get(Math.min(page, this.getTotalPages()) % this.textAreas.size()));
    }

    private List<String> getPagesAsStrings(boolean removeTrailingPages) {
        ArrayList<RichText> pages = new ArrayList<RichText>(this.pages);
        if (removeTrailingPages) {
            ListIterator listIterator = pages.listIterator(pages.size());
            while (listIterator.hasPrevious() && ((RichText)listIterator.previous()).isEmpty()) {
                listIterator.remove();
            }
        }
        return pages.stream().map(RichText::getAsFormattedString).toList();
    }

    private void saveChanges() {
        List<String> pages = this.getPagesAsStrings(true);
        this.itemStack.method_57379(class_9334.field_49653, (Object)new class_9301(pages.stream().map(class_9262::method_57137).toList()));
        int slot = this.hand == class_1268.field_5808 ? this.player.method_31548().method_67532() : 40;
        class_634 connection = this.field_22787.method_1562();
        Objects.requireNonNull(connection).method_52787((class_2596)new class_2820(slot, pages, Optional.empty()));
    }

    @Override
    protected boolean canInsertPages() {
        return this.getTotalPages() < 100;
    }

    @Override
    protected void insertEmptyPageAt(int page) {
        this.pages.add(page, RichText.EMPTY);
    }

    private boolean isEmpty() {
        return this.pages.stream().allMatch(RichText::isEmpty);
    }

    public void pushCommand(int pageOffset, Command command) {
        if (command instanceof EditCommand) {
            EditCommand editCommand = (EditCommand)command;
            editCommand.page = this.currentPage + pageOffset;
        }
        this.commandManager.push(command);
        this.dirty = true;
        this.invalidateActionButtons();
    }

    @Override
    public RichMultiLineTextField switchAndFocusPage(int page) {
        this.showPage(page, false);
        int shownPage = Math.min(page, this.getTotalPages());
        RichEditBox editBox = (RichEditBox)this.textAreas.get(shownPage % this.pagesToShow);
        this.method_25395(editBox);
        return editBox.getRichTextField();
    }

    @Override
    public void setFormat(@Nullable class_124 color, Set<class_124> modifiers) {
        RichEditBox editBox = this.lastFocusedEditBox;
        if (editBox == null) {
            return;
        }
        editBox.color = color;
        editBox.modifiers = modifiers;
        this.invalidateFormattingButtons();
    }

    @Override
    public void insertPageAt(int page, @Nullable RichText content) {
        this.pages.add(page, Optional.ofNullable(content).orElse(RichText.EMPTY));
        this.dirty = true;
        this.showPage(page, false);
        this.updateCurrentPages();
    }

    @Override
    public void deletePage(int page) {
        this.pages.remove(page);
        this.dirty = true;
        if (page >= this.pages.size() - 1) {
            this.showPage(page - 1, false);
        }
        this.updateCurrentPages();
    }
}

