/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.book;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class RichText
implements class_5348 {
    public static final RichText EMPTY = new RichText(List.of());
    private final List<Segment> segments;

    public RichText(List<Segment> segments) {
        this.segments = segments;
    }

    public RichText(String text, class_124 color, Set<class_124> modifiers) {
        this(List.of(new Segment(text, color, modifiers)));
    }

    public static RichText fromFormattedString(String input) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        StringBuilder text = new StringBuilder();
        class_124 color = class_124.field_1074;
        HashSet<class_124> modifiers = new HashSet<class_124>();
        int i = 0;
        while (i < input.length()) {
            int codePoint = input.codePointAt(i);
            i += Character.charCount(codePoint);
            if (codePoint == 167) {
                if (i >= input.length()) break;
                char code = input.charAt(i);
                ++i;
                class_124 formatting = class_124.method_544((char)code);
                if (formatting == null) continue;
                if (!text.isEmpty()) {
                    segments.add(new Segment(text.toString(), color, new HashSet<class_124>(modifiers)));
                    text = new StringBuilder();
                }
                if (formatting.method_542()) {
                    modifiers.add(formatting);
                    continue;
                }
                if (formatting == class_124.field_1070) {
                    color = class_124.field_1074;
                    modifiers.clear();
                    continue;
                }
                color = formatting;
                modifiers.clear();
                continue;
            }
            text.appendCodePoint(codePoint);
        }
        if (!text.isEmpty()) {
            segments.add(new Segment(text.toString(), color, modifiers));
        }
        return new RichText(segments);
    }

    public static RichText fromFormattedTextLossy(class_5348 text) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        AtomicReference<class_124> color = new AtomicReference<class_124>(class_124.field_1074);
        text.method_27658((style, string) -> {
            if (style.method_10973() != null) {
                color.set(RichText.formattingFromTextColor(style.method_10973()));
            }
            HashSet<class_124> modifiers = new HashSet<class_124>();
            if (style.method_10984()) {
                modifiers.add(class_124.field_1067);
            }
            if (style.method_10966()) {
                modifiers.add(class_124.field_1056);
            }
            if (style.method_10965()) {
                modifiers.add(class_124.field_1073);
            }
            if (style.method_10987()) {
                modifiers.add(class_124.field_1051);
            }
            if (style.method_10986()) {
                modifiers.add(class_124.field_1055);
            }
            segments.add(new Segment(string, (class_124)color.get(), modifiers));
            return Optional.empty();
        }, class_2583.field_24360.method_27706(class_124.field_1074));
        return new RichText(segments);
    }

    private static class_124 formattingFromTextColor(class_5251 color) {
        class_124 byName = class_124.method_533((String)color.method_27721());
        if (byName != null) {
            return byName;
        }
        class_124 closest = class_124.field_1074;
        int distance = Integer.MAX_VALUE;
        for (class_124 formatting : class_124.values()) {
            int db;
            int dg;
            int dr;
            int dist;
            Integer colorValue = formatting.method_532();
            if (colorValue == null || (dist = (dr = Math.abs((colorValue >> 16 & 0xFF) - (color.method_27716() >> 16 & 0xFF))) + (dg = Math.abs((colorValue >> 8 & 0xFF) - (color.method_27716() >> 8 & 0xFF))) + (db = Math.abs((colorValue & 0xFF) - (color.method_27716() & 0xFF)))) >= distance) continue;
            closest = formatting;
            distance = dist;
        }
        return closest;
    }

    private RichText mergeSimilarSegments() {
        if (this.segments.isEmpty()) {
            return this;
        }
        ArrayList<Segment> mergedSegments = new ArrayList<Segment>();
        Segment previousSegment = null;
        for (Segment segment : this.segments) {
            boolean areModifiersMatching;
            if (previousSegment == null) {
                previousSegment = segment;
                continue;
            }
            boolean isColorMatching = previousSegment.color == segment.color;
            boolean bl = areModifiersMatching = segment.modifiers.containsAll(previousSegment.modifiers()) && previousSegment.modifiers().containsAll(segment.modifiers);
            if (isColorMatching && areModifiersMatching) {
                previousSegment = new Segment(previousSegment.text + segment.text, previousSegment.color, previousSegment.modifiers);
                continue;
            }
            mergedSegments.add(previousSegment);
            previousSegment = segment;
        }
        mergedSegments.add(previousSegment);
        return new RichText(mergedSegments);
    }

    public String getPlainText() {
        return this.segments.stream().map(segment -> segment.text).collect(Collectors.joining());
    }

    public boolean isEmpty() {
        return this.getPlainText().isEmpty();
    }

    public int getLength() {
        return this.segments.stream().map(segment -> segment.text.length()).reduce(0, Integer::sum);
    }

    public RichText subText(int start, int end) {
        int current = 0;
        ArrayList<Segment> subSegments = new ArrayList<Segment>();
        for (Segment segment : this.segments) {
            int length = segment.text.length();
            if (current + length <= start) {
                current += length;
                continue;
            }
            if (current >= end) break;
            int localStart = Math.max(0, start - current);
            int localEnd = Math.min(length, end - current);
            subSegments.add(new Segment(segment.text.substring(localStart, localEnd), segment.color, segment.modifiers));
            current += length;
        }
        return new RichText(subSegments);
    }

    public RichText replace(int start, int end, RichText replacement) {
        int current = 0;
        ArrayList<Segment> newSegments = new ArrayList<Segment>();
        boolean replacementAppended = false;
        for (Segment segment : this.segments) {
            int length = segment.text.length();
            if (current + length <= start) {
                newSegments.add(segment);
                current += length;
                continue;
            }
            if (current >= end) {
                newSegments.add(segment);
                continue;
            }
            int localStart = Math.max(0, start - current);
            int localEnd = Math.min(length, end - current);
            if (localStart > 0) {
                newSegments.add(new Segment(segment.text.substring(0, localStart), segment.color, segment.modifiers));
            }
            if (!replacement.isEmpty() && !replacementAppended) {
                newSegments.addAll(replacement.segments);
                replacementAppended = true;
            }
            if (localEnd < length) {
                newSegments.add(new Segment(segment.text.substring(localEnd), segment.color, segment.modifiers));
            }
            current += length;
        }
        return new RichText(newSegments).mergeSimilarSegments();
    }

    public RichText insert(int offset, RichText text) {
        if (text.isEmpty()) {
            return this;
        }
        if (this.segments.isEmpty()) {
            return text;
        }
        ArrayList<Segment> combinedSegments = new ArrayList<Segment>(this.segments);
        int currentOffset = 0;
        for (int i = 0; i < this.segments.size(); ++i) {
            boolean shouldSplitSegment;
            Segment segment = this.segments.get(i);
            int segmentLength = segment.text.length();
            if (offset > currentOffset + segmentLength) {
                currentOffset += segmentLength;
                continue;
            }
            int inSegmentOffset = offset - currentOffset;
            combinedSegments.remove(i);
            combinedSegments.addAll(i, text.segments);
            boolean bl = shouldSplitSegment = offset < currentOffset + segmentLength;
            if (shouldSplitSegment) {
                Segment segmentEndPart = new Segment(segment.text.substring(inSegmentOffset), segment.color, segment.modifiers);
                combinedSegments.add(i + text.segments.size(), segmentEndPart);
            }
            if (offset - currentOffset <= 0) break;
            Segment segmentStartPart = new Segment(segment.text.substring(0, inSegmentOffset), segment.color, segment.modifiers);
            combinedSegments.add(i, segmentStartPart);
            break;
        }
        return new RichText(combinedSegments).mergeSimilarSegments();
    }

    public RichText applyFormatting(int start, int end, @Nullable class_124 newColor, Set<class_124> addModifiers, Set<class_124> removeModifiers) {
        if (start == end) {
            return this;
        }
        int current = 0;
        ArrayList<Segment> newSegments = new ArrayList<Segment>();
        for (Segment segment : this.segments) {
            int length = segment.text.length();
            if (current + length <= start) {
                newSegments.add(segment);
                current += length;
                continue;
            }
            if (current >= end) {
                newSegments.add(segment);
                continue;
            }
            int localStart = Math.max(0, start - current);
            int localEnd = Math.min(length, end - current);
            if (localStart > 0) {
                newSegments.add(new Segment(segment.text.substring(0, localStart), segment.color, segment.modifiers));
            }
            String modifiedText = segment.text.substring(localStart, localEnd);
            class_124 color = Optional.ofNullable(newColor).orElse(segment.color);
            HashSet<class_124> modifiers = new HashSet<class_124>(segment.modifiers);
            modifiers.addAll(addModifiers);
            modifiers.removeAll(removeModifiers);
            newSegments.add(new Segment(modifiedText, color, modifiers));
            if (localEnd < length) {
                newSegments.add(new Segment(segment.text.substring(localEnd), segment.color, segment.modifiers));
            }
            current += length;
        }
        return new RichText(newSegments);
    }

    public String getAsFormattedString() {
        StringBuilder out = new StringBuilder();
        class_124 currentColor = class_124.field_1074;
        Set<Object> currentModifiers = new HashSet();
        for (Segment segment : this.segments) {
            if (segment.text.isEmpty()) continue;
            boolean colorChanged = !segment.color.equals((Object)currentColor);
            HashSet modifiersToRemove = new HashSet(currentModifiers);
            modifiersToRemove.removeAll(segment.modifiers);
            boolean shouldReapply = colorChanged || !modifiersToRemove.isEmpty();
            ArrayList<class_124> modifiersToAdd = new ArrayList<class_124>(segment.modifiers);
            if (!shouldReapply) {
                modifiersToAdd.removeAll(currentModifiers);
            }
            if (colorChanged || shouldReapply) {
                out.append(segment.color);
            }
            modifiersToAdd.sort(Comparator.comparingInt(class_124::method_36145));
            for (class_124 format : modifiersToAdd) {
                out.append(format);
            }
            out.append(segment.text);
            currentColor = segment.color;
            currentModifiers = segment.modifiers;
        }
        return out.toString();
    }

    public class_5250 getAsMutableComponent() {
        final RichText text = this;
        return class_5250.method_43477((class_7417)new class_7417(){

            public <T> Optional<T> method_27660(class_5348.class_5246<T> consumer, class_2583 style) {
                return text.method_27658(consumer, style);
            }

            public <T> Optional<T> method_27659(class_5348.class_5245<T> consumer) {
                return text.method_27657(consumer);
            }

            public MapCodec<? extends class_7417> method_74063() {
                return class_8828.field_46623;
            }
        });
    }

    public Pair<@Nullable class_124, Set<class_124>> getCommonFormat(int start, int end) {
        boolean first = true;
        Set modifiers = Set.of();
        class_124 color = class_124.field_1074;
        int current = 0;
        for (Segment segment : this.segments) {
            int length = segment.text.length();
            if (start == end && start <= current + length) {
                return new Pair((Object)segment.color, segment.modifiers);
            }
            if (current + length <= start) {
                current += length;
                continue;
            }
            if (current >= end) break;
            if (first) {
                modifiers = new HashSet<class_124>(segment.modifiers);
                color = segment.color;
                first = false;
            } else {
                modifiers.retainAll(segment.modifiers);
                if (color != segment.color) {
                    color = null;
                }
            }
            current += length;
        }
        return new Pair((Object)color, modifiers);
    }

    public <T> Optional<T> method_27657(class_5348.class_5245<T> consumer) {
        for (Segment segment : this.segments) {
            Optional out = consumer.accept(segment.text);
            if (!out.isPresent()) continue;
            return out;
        }
        return Optional.empty();
    }

    public <T> Optional<T> method_27658(class_5348.class_5246<T> consumer, class_2583 baseStyle) {
        for (Segment segment : this.segments) {
            class_2583 style = baseStyle.method_27705(segment.modifiers.toArray(new class_124[0])).method_27706(segment.color);
            Optional out = consumer.accept(style, segment.text);
            if (!out.isPresent()) continue;
            return out;
        }
        return Optional.empty();
    }

    public String getString() {
        return this.getPlainText();
    }

    public String toString() {
        return "RichText{segments=" + String.valueOf(this.segments) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RichText richText = (RichText)o;
        return Objects.equals(this.segments, richText.segments);
    }

    public int hashCode() {
        return Objects.hashCode(this.segments);
    }

    public record Segment(String text, class_124 color, Set<class_124> modifiers) {
    }
}

