/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble;

import com.google.gson.JsonObject;
import me.chrr.tapestry.config.NamingStrategy;
import me.chrr.tapestry.config.ReflectedConfig;
import me.chrr.tapestry.config.annotation.Header;
import me.chrr.tapestry.config.annotation.Hidden;
import me.chrr.tapestry.config.annotation.SerializeName;
import me.chrr.tapestry.config.annotation.TranslationPrefix;
import me.chrr.tapestry.config.annotation.UpgradeRewriter;
import me.chrr.tapestry.config.value.Value;
import org.jspecify.annotations.NullMarked;

@NullMarked
@TranslationPrefix(value="config.scribble")
@SerializeName.Strategy(value=NamingStrategy.SNAKE_CASE)
public class ScribbleConfig
extends ReflectedConfig {
    @Hidden
    public Value<Integer> pagesToShow = this.value(1);
    @Header(value="appearance")
    public Value<Boolean> doublePageViewing = this.map(this.pagesToShow, n -> n > 1, b -> b != false ? 2 : 1);
    public Value<Boolean> centerBookGui = this.value(true);
    public Value<Boolean> showFormattingButtons = this.value(true);
    public Value<ShowActionButtons> showActionButtons = this.value(ShowActionButtons.WHEN_EDITING);
    @Header(value="behaviour")
    public Value<Boolean> copyFormattingCodes = this.value(true);
    public Value<Integer> editHistorySize = this.value(32).range(8, 128, 1);
    @Header(value="miscellaneous")
    public Value<Boolean> openVanillaBookScreenOnShift = this.value(false);

    @UpgradeRewriter(currentVersion=3)
    public static void upgrade(int fromVersion, JsonObject config) {
        if (fromVersion < 3) {
            config.addProperty("show_action_buttons", config.get("show_save_load_buttons").getAsBoolean() ? "WHEN_EDITING" : "NEVER");
        }
    }

    public static enum ShowActionButtons {
        ALWAYS,
        WHEN_EDITING,
        NEVER;

    }
}

