/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.freecam.ui;

import com.zergatul.freecam.ui.ValueMapper;

public abstract class ExponentialValueMapper
implements ValueMapper {
    private final double a;
    private final double b;
    private final double c;

    public ExponentialValueMapper(double min, double mid, double max) {
        this.a = min;
        this.b = max / min;
        this.c = Math.log(Math.log(mid / min) / Math.log(max / min)) / Math.log(0.5);
    }

    @Override
    public double toSliderValue(double value) {
        return Math.pow(Math.log(value / this.a) / Math.log(this.b), 1.0 / this.c);
    }

    @Override
    public double toSettingValue(double value) {
        return this.a * Math.pow(this.b, Math.pow(value, this.c));
    }
}

