/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.freecam;

import com.zergatul.freecam.FreeCam;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_243;

public class FreeCamPath {
    private final FreeCam freeCam;
    private final List<Entry> entries = new ArrayList<Entry>();

    public FreeCamPath(FreeCam freeCam) {
        this.freeCam = freeCam;
    }

    public boolean add(double time) {
        if (!this.freeCam.isActive()) {
            return false;
        }
        this.entries.add(new Entry(new class_243(this.freeCam.getX(), this.freeCam.getY(), this.freeCam.getZ()), this.freeCam.getXRot(), this.freeCam.getYRot(), time));
        return true;
    }

    public void clear() {
        this.entries.clear();
    }

    public List<Entry> get() {
        return this.entries;
    }

    public Entry interpolate(double time) {
        for (int i = 1; i < this.entries.size(); ++i) {
            Entry e2 = this.entries.get(i);
            if (time < e2.time) {
                Entry e1 = this.entries.get(i - 1);
                double factor = time / e2.time;
                return this.interpolate(e1, e2, factor);
            }
            time -= e2.time;
        }
        return null;
    }

    private Entry interpolate(Entry e1, Entry e2, double factor) {
        class_243 pos = new class_243(e1.position.field_1352 + (e2.position.field_1352 - e1.position.field_1352) * factor, e1.position.field_1351 + (e2.position.field_1351 - e1.position.field_1351) * factor, e1.position.field_1350 + (e2.position.field_1350 - e1.position.field_1350) * factor);
        double xRot = e1.xRot + (e2.xRot - e1.xRot) * factor;
        double yRot = e1.yRot + (e2.yRot - e1.yRot) * factor;
        return new Entry(pos, xRot, yRot, 0.0);
    }

    public record Entry(class_243 position, double xRot, double yRot, double time) {
    }
}

