/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.freecam;

public class FreeCamConfig {
    public static final double MinAcceleration = 5.0;
    public static final double DefaultAcceleration = 50.0;
    public static final double MaxAcceleration = 500.0;
    public static final double MinMaxSpeed = 5.0;
    public static final double DefaultMaxSpeed = 50.0;
    public static final double MaxMaxSpeed = 500.0;
    public static final double MinSlowdownFactor = 1.0E-9;
    public static final double DefaultSlowdownFactor = 0.01;
    public static final double MaxSlowdownFactor = 0.5;
    public double acceleration = 50.0;
    public double maxSpeed = 50.0;
    public double slowdownFactor = 0.01;
    public boolean renderHands;
    public boolean target = true;
    public boolean spectatorMovement;
    public boolean rememberInputState;
    public boolean showMyName;

    public void clamp() {
        if (this.acceleration < 5.0 || this.acceleration > 500.0) {
            this.acceleration = 50.0;
        }
        if (this.maxSpeed < 5.0 || this.maxSpeed > 500.0) {
            this.maxSpeed = 50.0;
        }
        if (this.slowdownFactor < 1.0E-9 || this.slowdownFactor > 0.5) {
            this.slowdownFactor = 0.01;
        }
    }

    public FreeCamConfig clone() {
        FreeCamConfig copy = new FreeCamConfig();
        copy.acceleration = this.acceleration;
        copy.maxSpeed = this.maxSpeed;
        copy.slowdownFactor = this.slowdownFactor;
        copy.renderHands = this.renderHands;
        copy.target = this.target;
        copy.spectatorMovement = this.spectatorMovement;
        copy.rememberInputState = this.rememberInputState;
        copy.showMyName = this.showMyName;
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FreeCamConfig) {
            FreeCamConfig other = (FreeCamConfig)obj;
            return other.acceleration == this.acceleration && other.maxSpeed == this.maxSpeed && other.slowdownFactor == this.slowdownFactor && other.renderHands == this.renderHands && other.target == this.target && other.spectatorMovement == this.spectatorMovement && other.rememberInputState == this.rememberInputState && other.showMyName == this.showMyName;
        }
        return false;
    }
}

