/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.freecam;

import com.zergatul.freecam.ConfigRepository;
import com.zergatul.freecam.FreeCam;
import com.zergatul.freecam.FreeCamConfig;
import com.zergatul.freecam.FreeCamPath;
import com.zergatul.freecam.ui.FreeCamSettingsScreen;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ChatCommandManager {
    public static final ChatCommandManager instance = new ChatCommandManager();
    private final class_5250 chatPrefix = class_2561.method_43470((String)"[freecam]").method_27692(class_124.field_1060).method_27693(" ");
    private final ParserEntry[] patterns = new ParserEntry[]{new ParserEntry(Pattern.compile("^\\.freecam$"), this::openSettings), new ParserEntry(Pattern.compile("^\\.freecam\\s+show$"), this::showCurrentSettings), new ParserEntry(Pattern.compile("^\\.freecam\\s+path$"), this::showPathInfo), new ParserEntry(Pattern.compile("^\\.freecam\\s+path\\s+clear$"), this::clearPath), new ParserEntry(Pattern.compile("^\\.freecam\\s+path\\s+add\\s+(?<value>\\S+)$"), this.setDoubleValue(this::addPathPoint)), new ParserEntry(Pattern.compile("^\\.freecam\\s+(maxspeed|max|speed|s)\\s+(?<value>\\S+)$"), this.setDoubleValue(this::setMaxSpeed)), new ParserEntry(Pattern.compile("^\\.freecam\\s+(acceleration|acc|a)\\s+(?<value>\\S+)$"), this.setDoubleValue(this::setAcceleration)), new ParserEntry(Pattern.compile("^\\.freecam\\s+(slowdown|slow|sd)\\s+(?<value>\\S+)$"), this.setDoubleValue(this::setSlowDown)), new ParserEntry(Pattern.compile("^\\.freecam\\s+(hands)\\s+(?<value>\\S+)$"), this.setDoubleValue(this::setHands)), new ParserEntry(Pattern.compile("^\\.freecam\\s+(target)\\s+(?<value>\\S+)$"), this.setDoubleValue(this::setTarget)), new ParserEntry(Pattern.compile("^\\.freecam\\s+(movement)\\s+(?<value>\\S+)$"), this::setMovementMode)};
    private int openSettingsScreenTicks = -1;

    private ChatCommandManager() {
    }

    public void onClientTickEnd() {
        if (this.openSettingsScreenTicks > 0) {
            --this.openSettingsScreenTicks;
            if (this.openSettingsScreenTicks == 0) {
                this.openSettingsScreenTicks = -1;
                class_310.method_1551().method_1507((class_437)new FreeCamSettingsScreen());
            }
        }
    }

    public boolean handleChatMessage(String message) {
        if (message == null) {
            return false;
        }
        if (!(message = message.toLowerCase(Locale.ROOT)).startsWith(".freecam")) {
            return false;
        }
        message = message.trim();
        FreeCamConfig config = FreeCam.instance.getConfig();
        boolean accepted = false;
        for (ParserEntry entry : this.patterns) {
            Matcher matcher = entry.pattern.matcher(message);
            if (!matcher.matches()) continue;
            entry.consumer.accept(config, matcher);
            accepted = true;
            break;
        }
        if (!accepted) {
            this.printHelp();
        }
        return true;
    }

    private void openSettings(FreeCamConfig config, Matcher matcher) {
        this.openSettingsScreenTicks = 4;
    }

    private void showCurrentSettings(FreeCamConfig config, Matcher matcher) {
        this.printSystemMessage((class_2561)this.chatPrefix.method_27661().method_10852((class_2561)class_2561.method_43470((String)"Current settings").method_27692(class_124.field_1054)).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)("- maxspeed=" + config.maxSpeed)).method_27692(class_124.field_1068)).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)("- acceleration=" + config.acceleration)).method_27692(class_124.field_1068)).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)("- slowdown=" + config.slowdownFactor)).method_27692(class_124.field_1068)).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)("- hands=" + (config.renderHands ? 1 : 0))).method_27692(class_124.field_1068)).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)("- target=" + (config.target ? 1 : 0))).method_27692(class_124.field_1068)).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)("- movement=" + (config.spectatorMovement ? "spectator" : "default"))).method_27692(class_124.field_1068)));
    }

    private void showPathInfo(FreeCamConfig config, Matcher matcher) {
        this.printSystemMessage((class_2561)this.chatPrefix.method_27661().method_10852((class_2561)class_2561.method_43470((String)"Current path: ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)String.format("%s points", FreeCam.instance.getPath().get().size())).method_27692(class_124.field_1068)));
    }

    private void clearPath(FreeCamConfig config, Matcher matcher) {
        FreeCam.instance.getPath().get().clear();
    }

    private BiConsumer<FreeCamConfig, Matcher> setDoubleValue(BiConsumer<FreeCamConfig, Double> consumer) {
        return (config, matcher) -> {
            double value;
            try {
                value = Double.parseDouble(matcher.group("value"));
            }
            catch (NumberFormatException e) {
                value = Double.NaN;
            }
            if (Double.isNaN(value)) {
                this.printError("Cannot parse value");
            } else {
                consumer.accept((FreeCamConfig)config, value);
            }
        };
    }

    private void setMovementMode(FreeCamConfig config, Matcher matcher) {
        switch (matcher.group("value")) {
            case "default": {
                config.spectatorMovement = false;
                this.saveConfig(config);
                break;
            }
            case "spectator": {
                config.spectatorMovement = true;
                this.saveConfig(config);
                break;
            }
            default: {
                this.printError("Allowed values: default, spectator");
            }
        }
    }

    private void addPathPoint(FreeCamConfig config, double value) {
        FreeCamPath path = FreeCam.instance.getPath();
        boolean added = false;
        if (path.get().isEmpty()) {
            added = FreeCam.instance.getPath().add(0.0);
        } else if (value < 0.0 || value > 3600000.0) {
            this.printError("Delay out of range. Accepted values: 0..3600000");
        } else {
            added = FreeCam.instance.getPath().add(value);
        }
        if (added) {
            this.printSystemMessage((class_2561)this.chatPrefix.method_27661().method_10852((class_2561)class_2561.method_43470((String)"Point added").method_27692(class_124.field_1054)));
        }
    }

    private void setMaxSpeed(FreeCamConfig config, double value) {
        if (value < 5.0 || value > 500.0) {
            this.printError("Value out of range. Allowed range: [5.0 - 500.0]");
        } else {
            config.maxSpeed = value;
            this.saveConfig(config);
        }
    }

    private void setAcceleration(FreeCamConfig config, double value) {
        if (value < 5.0 || value > 500.0) {
            this.printError("Value out of range. Allowed range: [5.0 - 500.0]");
        } else {
            config.acceleration = value;
            this.saveConfig(config);
        }
    }

    private void setSlowDown(FreeCamConfig config, double value) {
        if (value < 1.0E-9 || value > 0.5) {
            this.printError("Value out of range. Allowed range: [1.0E-9 - 0.5]");
        } else {
            config.slowdownFactor = value;
            this.saveConfig(config);
        }
    }

    private void setHands(FreeCamConfig config, double value) {
        if (value == 0.0) {
            config.renderHands = false;
            this.saveConfig(config);
        } else if (value == 1.0) {
            config.renderHands = true;
            this.saveConfig(config);
        } else {
            this.printError("Invalid value. Only 0 or 1 accepted.");
        }
    }

    private void setTarget(FreeCamConfig config, double value) {
        if (value == 0.0) {
            config.target = false;
            this.saveConfig(config);
        } else if (value == 1.0) {
            config.target = true;
            this.saveConfig(config);
        } else {
            this.printError("Invalid value. Only 0 or 1 accepted.");
        }
    }

    private void saveConfig(FreeCamConfig config) {
        ConfigRepository.instance.save(config);
        this.printInfo("Config updated");
    }

    private void printInfo(String message) {
        this.printSystemMessage((class_2561)this.chatPrefix.method_27661().method_10852((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1065)));
    }

    private void printError(String message) {
        this.printSystemMessage((class_2561)this.chatPrefix.method_27661().method_10852((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1061)));
    }

    private void printHelp() {
        this.printSystemMessage((class_2561)this.chatPrefix.method_27661().method_10852((class_2561)class_2561.method_43470((String)"Invalid syntax").method_27692(class_124.field_1061)).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)"- ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".freecam").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" open settings menu").method_27692(class_124.field_1068)).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)"- ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".freecam maxspeed 50").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" set maximum speed, blocks/second").method_27692(class_124.field_1068)).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)" (synonyms: max, speed, s)").method_27692(class_124.field_1075)).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)"- ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".freecam acceleration 50").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" set acceleration speed, blocks/second^2").method_27692(class_124.field_1068)).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)" (synonyms: acc, a)").method_27692(class_124.field_1075)).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)"- ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".freecam slowdown 0.01").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" set slow down speed. When no keys is pressed speed is multiplied by this value every second.").method_27692(class_124.field_1068)).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)" (synonyms: slow, sd)").method_27692(class_124.field_1075)).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)"- ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".freecam hands 1").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" render hands while in freecam. Values: 0/1.").method_27692(class_124.field_1068)).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)"- ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".freecam target 0").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" disable custom targeting in freecam. Values: 0/1.").method_27692(class_124.field_1068)).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)"- ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".freecam movement spectator").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" change movement mode to spectator-like. Values: default/spectator.").method_27692(class_124.field_1068)));
    }

    private void printSystemMessage(class_2561 component) {
        class_310.method_1551().method_44714().method_44736(component, false);
    }

    private record ParserEntry(Pattern pattern, BiConsumer<FreeCamConfig, Matcher> consumer) {
    }
}

