/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.schematicpreview.render;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.litematica.render.schematic.IBufferBuilderPatch;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.SequencedCollection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1059;
import net.minecraft.class_10896;
import net.minecraft.class_11282;
import net.minecraft.class_11515;
import net.minecraft.class_11531;
import net.minecraft.class_11532;
import net.minecraft.class_11659;
import net.minecraft.class_11661;
import net.minecraft.class_11684;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1920;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4618;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_776;
import net.minecraft.class_824;
import net.minecraft.class_8251;
import net.minecraft.class_827;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import ru.dimaskama.schematicpreview.SchematicPreview;
import ru.dimaskama.schematicpreview.render.CustomVertexConsumerProvider;
import ru.dimaskama.schematicpreview.render.DummyOutlineVertexConsumerProvider;
import ru.dimaskama.schematicpreview.render.DummyVertexConsumerProvider;
import ru.dimaskama.schematicpreview.render.WorldSchematicWrapper;

public class SchematicPreviewRenderer
implements AutoCloseable {
    private final WorldSchematicWrapper world;
    private final class_776 blockRenderManager;
    private final class_824 blockEntityRenderManager;
    private final class_11661 orderedRenderCommandQueue;
    private final CustomVertexConsumerProvider customVertexConsumerProvider;
    private final class_11684 renderDispatcher;
    private final List<ChunkEntry> chunks = new ArrayList<ChunkEntry>();
    private final Vector3f pos = new Vector3f(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE);
    private class_1923 chunkPos = new class_1923(Integer.MIN_VALUE, Integer.MIN_VALUE);
    private class_12075 cameraRenderState;
    private boolean updated;
    private boolean canceled;
    private class_276 target;

    public SchematicPreviewRenderer(class_310 mc) {
        this.world = new WorldSchematicWrapper(mc);
        this.blockRenderManager = mc.method_1541();
        this.blockEntityRenderManager = mc.method_31975();
        this.orderedRenderCommandQueue = new class_11661();
        this.customVertexConsumerProvider = new CustomVertexConsumerProvider(mc.method_22940().method_23000());
        this.renderDispatcher = new class_11684(this.orderedRenderCommandQueue, this.blockRenderManager, (class_4597.class_4598)this.customVertexConsumerProvider, mc.method_72703(), (class_4618)new DummyOutlineVertexConsumerProvider(), (class_4597.class_4598)new DummyVertexConsumerProvider(), mc.field_1772);
    }

    public void setup(LitematicaSchematic schematic) {
        this.close();
        this.world.setSchematic(schematic);
        int height = this.world.getSize().method_10264();
        int chunksX = this.world.getSize().method_10263() >>> 4;
        int chunksZ = this.world.getSize().method_10260() >>> 4;
        for (int chunkX = 0; chunkX <= chunksX; ++chunkX) {
            for (int chunkZ = 0; chunkZ <= chunksZ; ++chunkZ) {
                class_1923 chunkPos = new class_1923(chunkX, chunkZ);
                this.chunks.add(new ChunkEntry(chunkPos, CompletableFuture.supplyAsync(() -> {
                    class_6575 random = new class_6575(0L);
                    BuiltChunk chunk = new BuiltChunk();
                    class_4587 matrices = new class_4587();
                    class_2338.class_2339 worldPos = new class_2338.class_2339();
                    int chunkStartX = chunkPos.method_8326();
                    int chunkStartZ = chunkPos.method_8328();
                    int chunkEndX = chunkStartX + 16;
                    int chunkEndZ = chunkStartZ + 16;
                    for (int y = 0; y < height; ++y) {
                        for (int z = chunkStartZ; z < chunkEndZ; ++z) {
                            for (int x = chunkStartX; x < chunkEndX; ++x) {
                                class_287 builder;
                                class_11515 layer;
                                boolean renderBlock;
                                if (this.canceled) {
                                    chunk.close();
                                    return null;
                                }
                                worldPos.method_10103(x, y, z);
                                class_2680 state = this.world.method_8320((class_2338)worldPos);
                                class_3610 fluid = state.method_26227();
                                boolean renderFluid = !fluid.method_15769();
                                boolean bl = renderBlock = state.method_26217() == class_2464.field_11458;
                                if (!renderFluid && !renderBlock) continue;
                                matrices.method_22903();
                                matrices.method_46416((float)(worldPos.method_10263() & 0xF), (float)worldPos.method_10264(), (float)(worldPos.method_10260() & 0xF));
                                if (renderFluid) {
                                    layer = class_4696.method_23680((class_3610)fluid);
                                    builder = chunk.getBuilderByLayer(layer);
                                    ((IBufferBuilderPatch)builder).litematica$setOffsetY((float)(worldPos.method_10264() >> 4 << 4));
                                    this.blockRenderManager.method_3352((class_2338)worldPos, (class_1920)this.world, (class_4588)builder, state, fluid);
                                    ((IBufferBuilderPatch)builder).litematica$setOffsetY(0.0f);
                                }
                                if (renderBlock) {
                                    layer = class_4696.method_23679((class_2680)state);
                                    builder = chunk.getBuilderByLayer(layer);
                                    this.blockRenderManager.method_3350().method_3361((class_1920)this.world, this.blockRenderManager.method_3349(state).method_68512((class_5819)random), state, (class_2338)worldPos, matrices, (class_4588)builder, true, class_4608.field_21444);
                                }
                                matrices.method_22909();
                            }
                        }
                    }
                    return chunk;
                })));
            }
        }
    }

    public void prepareRender(class_12075 cameraRenderState, class_276 target) {
        this.cameraRenderState = cameraRenderState;
        this.target = target;
        boolean bl = this.updated = !this.pos.equals((float)cameraRenderState.field_63078.field_1352, (float)cameraRenderState.field_63078.field_1351, (float)cameraRenderState.field_63078.field_1350);
        if (this.updated) {
            this.pos.set(cameraRenderState.field_63078.field_1352, cameraRenderState.field_63078.field_1351, cameraRenderState.field_63078.field_1350);
            class_1923 chunkPos = new class_1923(class_3532.method_15357((double)cameraRenderState.field_63078.field_1352) >> 4, class_3532.method_15357((double)cameraRenderState.field_63078.field_1350) >> 4);
            if (!this.chunkPos.equals((Object)chunkPos)) {
                this.chunkPos = chunkPos;
                this.chunks.sort(Comparator.comparingInt(chunk -> -(Math.abs(chunk.pos.field_9181 - chunkPos.field_9181) + Math.abs(chunk.pos.field_9180 - chunkPos.field_9180))));
            }
        }
    }

    private class_11532 prepareChunks() {
        Iterator<ChunkEntry> chunkIterator = this.chunks.iterator();
        EnumMap enumMap = new EnumMap(class_11515.class);
        int i = 0;
        for (class_11515 chunkSectionLayer : class_11515.values()) {
            enumMap.put(chunkSectionLayer, new ArrayList());
        }
        ArrayList<class_11282.class_12294> list = new ArrayList<class_11282.class_12294>();
        GpuTextureView gpuTextureView = class_310.method_1551().method_1531().method_4619(class_1059.field_5275).method_71659();
        int j = gpuTextureView.getWidth(0);
        int k = gpuTextureView.getHeight(0);
        while (chunkIterator.hasNext()) {
            BuiltChunk built;
            ChunkEntry chunk = chunkIterator.next();
            if (!chunk.future.isDone() || (built = chunk.future.join()) == null) continue;
            class_8251 vertexSorter = class_8251.method_49906((float)(this.pos.x - (float)chunk.pos().method_8326()), (float)this.pos.y, (float)(this.pos.z - (float)chunk.pos().method_8328()));
            int m = -1;
            for (class_11515 chunkSectionLayer2 : class_11515.values()) {
                VertexFormat.class_5595 indexType;
                GpuBuffer gpuBuffer;
                class_10896 sectionBuffers;
                built.uploadBuffer(chunkSectionLayer2, vertexSorter);
                if (this.updated) {
                    built.resortTransparent(chunkSectionLayer2, vertexSorter);
                }
                if ((sectionBuffers = built.buffers.get(chunkSectionLayer2)) == null) continue;
                if (m == -1) {
                    m = list.size();
                    list.add(new class_11282.class_12294((Matrix4fc)new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix()), chunk.pos().method_8326(), 0, chunk.pos().method_8328(), 1.0f, j, k));
                }
                if (sectionBuffers.method_68544() == null) {
                    if (sectionBuffers.method_68546() > i) {
                        i = sectionBuffers.method_68546();
                    }
                    gpuBuffer = null;
                    indexType = null;
                } else {
                    gpuBuffer = sectionBuffers.method_68544();
                    indexType = sectionBuffers.method_68547();
                }
                int finalM = m;
                ((List)enumMap.get(chunkSectionLayer2)).add(new RenderPass.class_10884(0, sectionBuffers.method_68540(), gpuBuffer, indexType, 0, sectionBuffers.method_68546(), (gpuBufferSlicesx, uniformUploader) -> uniformUploader.upload("ChunkSection", gpuBufferSlicesx[finalM])));
            }
        }
        GpuBufferSlice[] gpuBufferSlices = RenderSystem.getDynamicUniforms().method_76294(list.toArray(new class_11282.class_12294[0]));
        return new class_11532(gpuTextureView, enumMap, i, gpuBufferSlices);
    }

    private void renderChunkSectionsLayer(class_11532 chunks, class_11531 group) {
        RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        GpuBuffer gpuBuffer = chunks.comp_4403() == 0 ? null : autoStorageIndexBuffer.method_68274(chunks.comp_4403());
        VertexFormat.class_5595 indexType = chunks.comp_4403() == 0 ? null : autoStorageIndexBuffer.method_31924();
        class_11515[] chunkSectionLayers = group.method_72167();
        class_310 minecraft = class_310.method_1551();
        try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Section layers for " + group.method_72166(), this.target.method_71639(), OptionalInt.empty(), this.target.method_71640(), OptionalDouble.empty());){
            RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
            renderPass.bindTexture("Sampler2", minecraft.field_1773.method_22974().method_71650(), RenderSystem.getSamplerCache().method_75294(FilterMode.LINEAR));
            for (class_11515 chunkSectionLayer : chunkSectionLayers) {
                SequencedCollection list = (List)chunks.comp_4402().get(chunkSectionLayer);
                if (list.isEmpty()) continue;
                if (chunkSectionLayer == class_11515.field_60926) {
                    list = list.reversed();
                }
                renderPass.setPipeline(chunkSectionLayer.method_72020());
                renderPass.bindTexture("Sampler0", chunks.comp_5192(), RenderSystem.getSamplerCache().method_75294(FilterMode.LINEAR));
                renderPass.drawMultipleIndexed((Collection)list, gpuBuffer, indexType, List.of("ChunkSection"), (Object)chunks.comp_5193());
            }
        }
    }

    public void renderBlocks() {
        class_11532 chunkSectionsToRender = this.prepareChunks();
        this.renderChunkSectionsLayer(chunkSectionsToRender, class_11531.field_61022);
        this.renderChunkSectionsLayer(chunkSectionsToRender, class_11531.field_61023);
        this.renderChunkSectionsLayer(chunkSectionsToRender, class_11531.field_61024);
    }

    public void renderBlockEntities(class_4587 stack, float tickDelta) {
        if (this.getBuiltChunksCount() != this.chunks.size()) {
            return;
        }
        this.customVertexConsumerProvider.setFramebuffer(this.target);
        this.world.getBlockEntities().forEach((pos, blockEntitySupplier) -> {
            class_827 renderer;
            class_2586 blockEntity = (class_2586)blockEntitySupplier.get();
            if (blockEntity != null && (renderer = this.blockEntityRenderManager.method_3550(blockEntity)) != null) {
                class_11954 renderState = renderer.method_74335();
                stack.method_22903();
                stack.method_46416((float)pos.method_10263() - this.pos.x, (float)pos.method_10264() - this.pos.y, (float)pos.method_10260() - this.pos.z);
                try {
                    renderer.method_74331(blockEntity, renderState, tickDelta, this.cameraRenderState.field_63078, null);
                    renderer.method_3569(renderState, stack, (class_11659)this.orderedRenderCommandQueue, this.cameraRenderState);
                }
                catch (Exception e) {
                    SchematicPreview.LOGGER.debug("Exception while rendering preview block entity", (Throwable)e);
                }
                stack.method_22909();
            }
        });
        this.renderDispatcher.method_73002();
        this.customVertexConsumerProvider.method_22993();
    }

    public int getBuiltChunksCount() {
        return (int)this.chunks.stream().map(ChunkEntry::future).filter(CompletableFuture::isDone).count();
    }

    public boolean isBuildingTerrain() {
        return !this.chunks.isEmpty() && this.chunks.stream().map(ChunkEntry::future).noneMatch(CompletableFuture::isDone);
    }

    @Override
    public void close() {
        this.canceled = true;
        this.chunks.stream().map(ChunkEntry::future).map(CompletableFuture::join).filter(Objects::nonNull).forEach(BuiltChunk::close);
        this.canceled = false;
        this.chunks.clear();
        this.pos.set(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.chunkPos = new class_1923(Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.renderDispatcher.close();
    }

    private record ChunkEntry(class_1923 pos, CompletableFuture<@Nullable BuiltChunk> future) {
    }

    private record BuiltChunk(Map<class_11515, class_287> builderCache, Map<class_11515, class_9799> allocatorCache, Map<class_11515, class_9801> builtBuffers, Map<class_11515, class_9801.class_9802> sortStates, Map<class_11515, class_10896> buffers) implements AutoCloseable
    {
        private BuiltChunk() {
            this(new HashMap<class_11515, class_287>(), new HashMap<class_11515, class_9799>(), new HashMap<class_11515, class_9801>(), new HashMap<class_11515, class_9801.class_9802>(), new HashMap<class_11515, class_10896>());
        }

        private void uploadBuffer(class_11515 layer, class_8251 vertexSorter) {
            class_9801.class_9802 sortState;
            class_10896 buffers = this.buffers.get(layer);
            if (buffers != null) {
                return;
            }
            class_287 builder = this.builderCache.get(layer);
            if (builder == null || !builder.field_1556) {
                return;
            }
            class_9801 built = builder.method_60794();
            if (built == null) {
                return;
            }
            this.builtBuffers.put(layer, built);
            if (layer == class_11515.field_60926 && (sortState = built.method_60819(this.allocatorCache.get(layer), vertexSorter)) != null) {
                this.sortStates.put(layer, sortState);
            }
            GpuBuffer vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "SchematicPreview vertex buffer", 40, built.method_60818());
            GpuBuffer indexBuffer = built.method_60821() != null ? RenderSystem.getDevice().createBuffer(() -> "SchematicPreview index buffer", 72, built.method_60821()) : null;
            buffers = new class_10896(vertexBuffer, indexBuffer, built.method_60822().comp_751(), built.method_60822().comp_753());
            this.buffers.put(layer, buffers);
        }

        private void resortTransparent(class_11515 layer, class_8251 vertexSorter) {
            GpuBuffer indexBuffer;
            class_10896 buffers;
            class_9801.class_9802 sortState = this.sortStates.get(layer);
            if (sortState != null && (buffers = this.buffers.get(layer)) != null && (indexBuffer = buffers.method_68544()) != null && !indexBuffer.isClosed()) {
                class_9799 allocator = this.getAllocatorByLayer(layer);
                try (class_9799.class_9800 result = sortState.method_60824(allocator, vertexSorter);){
                    if (result != null) {
                        RenderSystem.getDevice().createCommandEncoder().writeToBuffer(indexBuffer.slice(), result.method_60817());
                    }
                }
            }
        }

        private class_287 getBuilderByLayer(class_11515 layer) {
            return this.builderCache.computeIfAbsent(layer, l -> new class_287(this.getAllocatorByLayer((class_11515)l), l.method_72020().getVertexFormatMode(), l.method_72020().getVertexFormat()));
        }

        private class_9799 getAllocatorByLayer(class_11515 layer) {
            return this.allocatorCache.computeIfAbsent(layer, l -> new class_9799(1536));
        }

        @Override
        public void close() {
            this.allocatorCache.values().forEach(class_9799::close);
            this.builtBuffers.values().forEach(class_9801::close);
            this.buffers.values().forEach(class_10896::close);
        }
    }
}

