/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.schematicpreview.mixin;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.gui.GuiMaterialList;
import fi.dy.masa.litematica.gui.widgets.WidgetListMaterialList;
import fi.dy.masa.litematica.gui.widgets.WidgetMaterialListEntry;
import fi.dy.masa.litematica.materials.MaterialListBase;
import fi.dy.masa.litematica.materials.MaterialListEntry;
import fi.dy.masa.litematica.materials.MaterialListPlacement;
import fi.dy.masa.litematica.materials.MaterialListSchematic;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.SchematicMetadata;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.dimaskama.schematicpreview.gui.GuiBlockSelect;
import ru.dimaskama.schematicpreview.mixin.MaterialListPlacementAccessor;
import ru.dimaskama.schematicpreview.mixin.MaterialListSchematicAccessor;
import ru.dimaskama.schematicpreview.mixin.WidgetContainerInvoker;

@Mixin(value={WidgetListMaterialList.class})
abstract class WidgetListMaterialListMixin {
    @Shadow(remap=false)
    @Final
    private GuiMaterialList gui;

    WidgetListMaterialListMixin() {
    }

    @Inject(method={"createListEntryWidget(IIIZLfi/dy/masa/litematica/materials/MaterialListEntry;)Lfi/dy/masa/litematica/gui/widgets/WidgetMaterialListEntry;"}, at={@At(value="TAIL")}, remap=false)
    private void modifyEntry(int x, int y, int listIndex, boolean isOdd, MaterialListEntry e, CallbackInfoReturnable<WidgetMaterialListEntry> cir) {
        if (this.gui.getMaterialList() instanceof MaterialListSchematic || this.gui.getMaterialList() instanceof MaterialListPlacement) {
            WidgetMaterialListEntry entry = (WidgetMaterialListEntry)cir.getReturnValue();
            String text = StringUtils.translate((String)"gui.schematicpreview.replace_block", (Object[])new Object[0]);
            int w = class_310.method_1551().field_1772.method_1727(text);
            ButtonGeneric button = new ButtonGeneric(entry.getX() + entry.getWidth() - w - 53, entry.getY() + (entry.getHeight() - 20 >> 1), w + 8, 20, text, new String[0]);
            button.setActionListener((b, mouseButton) -> {
                class_1792 patt0$temp = e.getStack().method_7909();
                if (patt0$temp instanceof class_1747) {
                    class_1747 blockItem = (class_1747)patt0$temp;
                    class_2248 oldBlock = blockItem.method_7711();
                    class_310.method_1551().method_1507((class_437)new GuiBlockSelect(class_310.method_1551().field_1755, StringUtils.translate((String)"gui.schematicpreview.replace_block.title", (Object[])new Object[]{StringUtils.translate((String)oldBlock.method_63499(), (Object[])new Object[0])}), oldBlock, newBlock -> {
                        int c = this.schematicpreview_replaceBlocks(oldBlock, (class_2248)newBlock, this.gui.getMaterialList());
                        if (c > 0) {
                            this.gui.getMaterialList().reCreateMaterialList();
                        }
                        InfoUtils.showInGameMessage((Message.MessageType)Message.MessageType.INFO, (long)5000L, (String)"gui.schematicpreview.replace_block.result", (Object[])new Object[]{c, StringUtils.translate((String)newBlock.method_63499(), (Object[])new Object[0])});
                    }));
                }
            });
            ((WidgetContainerInvoker)entry).schematicpreview_addWidget(button);
        }
    }

    @Unique
    private int schematicpreview_replaceBlocks(class_2248 oldBlock, class_2248 newBlock, MaterialListBase materialList) {
        MaterialListBase materialListBase = materialList;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MaterialListSchematic.class, MaterialListPlacement.class}, (Object)materialListBase, n)) {
            case 0 -> {
                MaterialListSchematic materialListSchematic = (MaterialListSchematic)materialListBase;
                LitematicaSchematic schematic = ((MaterialListSchematicAccessor)materialListSchematic).schematicpreview_schematic();
                ImmutableList<String> regions = ((MaterialListSchematicAccessor)materialListSchematic).schematicpreview_regions();
                yield this.schematicpreview_replaceBlocks(oldBlock, newBlock, schematic, (Collection<String>)regions);
            }
            case 1 -> {
                MaterialListPlacement materialListPlacement = (MaterialListPlacement)materialListBase;
                LitematicaSchematic schematic = ((MaterialListPlacementAccessor)materialListPlacement).schematicpreview_placement().getSchematic();
                yield this.schematicpreview_replaceBlocks(oldBlock, newBlock, schematic, schematic.getAreas().keySet());
            }
            default -> 0;
        };
    }

    @Unique
    private int schematicpreview_replaceBlocks(class_2248 oldBlock, class_2248 newBlock, LitematicaSchematic schematic, Collection<String> regions) {
        if (oldBlock == newBlock) {
            return 0;
        }
        int count = 0;
        class_2680 newBlockState = newBlock.method_9564();
        class_2769[] props = (class_2769[])oldBlock.method_9564().method_28501().stream().filter(arg_0 -> ((class_2680)newBlockState).method_28498(arg_0)).toArray(class_2769[]::new);
        for (String regionName : regions) {
            LitematicaBlockStateContainer container = schematic.getSubRegionContainer(regionName);
            if (container == null) continue;
            class_2382 size = container.getSize();
            int endY = size.method_10264();
            int endZ = size.method_10260();
            int endX = size.method_10263();
            for (int y = 0; y < endY; ++y) {
                for (int z = 0; z < endZ; ++z) {
                    for (int x = 0; x < endX; ++x) {
                        class_2680 oldState = container.get(x, y, z);
                        if (oldState.method_26204() != oldBlock) continue;
                        for (class_2769 prop : props) {
                            newBlockState = this.schematicpreview_copyProp(newBlockState, prop, oldState.method_11654(prop));
                        }
                        container.set(x, y, z, newBlockState);
                        ++count;
                    }
                }
            }
        }
        if (count > 0) {
            boolean newAir;
            SchematicMetadata metadata = schematic.getMetadata();
            boolean oldAir = oldBlock.method_9564().method_26215();
            if (oldAir != (newAir = newBlock.method_9564().method_26215())) {
                metadata.setTotalBlocks(metadata.getTotalBlocks() + count * (newAir ? -1 : 1));
            }
            metadata.setTimeModifiedToNow();
            metadata.setModifiedSinceSaved();
            DataManager.getSchematicPlacementManager().markAllPlacementsOfSchematicForRebuild(schematic);
        }
        return count;
    }

    @Unique
    private <T extends Comparable<T>> class_2680 schematicpreview_copyProp(class_2680 state, class_2769<?> prop, T value) {
        class_2769<?> casted = prop;
        return (class_2680)state.method_11657(casted, value);
    }
}

