/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.schematicpreview.gui;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.render.GuiContext;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.class_10799;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import ru.dimaskama.schematicpreview.SchematicPreview;

public class GuiBlockSelect
extends GuiBase {
    private static final class_2960 UNKNOWN_SPRITE_ID = SchematicPreview.id("unknown");
    private static final int WIDTH = 200;
    private static final int HEIGHT = 200;
    private static final int ROWS = 7;
    private static final int COLUMNS = 10;
    private static final int ITEMS_START_Y = 38;
    private final Consumer<class_2248> blockConsumer;
    private final GuiTextFieldGeneric searchField;
    @Nullable
    private class_2248 selectedBlock;
    protected int x = 0;
    protected int y = 0;
    private List<class_2248> blocks;
    private int rowIndex = 0;
    private int selectedBlockIndex;

    public GuiBlockSelect(@Nullable class_437 parent, String title, @Nullable class_2248 initialBlock, Consumer<class_2248> blockConsumer) {
        this.selectedBlock = initialBlock;
        this.blockConsumer = blockConsumer;
        this.title = title;
        this.setParent(parent);
        this.useTitleHierarchy = false;
        this.updateBlockList("");
        this.searchField = new GuiTextFieldGeneric(0, 0, 196, 20, this.font);
        this.searchField.method_47404((class_2561)class_2561.method_43471((String)"gui.schematicpreview.block_select.search").method_27694(s -> s.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true))));
        this.searchField.setMaxLengthWrapper(50);
        this.searchField.method_1863(this::updateBlockList);
    }

    private void updateBlockList(String searchInput) {
        this.rowIndex = 0;
        boolean searchInputBlank = searchInput.isBlank();
        if (!searchInputBlank) {
            searchInput = searchInput.trim().toLowerCase(Locale.ROOT);
        }
        String finalSearchInput = searchInput;
        this.blocks = class_7923.field_41175.method_42017().filter(ref -> searchInputBlank || ((class_5321)ref.method_40230().get()).toString().contains(finalSearchInput) || StringUtils.translate((String)((class_2248)ref.comp_349()).method_63499(), (Object[])new Object[0]).contains(finalSearchInput)).map(class_6880.class_6883::comp_349).sorted(Comparator.comparing(block -> StringUtils.translate((String)block.method_63499(), (Object[])new Object[0]))).toList();
        this.selectedBlockIndex = this.blocks.indexOf(this.selectedBlock);
        this.movePageTo(this.selectedBlockIndex);
    }

    private void selectBlock(int index) {
        this.selectedBlockIndex = index;
        this.selectedBlock = this.blocks.get(index);
        this.movePageTo(index);
    }

    private void movePageTo(int index) {
        if (index != -1) {
            int newRowIndex = this.rowIndex;
            int itemsOnPage = 70;
            while (index >= newRowIndex * 10 + itemsOnPage) {
                ++newRowIndex;
            }
            while (index < newRowIndex * 10) {
                --newRowIndex;
            }
            this.rowIndex = newRowIndex;
        }
    }

    private int getBlockIndexAtUnchecked(double mouseX, double mouseY) {
        int column = class_3532.method_15357((double)((mouseX - (double)this.x) / 20.0));
        int row = class_3532.method_15357((double)((mouseY - (double)this.y - 38.0) / 20.0));
        return column >= 0 && column < 10 && row >= 0 && row < 7 ? (this.rowIndex + row) * 10 + column : -1;
    }

    private int getBlockIndexAt(double mouseX, double mouseY) {
        int i = this.getBlockIndexAtUnchecked(mouseX, mouseY);
        return i < this.blocks.size() ? i : -1;
    }

    public boolean onKeyTyped(class_11908 input) {
        return this.searchField.method_25370() ? this.searchField.method_25404(input) : super.onKeyTyped(input);
    }

    public boolean onCharTyped(class_11905 input) {
        return this.searchField.method_25370() ? this.searchField.method_25400(input) : super.onCharTyped(input);
    }

    public boolean onMouseClicked(class_11909 click, boolean doubleClick) {
        int hoveredBlockIndex;
        if (click.method_74245() == 0 && (hoveredBlockIndex = this.getBlockIndexAt(click.comp_4798(), click.comp_4799())) != -1) {
            this.selectBlock(hoveredBlockIndex);
        }
        return this.searchField.method_25402(click, doubleClick) || super.onMouseClicked(click, doubleClick);
    }

    public boolean onMouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int newRowIndex;
        if (this.getBlockIndexAtUnchecked(mouseX, mouseY) != -1 && (newRowIndex = this.rowIndex + (verticalAmount < 0.0 ? 1 : -1)) >= 0 && newRowIndex * 10 < this.blocks.size()) {
            this.rowIndex = newRowIndex;
        }
        return super.onMouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void initGui() {
        super.initGui();
        this.x = this.field_22789 - 200 >> 1;
        this.y = this.field_22790 - 200 >> 1;
        this.addButton((ButtonBase)new ButtonGeneric(this.x + 2, this.y + 200 - 22, 98, 20, class_5244.field_44914.getString(), new String[0]), (buttonBase, i) -> {
            if (this.selectedBlock != null) {
                this.closeGui(true);
                this.blockConsumer.accept(this.selectedBlock);
            }
        });
        this.addButton((ButtonBase)new ButtonGeneric(this.x + 101, this.y + 200 - 22, 97, 20, class_5244.field_24335.getString(), new String[0]), (buttonBase, i) -> this.closeGui(true));
        this.searchField.method_46421(this.x + 2);
        this.searchField.method_46419(this.y + 15);
    }

    protected void drawContents(GuiContext drawContext, int mouseX, int mouseY, float partialTicks) {
        if (this.getParent() != null) {
            this.getParent().method_25394((class_332)drawContext, mouseX, mouseY, partialTicks);
        }
        RenderUtils.drawOutlinedBox((GuiContext)drawContext, (int)this.x, (int)this.y, (int)200, (int)200, (int)-1442840576, (int)-1);
        String title = this.getTitleString();
        this.drawStringWithShadow(drawContext, title, this.x + (200 - this.font.method_1727(title) >> 1), this.y + 4, -1);
        this.drawWidgets(drawContext, mouseX, mouseY);
        this.drawButtons(drawContext, mouseX, mouseY, partialTicks);
        int hoveredBlockIndex = this.getBlockIndexAt(mouseX, mouseY);
        int firstIndex = this.rowIndex * 10;
        int endIndex = firstIndex + 70;
        for (int i = firstIndex; i < endIndex; ++i) {
            if (i >= this.blocks.size()) continue;
            int pageI = i - firstIndex;
            int itemX = this.x + pageI % 10 * 20 + 2;
            int itemY = this.y + 38 + pageI / 10 * 20 + 2;
            RenderUtils.drawOutlinedBox((GuiContext)drawContext, (int)itemX, (int)itemY, (int)16, (int)16, (int)0x22FFFFFF, (int)(i == this.selectedBlockIndex ? -1 : (i == hoveredBlockIndex ? -1426063361 : 0x22FFFFFF)));
            class_2248 block = this.blocks.get(i);
            class_1792 item = block.method_8389();
            if (item == class_1802.field_8162 && block != class_2246.field_10124) {
                drawContext.method_52707(class_10799.field_56883, UNKNOWN_SPRITE_ID, itemX, itemY, 0, 16, 16);
                continue;
            }
            drawContext.method_51427(item.method_7854(), itemX, itemY);
        }
        this.searchField.method_25394((class_332)drawContext, mouseX, mouseY, partialTicks);
        if (hoveredBlockIndex != -1) {
            class_2248 hoveredBlock = this.blocks.get(hoveredBlockIndex);
            RenderUtils.drawHoverText((GuiContext)drawContext, (int)mouseX, (int)mouseY, List.of(StringUtils.translate((String)hoveredBlock.method_63499(), (Object[])new Object[0]), String.valueOf('\u00a7') + class_124.field_1063.method_36145() + String.valueOf(class_7923.field_41175.method_10221((Object)hoveredBlock))));
        }
    }
}

