/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.settings.impl;

import com.viaversion.viafabricplus.api.settings.SettingGroup;
import com.viaversion.viafabricplus.api.settings.type.BooleanSetting;
import com.viaversion.viafabricplus.api.settings.type.ButtonSetting;
import com.viaversion.viafabricplus.injection.access.base.bedrock.IConfirmScreen;
import com.viaversion.viafabricplus.save.SaveManager;
import com.viaversion.viafabricplus.save.impl.AccountsSave;
import com.viaversion.viafabricplus.screen.VFPScreen;
import com.viaversion.viafabricplus.screen.impl.SettingsScreen;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import java.util.Objects;
import net.lenni0451.commons.httpclient.HttpClient;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.raphimc.minecraftauth.MinecraftAuth;
import net.raphimc.minecraftauth.bedrock.BedrockAuthManager;
import net.raphimc.minecraftauth.bedrock.model.MinecraftMultiplayerToken;
import net.raphimc.minecraftauth.msa.service.impl.DeviceCodeMsaAuthService;
import net.raphimc.minecraftauth.util.holder.listener.ChangeListener;
import net.raphimc.viabedrock.api.BedrockProtocolVersion;

public final class BedrockSettings
extends SettingGroup {
    private static final class_2561 TITLE = class_2561.method_30163((String)"Microsoft Bedrock login");
    public static final BedrockSettings INSTANCE = new BedrockSettings();
    private Thread thread;
    private final ButtonSetting clickToSetBedrockAccount = new ButtonSetting(this, this, class_2561.method_43471((String)"bedrock_settings.viafabricplus.click_to_set_bedrock_account"), () -> {
        this.thread = new Thread(this::openBedrockAccountLogin);
        this.thread.start();
    }){

        public class_5250 displayValue() {
            BedrockAuthManager account = SaveManager.INSTANCE.getAccountsSave().getBedrockAccount();
            if (account != null && account.getMinecraftMultiplayerToken().hasValue()) {
                return class_2561.method_43469((String)"click_to_set_bedrock_account.viafabricplus.display", (Object[])new Object[]{((MinecraftMultiplayerToken)account.getMinecraftMultiplayerToken().getCached()).getDisplayName()});
            }
            return super.displayValue();
        }
    };
    public final BooleanSetting replaceDefaultPort = new BooleanSetting((SettingGroup)this, class_2561.method_43471((String)"bedrock_settings.viafabricplus.replace_default_port"), Boolean.valueOf(true));
    public final BooleanSetting experimentalFeatures = new BooleanSetting((SettingGroup)this, class_2561.method_43471((String)"bedrock_settings.viafabricplus.experimental_features"), Boolean.valueOf(true));

    public BedrockSettings() {
        super((class_2561)class_2561.method_43471((String)"setting_group_name.viafabricplus.bedrock"));
    }

    private void openBedrockAccountLogin() {
        block3: {
            AccountsSave accountsSave = SaveManager.INSTANCE.getAccountsSave();
            class_310 client = class_310.method_1551();
            class_437 prevScreen = client.field_1755;
            try {
                final BedrockAuthManager bedrockAccount = BedrockAuthManager.create((HttpClient)MinecraftAuth.createHttpClient(), (String)"1.21.130").login(DeviceCodeMsaAuthService::new, msaDeviceCode -> {
                    VFPScreen.setScreen((class_437)new class_410(copyUrl -> {
                        if (copyUrl) {
                            client.field_1774.method_1455(msaDeviceCode.getDirectVerificationUri());
                        } else {
                            client.method_1507(prevScreen);
                            this.thread.interrupt();
                        }
                    }, TITLE, (class_2561)class_2561.method_43471((String)"click_to_set_bedrock_account.viafabricplus.notice"), (class_2561)class_2561.method_43471((String)"base.viafabricplus.copy_link"), (class_2561)class_2561.method_43471((String)"base.viafabricplus.cancel")));
                    class_156.method_668().method_670(msaDeviceCode.getDirectVerificationUri());
                });
                bedrockAccount.getChangeListeners().add(new ChangeListener(){

                    public <T> void onChange(T oldValue, T newValue) {
                        if (newValue == bedrockAccount.getMsaToken().getCached()) {
                            BedrockSettings.updateLoginStatusMessage("msatoken");
                        } else if (newValue == bedrockAccount.getXblDeviceToken().getCached()) {
                            BedrockSettings.updateLoginStatusMessage("xbldevicetoken");
                        } else if (newValue == bedrockAccount.getXblUserToken().getCached()) {
                            BedrockSettings.updateLoginStatusMessage("xblusertoken");
                        } else if (newValue == bedrockAccount.getXblTitleToken().getCached()) {
                            BedrockSettings.updateLoginStatusMessage("xbltitletoken");
                        } else if (newValue == bedrockAccount.getBedrockXstsToken().getCached()) {
                            BedrockSettings.updateLoginStatusMessage("bedrockxststoken");
                        } else if (newValue == bedrockAccount.getPlayFabXstsToken().getCached()) {
                            BedrockSettings.updateLoginStatusMessage("playfabxststoken");
                        } else if (newValue == bedrockAccount.getRealmsXstsToken().getCached()) {
                            BedrockSettings.updateLoginStatusMessage("realmsxststoken");
                        } else if (newValue == bedrockAccount.getPlayFabToken().getCached()) {
                            BedrockSettings.updateLoginStatusMessage("playfabtoken");
                        } else if (newValue == bedrockAccount.getMinecraftSession().getCached()) {
                            BedrockSettings.updateLoginStatusMessage("minecraftsession");
                        } else if (newValue == bedrockAccount.getMinecraftMultiplayerToken().getCached()) {
                            BedrockSettings.updateLoginStatusMessage("minecraftmultiplayertoken");
                        } else if (newValue == bedrockAccount.getMinecraftCertificateChain().getCached()) {
                            BedrockSettings.updateLoginStatusMessage("minecraftcertificatechain");
                        }
                    }
                });
                bedrockAccount.getMinecraftMultiplayerToken().refreshIfExpired();
                bedrockAccount.getMinecraftCertificateChain().refreshIfExpired();
                accountsSave.setBedrockAccount(bedrockAccount);
                VFPScreen.setScreen(prevScreen);
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    return;
                }
                this.thread.interrupt();
                if (!(client.field_1755 instanceof SettingsScreen)) break block3;
                VFPScreen.showErrorScreen(TITLE, e, prevScreen);
            }
        }
    }

    public static String replaceDefaultPort(String address, ProtocolVersion version) {
        if (((Boolean)BedrockSettings.INSTANCE.replaceDefaultPort.getValue()).booleanValue() && Objects.equals(version, BedrockProtocolVersion.bedrockLatest) && !address.contains(":")) {
            return address + ":19132";
        }
        return address;
    }

    private static void updateLoginStatusMessage(String stepName) {
        class_310.method_1551().execute(() -> {
            class_437 patt0$temp = class_310.method_1551().field_1755;
            if (patt0$temp instanceof class_410) {
                class_410 confirmScreen = (class_410)patt0$temp;
                ((IConfirmScreen)confirmScreen).viaFabricPlus$updateMessage((class_2561)class_2561.method_43471((String)("minecraftauth_library.viafabricplus." + stepName)));
            }
        });
    }
}

