/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.screen.impl.realms;

import com.viaversion.viafabricplus.ViaFabricPlusImpl;
import com.viaversion.viafabricplus.save.SaveManager;
import com.viaversion.viafabricplus.screen.VFPList;
import com.viaversion.viafabricplus.screen.VFPListEntry;
import com.viaversion.viafabricplus.screen.VFPScreen;
import com.viaversion.viafabricplus.screen.impl.realms.AcceptInvitationCodeScreen;
import com.viaversion.viafabricplus.util.ConnectionUtil;
import dev.kastle.netty.channel.nethernet.config.NetherNetAddress;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.raphimc.minecraftauth.MinecraftAuth;
import net.raphimc.minecraftauth.bedrock.BedrockAuthManager;
import net.raphimc.minecraftauth.extra.realms.model.RealmsJoinInformation;
import net.raphimc.minecraftauth.extra.realms.model.RealmsServer;
import net.raphimc.minecraftauth.extra.realms.service.impl.BedrockRealmsService;
import net.raphimc.viabedrock.api.BedrockProtocolVersion;
import org.apache.logging.log4j.Level;

public final class BedrockRealmsScreen
extends VFPScreen {
    public static final BedrockRealmsScreen INSTANCE = new BedrockRealmsScreen();
    private BedrockRealmsService service;
    private List<RealmsServer> realmsServers;
    private SlotList slotList;
    private class_4185 joinButton;
    private class_4185 leaveButton;

    public BedrockRealmsScreen() {
        super((class_2561)class_2561.method_43471((String)"screen.viafabricplus.bedrock_realms"), true);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (this.realmsServers != null) {
            this.createView();
            return;
        }
        this.setupSubtitle((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.availability_check"));
        class_156.method_55473().execute(this::loadRealms);
    }

    private void loadRealms() {
        BedrockAuthManager account = SaveManager.INSTANCE.getAccountsSave().getBedrockAccount();
        if (account == null) {
            this.setupSubtitle((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.warning"));
            return;
        }
        this.service = new BedrockRealmsService(MinecraftAuth.createHttpClient(), "1.21.130", account.getRealmsXstsToken());
        ((CompletableFuture)this.service.isCompatibleAsync().thenAccept(state -> {
            if (state.booleanValue()) {
                ((CompletableFuture)this.service.getWorldsAsync().thenAccept(realmsServers -> {
                    this.realmsServers = realmsServers;
                    this.createView();
                })).exceptionally(throwable -> this.error("Failed to load realm worlds", (Throwable)throwable));
            } else {
                this.setupSubtitle((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.unavailable"));
            }
        })).exceptionally(throwable -> this.error("Failed to check realms availability", (Throwable)throwable));
    }

    private Void error(String message, Throwable throwable) {
        this.setupSubtitle((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.error"));
        ViaFabricPlusImpl.INSTANCE.getLogger().log(Level.ERROR, message, throwable);
        return null;
    }

    private void createView() {
        if (!this.realmsServers.isEmpty()) {
            this.setupDefaultSubtitle();
        } else {
            this.setupSubtitle((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.no_worlds"));
        }
        Objects.requireNonNull(this.field_22793);
        Objects.requireNonNull(this.field_22793);
        this.slotList = new SlotList(this, this.field_22787, this.field_22789, this.field_22790, 6 + (9 + 2) * 3, 30, (9 + 2) * 4);
        this.method_37063((class_364)this.slotList);
        this.addRefreshButton(() -> {
            this.realmsServers = null;
        });
        int slotWidth = 356;
        int xPos = this.field_22789 / 2 - 178;
        this.joinButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.join"), button -> {
            SlotEntry entry = (SlotEntry)this.slotList.method_25336();
            if (entry.realmsServer.isExpired()) {
                this.setupSubtitle((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.expired"));
                return;
            }
            if (!entry.realmsServer.isCompatible()) {
                this.setupSubtitle((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.incompatible"));
                return;
            }
            try {
                RealmsJoinInformation server = this.service.joinWorld(entry.realmsServer);
                if (server.getNetworkProtocol().equalsIgnoreCase("DEFAULT")) {
                    ConnectionUtil.connect(server.getAddress(), BedrockProtocolVersion.bedrockLatest);
                } else if (server.getNetworkProtocol().equalsIgnoreCase("NETHERNET")) {
                    ConnectionUtil.connectNetherNet(new NetherNetAddress(server.getAddress()));
                } else {
                    this.setupSubtitle((class_2561)class_2561.method_43469((String)"bedrock_realms.viafabricplus.unsupported_protocol", (Object[])new Object[]{server.getNetworkProtocol()}));
                }
            }
            catch (Throwable throwable) {
                this.error("Failed to join realm", throwable);
            }
        }).method_46433(xPos, this.field_22790 - 20 - 5).method_46437(115, 20).method_46431();
        this.method_37063((class_364)this.joinButton);
        this.joinButton.field_22763 = false;
        this.leaveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.leave"), button -> {
            SlotEntry entry = (SlotEntry)this.slotList.method_25336();
            ((CompletableFuture)this.service.leaveInvitedRealmAsync(entry.realmsServer).thenAccept(unused -> {
                this.realmsServers.remove(entry.realmsServer);
                INSTANCE.open(this.prevScreen);
            })).exceptionally(throwable -> this.error("Failed to leave realm", (Throwable)throwable));
        }).method_46433(xPos += 120, this.field_22790 - 20 - 5).method_46437(115, 20).method_46431();
        this.method_37063((class_364)this.leaveButton);
        this.leaveButton.field_22763 = false;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"bedrock_realms.viafabricplus.invite"), button -> {
            AcceptInvitationCodeScreen screen = new AcceptInvitationCodeScreen(code -> ((CompletableFuture)this.service.acceptInviteAsync(code).thenAccept(world -> {
                this.realmsServers.add((RealmsServer)world);
                INSTANCE.open(this);
            })).exceptionally(throwable -> this.error("Failed to accept invite", (Throwable)throwable)));
            screen.open(this);
        }).method_46433(xPos += 120, this.field_22790 - 20 - 5).method_46437(115, 20).method_46431());
    }

    public void method_25393() {
        super.method_25393();
        if (this.slotList != null && this.joinButton != null && this.leaveButton != null) {
            this.joinButton.field_22763 = this.slotList.method_25336() instanceof SlotEntry;
            this.leaveButton.field_22763 = this.slotList.method_25336() instanceof SlotEntry;
        }
    }

    @Override
    protected boolean subtitleCentered() {
        return this.realmsServers == null;
    }

    public final class SlotList
    extends VFPList {
        private static double scrollAmount;

        public SlotList(BedrockRealmsScreen this$0, class_310 minecraftClient, int width, int height, int top, int bottom, int entryHeight) {
            super(minecraftClient, width, height, top, bottom, entryHeight);
            for (RealmsServer realmsServer : this$0.realmsServers) {
                this.method_25321((class_350.class_351)new SlotEntry(this$0, this, realmsServer));
            }
            this.initScrollY(scrollAmount);
        }

        @Override
        protected void updateSlotAmount(double amount) {
            scrollAmount = amount;
        }

        public int method_25322() {
            return super.method_25322() + 140;
        }
    }

    public final class SlotEntry
    extends VFPListEntry {
        private final SlotList slotList;
        private final RealmsServer realmsServer;

        public SlotEntry(BedrockRealmsScreen this$0, SlotList slotList, RealmsServer realmsServer) {
            this.slotList = slotList;
            this.realmsServer = realmsServer;
        }

        public class_2561 method_37006() {
            return class_2561.method_30163((String)this.realmsServer.getName());
        }

        @Override
        public void mappedRender(class_332 context, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            String worldName;
            class_327 textRenderer = class_310.method_1551().field_1772;
            Object name = "";
            String ownerName = this.realmsServer.getOwnerName();
            if (ownerName != null && !ownerName.trim().isEmpty()) {
                name = (String)name + ownerName + " - ";
            }
            if ((worldName = this.realmsServer.getName()) != null && !worldName.trim().isEmpty()) {
                name = (String)name + worldName;
            }
            name = (String)name + " (" + this.realmsServer.getState() + ")";
            context.method_25303(textRenderer, (String)name, 3, 3, this.slotList.method_25336() == this ? Color.ORANGE.getRGB() : -1);
            Object version = this.realmsServer.getWorldType();
            String activeVersion = this.realmsServer.getActiveVersion();
            if (activeVersion != null && !activeVersion.trim().isEmpty()) {
                version = (String)version + " - " + activeVersion;
            }
            context.method_25303(textRenderer, (String)version, entryWidth - textRenderer.method_1727((String)version) - 3, 3, -1);
            String motd = this.realmsServer.getMotd();
            if (motd != null) {
                class_2561 class_25612 = class_2561.method_30163((String)motd);
                Objects.requireNonNull(textRenderer);
                this.renderScrollableText(class_25612, entryHeight - 9 - 3, 0);
            }
        }
    }
}

