/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.protocoltranslator.impl.platform;

import com.viaversion.viafabricplus.ViaFabricPlusImpl;
import com.viaversion.viafabricplus.protocoltranslator.ProtocolTranslator;
import com.viaversion.viafabricplus.protocoltranslator.impl.viaversion.ViaFabricPlusConfig;
import com.viaversion.viafabricplus.protocoltranslator.protocol.ViaFabricPlusProtocol;
import com.viaversion.viafabricplus.protocoltranslator.util.JLoggerToSLF4J;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.configuration.AbstractViaConfig;
import com.viaversion.viaversion.libs.gson.JsonArray;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.platform.UserConnectionViaVersionPlatform;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_310;
import org.slf4j.LoggerFactory;

public final class ViaFabricPlusViaVersionPlatform
extends UserConnectionViaVersionPlatform {
    public ViaFabricPlusViaVersionPlatform(File dataFolder) {
        super(dataFolder);
    }

    public Logger createLogger(String name) {
        return new JLoggerToSLF4J(LoggerFactory.getLogger((String)name));
    }

    public String getPlatformName() {
        return "ViaFabricPlus";
    }

    public String getPlatformVersion() {
        return ViaFabricPlusImpl.INSTANCE.getVersion();
    }

    protected AbstractViaConfig createConfig() {
        return new ViaFabricPlusConfig(new File(this.getDataFolder(), "viaversion.yml"), this.getLogger());
    }

    public void sendCustomPayload(UserConnection connection, String channel, byte[] message) {
        PacketWrapper customPayload = PacketWrapper.create((PacketType)ViaFabricPlusProtocol.INSTANCE.getCustomPayloadPacketType(), (UserConnection)connection);
        customPayload.write(Types.STRING, (Object)channel);
        customPayload.write(Types.REMAINING_BYTES, (Object)message);
        customPayload.scheduleSendToServer(ViaFabricPlusProtocol.class);
    }

    public void sendCustomPayloadToClient(UserConnection connection, String channel, byte[] message) {
        PacketWrapper customPayload = PacketWrapper.create((PacketType)ViaFabricPlusProtocol.INSTANCE.getClientboundCustomPayloadPacketType(), (UserConnection)connection);
        customPayload.write(Types.STRING, (Object)channel);
        customPayload.write(Types.REMAINING_BYTES, (Object)message);
        customPayload.scheduleSend(ViaFabricPlusProtocol.class);
    }

    public JsonObject getDump() {
        JsonObject platformDump = new JsonObject();
        platformDump.addProperty("impl_version", ViaFabricPlusImpl.INSTANCE.getImplVersion());
        platformDump.addProperty("native_version", ProtocolTranslator.NATIVE_VERSION.toString());
        platformDump.addProperty("target_version", ProtocolTranslator.getTargetVersion().toString());
        platformDump.addProperty("in_world", Boolean.valueOf(class_310.method_1551().field_1687 != null));
        Collection allMods = FabricLoader.getInstance().getAllMods();
        JsonArray mods = new JsonArray(allMods.size());
        for (ModContainer modContainer : allMods) {
            ModMetadata metadata = modContainer.getMetadata();
            JsonObject mod = new JsonObject();
            mod.addProperty("id", metadata.getId());
            mod.addProperty("name", metadata.getName());
            mod.addProperty("version", metadata.getVersion().getFriendlyString());
            JsonArray authors = new JsonArray(metadata.getAuthors().size());
            for (Person person : metadata.getAuthors()) {
                JsonObject info = new JsonObject();
                Map contactMap = person.getContact().asMap();
                if (!contactMap.isEmpty()) {
                    JsonObject contact = new JsonObject();
                    contactMap.forEach((arg_0, arg_1) -> ((JsonObject)contact).addProperty(arg_0, arg_1));
                    info.add("contact", (JsonElement)contact);
                }
                info.addProperty("name", person.getName());
                authors.add((JsonElement)info);
            }
            mod.add("authors", (JsonElement)authors);
            mods.add((JsonElement)mod);
        }
        platformDump.add("mods", (JsonElement)mods);
        return platformDump;
    }
}

