/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.protocoltranslator;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.viaversion.viaaprilfools.ViaAprilFoolsPlatformImpl;
import com.viaversion.viabackwards.ViaBackwardsPlatformImpl;
import com.viaversion.viafabricplus.api.events.ChangeProtocolVersionCallback;
import com.viaversion.viafabricplus.base.Events;
import com.viaversion.viafabricplus.injection.access.base.IConnection;
import com.viaversion.viafabricplus.protocoltranslator.impl.command.ViaFabricPlusCommandHandler;
import com.viaversion.viafabricplus.protocoltranslator.impl.platform.ViaFabricPlusViaLegacyPlatform;
import com.viaversion.viafabricplus.protocoltranslator.impl.platform.ViaFabricPlusViaVersionPlatform;
import com.viaversion.viafabricplus.protocoltranslator.impl.viaversion.ViaFabricPlusPlatformLoader;
import com.viaversion.viafabricplus.protocoltranslator.netty.NoReadFlowControlHandler;
import com.viaversion.viafabricplus.protocoltranslator.netty.ViaFabricPlusDecoder;
import com.viaversion.viafabricplus.protocoltranslator.protocol.ViaFabricPlusProtocol;
import com.viaversion.viafabricplus.protocoltranslator.util.NoPacketSendChannel;
import com.viaversion.viaversion.ViaManagerImpl;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.ProtocolInfo;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.platform.ViaInjector;
import com.viaversion.viaversion.api.platform.ViaPlatform;
import com.viaversion.viaversion.api.platform.ViaPlatformLoader;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.ProtocolPathEntry;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.api.protocol.version.VersionType;
import com.viaversion.viaversion.commands.ViaCommandHandler;
import com.viaversion.viaversion.connection.UserConnectionImpl;
import com.viaversion.viaversion.platform.NoopInjector;
import com.viaversion.viaversion.platform.ViaChannelInitializer;
import com.viaversion.viaversion.platform.ViaEncodeHandler;
import com.viaversion.viaversion.protocol.ProtocolPipelineImpl;
import dev.kastle.netty.channel.nethernet.config.NetherChannelOption;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.util.AttributeKey;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.lenni0451.reflect.stream.RStream;
import net.lenni0451.reflect.stream.field.FieldWrapper;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2535;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.raphimc.viabedrock.ViaBedrockPlatformImpl;
import net.raphimc.viabedrock.api.BedrockProtocolVersion;
import net.raphimc.viabedrock.netty.BatchLengthCodec;
import net.raphimc.viabedrock.netty.DisconnectHandler;
import net.raphimc.viabedrock.netty.PacketCodec;
import net.raphimc.viabedrock.netty.raknet.MessageCodec;
import net.raphimc.vialegacy.api.LegacyProtocolVersion;
import net.raphimc.vialegacy.netty.PreNettyLengthPrepender;
import net.raphimc.vialegacy.netty.PreNettyLengthRemover;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;

public final class ProtocolTranslator {
    public static final AttributeKey<class_2535> CLIENT_CONNECTION_ATTRIBUTE_KEY = AttributeKey.newInstance((String)"viafabricplus-clientconnection");
    public static final AttributeKey<ProtocolVersion> TARGET_VERSION_ATTRIBUTE_KEY = AttributeKey.newInstance((String)"viafabricplus-targetversion");
    public static final ProtocolVersion NATIVE_VERSION = ProtocolVersion.v1_21_11;
    public static final String VIA_FLOW_CONTROL = "via-flow-control";
    public static final ProtocolVersion AUTO_DETECT_PROTOCOL = new ProtocolVersion(VersionType.SPECIAL, -2, -1, "Auto Detect (1.7+ servers)", null){

        protected Comparator<ProtocolVersion> customComparator() {
            return (o1, o2) -> {
                if (o1 == AUTO_DETECT_PROTOCOL) {
                    return 1;
                }
                if (o2 == AUTO_DETECT_PROTOCOL) {
                    return -1;
                }
                return 0;
            };
        }

        public boolean isKnown() {
            return false;
        }
    };
    private static ProtocolVersion targetVersion = NATIVE_VERSION;
    private static ProtocolVersion previousVersion = null;

    public static void injectViaPipeline(class_2535 connection, Channel channel) {
        IConnection mixinClientConnection = (IConnection)connection;
        ProtocolVersion serverVersion = mixinClientConnection.viaFabricPlus$getTargetVersion();
        channel.attr(CLIENT_CONNECTION_ATTRIBUTE_KEY).set((Object)connection);
        channel.attr(TARGET_VERSION_ATTRIBUTE_KEY).set((Object)serverVersion);
        if (serverVersion.equals((Object)BedrockProtocolVersion.bedrockLatest)) {
            ChannelConfig config = channel.config();
            config.setOption(RakChannelOption.RAK_PROTOCOL_VERSION, (Object)11);
            config.setOption(RakChannelOption.RAK_COMPATIBILITY_MODE, (Object)true);
            config.setOption(RakChannelOption.RAK_CLIENT_INTERNAL_ADDRESSES, (Object)20);
            config.setOption(RakChannelOption.RAK_TIME_BETWEEN_SEND_CONNECTION_ATTEMPTS_MS, (Object)500);
            config.setOption(RakChannelOption.RAK_CONNECT_TIMEOUT, (Object)((Integer)config.getOption(ChannelOption.CONNECT_TIMEOUT_MILLIS)).longValue());
            config.setOption(RakChannelOption.RAK_SESSION_TIMEOUT, (Object)30000L);
            config.setOption(RakChannelOption.RAK_GUID, (Object)ThreadLocalRandom.current().nextLong());
            config.setOption(NetherChannelOption.NETHER_CLIENT_HANDSHAKE_TIMEOUT_MS, (Object)((Integer)config.getOption(ChannelOption.CONNECT_TIMEOUT_MILLIS)));
            config.setOption(NetherChannelOption.NETHER_CLIENT_MAX_HANDSHAKE_ATTEMPTS, (Object)1);
        }
        UserConnection user = ViaChannelInitializer.createUserConnection((Channel)channel, (boolean)true);
        mixinClientConnection.viaFabricPlus$setUserConnection(user);
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addBefore("inbound_config", "via-decoder", (ChannelHandler)new ViaFabricPlusDecoder(user));
        pipeline.addBefore("encoder", "via-encoder", (ChannelHandler)new ViaEncodeHandler(user));
        if (serverVersion.olderThanOrEqualTo(LegacyProtocolVersion.r1_6_4)) {
            pipeline.addBefore("splitter", "vialegacy-pre-netty-length-prepender", (ChannelHandler)new PreNettyLengthPrepender(user));
            pipeline.addBefore("prepender", "vialegacy-pre-netty-length-remover", (ChannelHandler)new PreNettyLengthRemover(user));
        } else if (serverVersion.equals((Object)BedrockProtocolVersion.bedrockLatest)) {
            pipeline.addBefore("splitter", "viabedrock-disconnect-handler", (ChannelHandler)new DisconnectHandler());
            pipeline.addBefore("splitter", "viabedrock-raknet-message-codec", (ChannelHandler)new MessageCodec());
            pipeline.replace("splitter", "splitter", (ChannelHandler)new BatchLengthCodec());
            pipeline.remove("prepender");
            pipeline.addBefore("via-decoder", "viabedrock-packet-codec", (ChannelHandler)new PacketCodec());
        }
        pipeline.addAfter("via-decoder", VIA_FLOW_CONTROL, (ChannelHandler)new NoReadFlowControlHandler());
        user.getProtocolInfo().getPipeline().add((Protocol)ViaFabricPlusProtocol.INSTANCE);
    }

    public static void reorderPipeline(ChannelPipeline pipeline) {
        int decoderIndex = pipeline.names().indexOf("decompress");
        if (decoderIndex == -1) {
            return;
        }
        if (decoderIndex > pipeline.names().indexOf("via-decoder")) {
            ChannelHandler decoderHandler = pipeline.get("via-decoder");
            ChannelHandler encoderHandler = pipeline.get("via-encoder");
            pipeline.remove(decoderHandler);
            pipeline.remove(encoderHandler);
            pipeline.addAfter("decompress", "via-decoder", decoderHandler);
            pipeline.addAfter("compress", "via-encoder", encoderHandler);
        }
    }

    public static ProtocolVersion getTargetVersion() {
        return targetVersion;
    }

    public static ProtocolVersion getTargetVersion(Channel channel) {
        if (!channel.hasAttr(TARGET_VERSION_ATTRIBUTE_KEY)) {
            throw new IllegalStateException("ViaFabricPlus has not injected into that channel yet!");
        }
        return (ProtocolVersion)channel.attr(TARGET_VERSION_ATTRIBUTE_KEY).get();
    }

    public static void setTargetVersion(ProtocolVersion newVersion) {
        ProtocolTranslator.setTargetVersion(newVersion, false);
    }

    public static void setTargetVersion(ProtocolVersion newVersion, boolean revertOnDisconnect) {
        if (newVersion == null) {
            return;
        }
        ProtocolVersion oldVersion = targetVersion;
        targetVersion = newVersion;
        if (oldVersion != newVersion) {
            if (revertOnDisconnect) {
                previousVersion = oldVersion;
            }
            ((ChangeProtocolVersionCallback)Events.CHANGE_PROTOCOL_VERSION.invoker()).onChangeProtocolVersion(oldVersion, targetVersion);
        }
    }

    public static void injectPreviousVersionReset(Channel channel) {
        if (previousVersion == null) {
            return;
        }
        channel.closeFuture().addListener(future -> {
            ProtocolTranslator.setTargetVersion(previousVersion);
            previousVersion = null;
        });
    }

    public static UserConnection createDummyUserConnection(ProtocolVersion clientVersion, ProtocolVersion serverVersion) {
        UserConnectionImpl user = new UserConnectionImpl((Channel)NoPacketSendChannel.INSTANCE, true);
        ProtocolPipelineImpl pipeline = new ProtocolPipelineImpl((UserConnection)user);
        List path = Via.getManager().getProtocolManager().getProtocolPath(clientVersion, serverVersion);
        if (path != null) {
            for (ProtocolPathEntry pair : path) {
                pipeline.add(pair.protocol());
                pair.protocol().init((UserConnection)user);
            }
        }
        ProtocolInfo info = user.getProtocolInfo();
        info.setState(State.PLAY);
        info.setProtocolVersion(clientVersion);
        info.setServerProtocolVersion(serverVersion);
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null) {
            GameProfile profile = mc.field_1724.method_7334();
            info.setUsername(profile.name());
            info.setUuid(profile.id());
        }
        return user;
    }

    public static UserConnection getPlayNetworkUserConnection() {
        class_634 handler = class_310.method_1551().method_1562();
        if (handler == null) {
            return null;
        }
        return ((IConnection)handler.method_48296()).viaFabricPlus$getUserConnection();
    }

    private static void changeBedrockProtocolName() {
        ProtocolVersion bedrockLatest = (ProtocolVersion)RStream.of(BedrockProtocolVersion.class).fields().by("bedrockLatest").get();
        FieldWrapper name = RStream.of((Object)bedrockLatest).withSuper().fields().by("name");
        name.set((Object)(String.valueOf(name.get()) + " (Work in progress)"));
    }

    public static CompletableFuture<Void> init(Path path) {
        if (class_155.method_31372() != NATIVE_VERSION.getOriginalVersion()) {
            throw new IllegalStateException("Native version is not the same as the current version");
        }
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            ViaFabricPlusCommandHandler commandHandler = (ViaFabricPlusCommandHandler)Via.getManager().getCommandHandler();
            RequiredArgumentBuilder executor = ((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).executes(commandHandler::execute)).suggests(commandHandler::suggestion);
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"viafabricplus").then((ArgumentBuilder)executor)).executes(commandHandler::execute));
        });
        return CompletableFuture.runAsync(() -> {
            ViaManagerImpl.initAndLoad((ViaPlatform)new ViaFabricPlusViaVersionPlatform(path.toFile()), (ViaInjector)new NoopInjector(), (ViaCommandHandler)new ViaFabricPlusCommandHandler(), (ViaPlatformLoader)new ViaFabricPlusPlatformLoader(), (Runnable[])new Runnable[]{() -> {
                new ViaBackwardsPlatformImpl();
                new ViaFabricPlusViaLegacyPlatform();
                new ViaAprilFoolsPlatformImpl();
                new ViaBedrockPlatformImpl();
            }});
            ProtocolVersion.register((ProtocolVersion)AUTO_DETECT_PROTOCOL);
            ProtocolTranslator.changeBedrockProtocolName();
            ViaFabricPlusProtocol.INSTANCE.initialize();
        }, (Executor)class_156.method_18349());
    }
}

