/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.features.block.connections;

import com.viaversion.viafabricplus.features.block.connections.CrossCollisionStateHandler;
import com.viaversion.viafabricplus.features.block.connections.DoorStateHandler;
import com.viaversion.viafabricplus.features.block.connections.DoubleChestStateHandler;
import com.viaversion.viafabricplus.features.block.connections.FenceGateStateHandler;
import com.viaversion.viafabricplus.features.block.connections.FireStateHandler;
import com.viaversion.viafabricplus.features.block.connections.IBlockStateHandler;
import com.viaversion.viafabricplus.features.block.connections.PipeStateHandler;
import com.viaversion.viafabricplus.features.block.connections.RedStoneRepeaterStateHandler;
import com.viaversion.viafabricplus.features.block.connections.RedStoneStateHandler;
import com.viaversion.viafabricplus.features.block.connections.SnowyGrassStateHandler;
import com.viaversion.viafabricplus.features.block.connections.StairsStateHandler;
import com.viaversion.viafabricplus.features.block.connections.WallStateHandler;
import com.viaversion.viafabricplus.protocoltranslator.ProtocolTranslator;
import com.viaversion.viafabricplus.settings.impl.GeneralSettings;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2358;
import net.minecraft.class_2389;
import net.minecraft.class_2429;
import net.minecraft.class_2457;
import net.minecraft.class_2462;
import net.minecraft.class_2490;
import net.minecraft.class_2493;
import net.minecraft.class_2510;
import net.minecraft.class_2544;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_3481;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.raphimc.viabedrock.api.BedrockProtocolVersion;
import org.jspecify.annotations.Nullable;

public final class BlockConnectionsEmulation1_12_2 {
    private static final int UPDATE_FLAGS = 18;
    private static final Object2ObjectOpenHashMap<Class<? extends class_2248>, IBlockStateHandler> connectionHandlers = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<Class<? extends class_2248>, IBlockStateHandler> lookupCache = new Object2ObjectOpenHashMap();

    public static void init() {
        connectionHandlers.put(class_2323.class, (Object)new DoorStateHandler());
        connectionHandlers.put(class_2281.class, (Object)new DoubleChestStateHandler());
        connectionHandlers.put(class_2349.class, (Object)new FenceGateStateHandler());
        connectionHandlers.put(class_2354.class, (Object)new CrossCollisionStateHandler(state -> state.method_26164(class_3481.field_16584) || state.method_26164(class_3481.field_25147) || state.method_26204() instanceof class_2490));
        connectionHandlers.put(class_2358.class, (Object)new FireStateHandler());
        connectionHandlers.put(class_2389.class, (Object)new CrossCollisionStateHandler(state -> state.method_26204() instanceof class_2389));
        connectionHandlers.put(class_2429.class, (Object)new PipeStateHandler());
        connectionHandlers.put(class_2462.class, (Object)new RedStoneRepeaterStateHandler());
        connectionHandlers.put(class_2457.class, (Object)new RedStoneStateHandler());
        connectionHandlers.put(class_2493.class, (Object)new SnowyGrassStateHandler());
        connectionHandlers.put(class_2510.class, (Object)new StairsStateHandler());
        connectionHandlers.put(class_2544.class, (Object)new WallStateHandler());
    }

    public static void updateChunkConnections(class_4538 levelReader, int chunkX, int chunkZ) {
        if (!BlockConnectionsEmulation1_12_2.isApplicable() || !levelReader.method_8393(chunkX, chunkZ)) {
            return;
        }
        class_2791 chunkAccess = levelReader.method_8392(chunkX, chunkZ);
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        for (int sectionY = chunkAccess.method_32891(); sectionY < chunkAccess.method_31597(); ++sectionY) {
            class_2826 section = chunkAccess.method_38259(chunkAccess.method_31603(sectionY));
            if (section.method_38292()) continue;
            int baseY = class_4076.method_18688((int)sectionY);
            for (int x = -1; x <= 16; ++x) {
                boolean insideX = x >= 0 && x < 16;
                for (int y = baseY; y < baseY + 16; ++y) {
                    for (int z = -1; z <= 16; ++z) {
                        class_2680 newState;
                        IBlockStateHandler connectionHandler;
                        class_2680 blockState;
                        blockPos.method_10103(class_4076.method_18688((int)chunkX) + x, y, class_4076.method_18688((int)chunkZ) + z);
                        if (!levelReader.method_8393(class_4076.method_18675((int)blockPos.method_10263()), class_4076.method_18675((int)blockPos.method_10260())) || (blockState = levelReader.method_8320((class_2338)blockPos)).method_26215() || (connectionHandler = BlockConnectionsEmulation1_12_2.getConnectionHandler(blockState.method_26204().getClass())) == null || (newState = connectionHandler.connect(blockState, levelReader, (class_2338)blockPos)) == blockState || !insideX || z < 0 || z >= 16) continue;
                        chunkAccess.method_12010((class_2338)blockPos, newState, 18);
                    }
                }
            }
        }
    }

    public static void updateChunkNeighborConnections(class_4538 levelReader, int chunkX, int chunkZ) {
        BlockConnectionsEmulation1_12_2.updateChunkConnections(levelReader, chunkX, chunkZ);
        BlockConnectionsEmulation1_12_2.updateChunkConnections(levelReader, chunkX + 1, chunkZ);
        BlockConnectionsEmulation1_12_2.updateChunkConnections(levelReader, chunkX - 1, chunkZ);
        BlockConnectionsEmulation1_12_2.updateChunkConnections(levelReader, chunkX, chunkZ + 1);
        BlockConnectionsEmulation1_12_2.updateChunkConnections(levelReader, chunkX, chunkZ - 1);
    }

    public static void updateChunkNeighborConnections(class_4538 levelReader, class_2338 blockPos) {
        BlockConnectionsEmulation1_12_2.updateChunkNeighborConnections(levelReader, class_4076.method_18675((int)blockPos.method_10263()), class_4076.method_18675((int)blockPos.method_10260()));
    }

    private static @Nullable IBlockStateHandler getConnectionHandler(Class<? extends class_2248> blockClass) {
        return (IBlockStateHandler)lookupCache.computeIfAbsent(blockClass, clazz -> {
            for (Class current = (Class)clazz; current != class_2248.class && current != null; current = current.getSuperclass()) {
                IBlockStateHandler handler = (IBlockStateHandler)connectionHandlers.get((Object)current);
                if (handler == null) continue;
                return handler;
            }
            return null;
        });
    }

    private static boolean isApplicable() {
        if (((Boolean)GeneralSettings.INSTANCE.experimentalBlockConnections.getValue()).booleanValue()) {
            return ProtocolTranslator.getTargetVersion().olderThanOrEqualTo(ProtocolVersion.v1_12_2) || ProtocolTranslator.getTargetVersion().equals((Object)BedrockProtocolVersion.bedrockLatest);
        }
        return false;
    }
}

