/*
 * Decompiled with CFR 0.152.
 */
package com.soradgaming.simplehudenhanced.utli;

import java.util.Arrays;
import net.minecraft.class_2596;
import net.minecraft.class_2761;
import net.minecraft.class_310;

public class TpsTracker {
    public static TpsTracker INSTANCE = new TpsTracker();
    private final float[] tickRates = new float[20];
    private int nextIndex = 0;
    private long timeLastTimeUpdate = -1L;
    private long timeGameJoined;

    public void onPacketReceive(class_2596<?> packet) {
        if (packet instanceof class_2761) {
            long now = System.currentTimeMillis();
            float timeElapsed = (float)(now - this.timeLastTimeUpdate) / 1000.0f;
            this.tickRates[this.nextIndex] = this.clamp(20.0f / timeElapsed);
            this.nextIndex = (this.nextIndex + 1) % this.tickRates.length;
            this.timeLastTimeUpdate = now;
        }
    }

    public void onGameJoined() {
        Arrays.fill(this.tickRates, 0.0f);
        this.nextIndex = 0;
        this.timeGameJoined = this.timeLastTimeUpdate = System.currentTimeMillis();
    }

    public float getTickRate() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null) {
            return 0.0f;
        }
        if (System.currentTimeMillis() - this.timeGameJoined < 4000L) {
            return 20.0f;
        }
        int numTicks = 0;
        float sumTickRates = 0.0f;
        for (float tickRate : this.tickRates) {
            if (!(tickRate > 0.0f)) continue;
            sumTickRates += tickRate;
            ++numTicks;
        }
        return sumTickRates / (float)numTicks;
    }

    private float clamp(float value) {
        if (value < 0.0f) {
            return 0.0f;
        }
        return Math.min(value, 20.0f);
    }
}

