/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.minecraft;

import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.seibel.distanthorizons.api.enums.config.EDhApiLodShading;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.core.util.math.Vec3f;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.ILightMapWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.AbstractOptifineAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.awt.Color;
import java.util.concurrent.ConcurrentHashMap;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.misc.LightMapWrapper;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.fog.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector4f;

public class MinecraftRenderWrapper
implements IMinecraftRenderWrapper {
    public static final MinecraftRenderWrapper INSTANCE = new MinecraftRenderWrapper();
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final Minecraft MC = Minecraft.getInstance();
    public ConcurrentHashMap<IDimensionTypeWrapper, LightMapWrapper> lightmapByDimensionType = new ConcurrentHashMap();
    public int finalLevelFrameBufferId = -1;
    public boolean colorTextureCastFailLogged = false;
    public boolean depthTextureCastFailLogged = false;
    private static FogRenderer mcFogRenderer = null;

    @Override
    public Vec3f getLookAtVector() {
        Camera camera = MinecraftRenderWrapper.MC.gameRenderer.getMainCamera();
        return new Vec3f(camera.forwardVector().x(), camera.forwardVector().y(), camera.forwardVector().z());
    }

    @Override
    public boolean playerHasBlindingEffect() {
        if (MinecraftRenderWrapper.MC.player == null) {
            return false;
        }
        if (MinecraftRenderWrapper.MC.player.getActiveEffectsMap() == null) {
            return false;
        }
        return MinecraftRenderWrapper.MC.player.getActiveEffectsMap().get(MobEffects.BLINDNESS) != null || MinecraftRenderWrapper.MC.player.getActiveEffectsMap().get(MobEffects.DARKNESS) != null;
    }

    @Override
    public Vec3d getCameraExactPosition() {
        Camera camera = MinecraftRenderWrapper.MC.gameRenderer.getMainCamera();
        Vec3 projectedView = camera.position();
        return new Vec3d(projectedView.x, projectedView.y, projectedView.z);
    }

    @Override
    public Color getFogColor(float partialTicks) {
        if (mcFogRenderer == null) {
            mcFogRenderer = new FogRenderer();
        }
        if (MinecraftRenderWrapper.MC.level == null) {
            return Color.white;
        }
        Vector4f colorValues = mcFogRenderer.setupFog(MinecraftRenderWrapper.MC.gameRenderer.getMainCamera(), MinecraftRenderWrapper.MC.options.getEffectiveRenderDistance(), (DeltaTracker)MinecraftRenderWrapper.MC.deltaTracker, MinecraftRenderWrapper.MC.gameRenderer.getDarkenWorldAmount(MinecraftRenderWrapper.MC.deltaTracker.getGameTimeDeltaPartialTick(true)), MinecraftRenderWrapper.MC.level);
        return new Color(Math.max(0.0f, Math.min(colorValues.x, 1.0f)), Math.max(0.0f, Math.min(colorValues.y, 1.0f)), Math.max(0.0f, Math.min(colorValues.z, 1.0f)), Math.max(0.0f, Math.min(colorValues.w, 1.0f)));
    }

    @Override
    public Color getSkyColor() {
        if (MinecraftRenderWrapper.MC.level.dimensionType().hasSkyLight()) {
            float frameTime = 0.0f;
            int argbColor = (Integer)MinecraftRenderWrapper.MC.level.environmentAttributes().getValue(EnvironmentAttributes.SKY_COLOR, BlockPos.ZERO);
            return new Color(ColorUtil.getRed(argbColor), ColorUtil.getGreen(argbColor), ColorUtil.getBlue(argbColor), 255);
        }
        return new Color(0, 0, 0);
    }

    @Override
    public double getFov(float partialTicks) {
        return MinecraftRenderWrapper.MC.gameRenderer.getFov(MinecraftRenderWrapper.MC.gameRenderer.getMainCamera(), partialTicks, true);
    }

    @Override
    public int getRenderDistance() {
        return MinecraftRenderWrapper.MC.options.getEffectiveRenderDistance();
    }

    protected RenderTarget getRenderTarget() {
        return MC.getMainRenderTarget();
    }

    @Override
    public boolean mcRendersToFrameBuffer() {
        return false;
    }

    @Override
    public boolean runningLegacyOpenGL() {
        return false;
    }

    @Override
    public int getTargetFramebuffer() {
        if (AbstractOptifineAccessor.optifinePresent()) {
            return this.finalLevelFrameBufferId;
        }
        return 0;
    }

    @Override
    public void clearTargetFrameBuffer() {
        this.finalLevelFrameBufferId = -1;
    }

    @Override
    public int getDepthTextureId() {
        try {
            GlTexture glTexture = (GlTexture)this.getRenderTarget().getDepthTexture();
            if (glTexture == null) {
                return 0;
            }
            return glTexture.glId();
        }
        catch (Exception e) {
            if (!this.depthTextureCastFailLogged) {
                this.depthTextureCastFailLogged = true;
                LOGGER.error("Unable to cast render Target depth texture to GlTexture. MC or a rendering mod may have changed the object type.", e);
            }
            return 0;
        }
    }

    @Override
    public int getColorTextureId() {
        try {
            GlTexture glTexture = (GlTexture)this.getRenderTarget().getColorTexture();
            if (glTexture == null) {
                return 0;
            }
            return glTexture.glId();
        }
        catch (Exception e) {
            if (!this.colorTextureCastFailLogged) {
                this.colorTextureCastFailLogged = true;
                LOGGER.error("Unable to cast render Target color texture to GlTexture. MC or a rendering mod may have changed the object type.", e);
            }
            return 0;
        }
    }

    @Override
    public int getTargetFramebufferViewportWidth() {
        return this.getRenderTarget().width;
    }

    @Override
    public int getTargetFramebufferViewportHeight() {
        return this.getRenderTarget().height;
    }

    @Override
    public ILightMapWrapper getLightmapWrapper(@NotNull ILevelWrapper level) {
        return this.lightmapByDimensionType.get(level.getDimensionType());
    }

    @Override
    public boolean isFogStateSpecial() {
        boolean isBlind = this.playerHasBlindingEffect();
        return MinecraftRenderWrapper.MC.gameRenderer.getMainCamera().getFluidInCamera() != FogType.NONE || isBlind;
    }

    public void updateLightmap(NativeImage lightPixels, IClientLevelWrapper level) {
        IDimensionTypeWrapper dimensionType = level.getDimensionType();
        LightMapWrapper wrapper = this.lightmapByDimensionType.computeIfAbsent(dimensionType, dimType -> new LightMapWrapper());
        wrapper.uploadLightmap(lightPixels);
    }

    public void setLightmapId(int tetxureId, IClientLevelWrapper level) {
        IDimensionTypeWrapper dimensionType = level.getDimensionType();
        LightMapWrapper wrapper = this.lightmapByDimensionType.computeIfAbsent(dimensionType, dimType -> new LightMapWrapper());
        wrapper.setLightmapId(tetxureId);
    }

    @Override
    public float getShade(EDhDirection lodDirection) {
        EDhApiLodShading lodShading = Config.Client.Advanced.Graphics.Quality.lodShading.get();
        switch (lodShading) {
            default: {
                if (MinecraftRenderWrapper.MC.level != null) {
                    Direction mcDir = McObjectConverter.Convert(lodDirection);
                    return MinecraftRenderWrapper.MC.level.getShade(mcDir, true);
                }
                return 0.0f;
            }
            case ENABLED: {
                switch (lodDirection) {
                    case DOWN: {
                        return 0.5f;
                    }
                    default: {
                        return 1.0f;
                    }
                    case NORTH: 
                    case SOUTH: {
                        return 0.8f;
                    }
                    case WEST: 
                    case EAST: 
                }
                return 0.6f;
            }
            case DISABLED: 
        }
        return 1.0f;
    }
}

