/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.simplemenu_common_forge.util;

import com.mojang.blaze3d.platform.IconSet;
import com.mojang.blaze3d.platform.NativeImage;
import com.natamus.collective_common_forge.functions.DataFunctions;
import com.natamus.simplemenu_common_forge.config.ConfigHandler;
import com.natamus.simplemenu_common_forge.data.Constants;
import com.natamus.simplemenu_common_forge.data.Variables;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class Util {
    private static final String rootConfigPath = DataFunctions.getConfigDirectory() + File.separator + "simplemenu";
    private static final String backgroundPath = rootConfigPath + File.separator + "background";
    private static final String iconPath = rootConfigPath + File.separator + "icon";
    private static final String logoPath = rootConfigPath + File.separator + "logo";
    private static final File rootConfigDir = new File(rootConfigPath);
    private static final File backgroundDir = new File(backgroundPath);
    private static final File iconDir = new File(iconPath);
    private static final File logoDir = new File(logoPath);

    public static void init() {
        Constants.logger.info("[Simple Menu] Initiating.");
        if (!rootConfigDir.isDirectory()) {
            rootConfigDir.mkdirs();
        }
        if (!backgroundDir.isDirectory()) {
            backgroundDir.mkdirs();
        }
        if (!iconDir.isDirectory()) {
            iconDir.mkdirs();
        }
        if (!logoDir.isDirectory()) {
            logoDir.mkdirs();
        }
    }

    public static void initTextureData() throws IOException {
        String backgroundFilePath;
        File backgroundFile;
        String logoEditionFilePath;
        File logoEditionFile;
        Constants.logger.info("[Simple Menu] Loading texture data.");
        String logoFilePath = logoPath + File.separator + "logo.png";
        File logoFile = new File(logoFilePath);
        if (!logoFile.exists()) {
            InputStream defaultLogoInputStream = Minecraft.getInstance().getResourceManager().open(Identifier.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/title/minecraft.png"));
            BufferedImage defaultLogoBufferedImage = ImageIO.read(defaultLogoInputStream);
            ImageIO.write((RenderedImage)defaultLogoBufferedImage, "png", logoFile);
            Constants.logger.warn("[Simple Menu] Copied the default Minecraft logo to: " + logoFilePath);
        }
        if (ConfigHandler.replaceMainMenuLogo) {
            Identifier logoIdentifier = Identifier.fromNamespaceAndPath((String)"simplemenu", (String)"logo");
            FileInputStream logoInputStream = new FileInputStream(logoFile);
            NativeImage logoNativeImage = NativeImage.read((InputStream)logoInputStream);
            DynamicTexture logoTexture = new DynamicTexture(() -> ((Identifier)logoIdentifier).toString(), logoNativeImage);
            Minecraft.getInstance().getTextureManager().register(logoIdentifier, (AbstractTexture)logoTexture);
            logoNativeImage.close();
            Variables.loadedLogoImage = true;
        }
        if (!(logoEditionFile = new File(logoEditionFilePath = logoPath + File.separator + "edition.png")).exists()) {
            InputStream defaultEditionInputStream = Minecraft.getInstance().getResourceManager().open(Identifier.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/title/edition.png"));
            BufferedImage defaultEditionBufferedImage = ImageIO.read(defaultEditionInputStream);
            ImageIO.write((RenderedImage)defaultEditionBufferedImage, "png", logoEditionFile);
            Constants.logger.warn("[Simple Menu] Copied default Edition logo to: " + logoEditionFilePath);
        }
        if (ConfigHandler.replaceMainMenuEditionLogo) {
            Identifier editionIdentifier = Identifier.fromNamespaceAndPath((String)"simplemenu", (String)"edition");
            FileInputStream logoEditionInputStream = new FileInputStream(logoEditionFile);
            NativeImage logoEditionNativeImage = NativeImage.read((InputStream)logoEditionInputStream);
            DynamicTexture logoEditionTexture = new DynamicTexture(() -> ((Identifier)editionIdentifier).toString(), logoEditionNativeImage);
            Minecraft.getInstance().getTextureManager().register(Identifier.fromNamespaceAndPath((String)"simplemenu", (String)"edition"), (AbstractTexture)logoEditionTexture);
            logoEditionNativeImage.close();
            Variables.loadedLogoEditionImage = true;
        }
        if (!(backgroundFile = new File(backgroundFilePath = backgroundPath + File.separator + "background.png")).exists()) {
            BufferedImage emptyBackgroundImage = new BufferedImage(1920, 1080, 2);
            Graphics2D g2d = emptyBackgroundImage.createGraphics();
            g2d.setComposite(AlphaComposite.Clear);
            g2d.fillRect(0, 0, 1920, 1080);
            ImageIO.write((RenderedImage)emptyBackgroundImage, "png", backgroundFile);
            Constants.logger.warn("[Simple Menu] Generated a default background in: " + backgroundFilePath);
        }
        if (ConfigHandler.setCustomBackground) {
            Identifier backgroundIdentifier = Identifier.fromNamespaceAndPath((String)"simplemenu", (String)"background");
            FileInputStream backgroundInputStream = new FileInputStream(backgroundFile);
            NativeImage backgroundNativeImage = NativeImage.read((InputStream)backgroundInputStream);
            DynamicTexture backgroundTexture = new DynamicTexture(() -> ((Identifier)backgroundIdentifier).toString(), backgroundNativeImage);
            Minecraft.getInstance().getTextureManager().register(backgroundIdentifier, (AbstractTexture)backgroundTexture);
            backgroundNativeImage.close();
            Variables.loadedBackgroundImage = true;
        }
    }

    public static void openUrl(String url) {
        try {
            net.minecraft.util.Util.getPlatform().openUri(new URI(url));
        }
        catch (URISyntaxException ex) {
            Constants.logger.warn("[Simple Menu] Unable to open custom URL: " + url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processCustomWindowIcon() {
        try {
            File icon16x16 = new File(iconPath + File.separator + "/icon_16x16.png");
            File icon32x32 = new File(iconPath + File.separator + "/icon_32x32.png");
            if (!icon16x16.exists() || !icon32x32.exists()) {
                int n = 0;
                List defaultIconList = IconSet.RELEASE.getStandardIcons((PackResources)Minecraft.getInstance().getVanillaPackResources());
                for (IoSupplier defaultIcon : defaultIconList) {
                    InputStream iconInputStream = (InputStream)defaultIcon.get();
                    BufferedImage defaultIconBufferedImage = ImageIO.read(iconInputStream);
                    if (n == 0) {
                        ImageIO.write((RenderedImage)defaultIconBufferedImage, "png", icon16x16);
                    } else {
                        if (n != true) break;
                        ImageIO.write((RenderedImage)defaultIconBufferedImage, "png", icon32x32);
                    }
                    ++n;
                }
                Constants.logger.info("[Simple Menu] No custom icons found. Copied default to: " + iconPath);
                return;
            }
            if (!ConfigHandler.setCustomWindowIcon) {
                return;
            }
            BufferedImage bi16x16 = ImageIO.read(icon16x16);
            BufferedImage bi32x32 = ImageIO.read(icon32x32);
            if (bi16x16.getHeight() != 16 || bi16x16.getWidth() != 16 || bi32x32.getHeight() != 32 || bi32x32.getWidth() != 32) {
                Constants.logger.warn("[Simple Menu] Custom window icon enabled, but icon images have incorrect dimensions.");
                return;
            }
            List<IoSupplier> iconList = Arrays.asList(IoSupplier.create((Path)icon16x16.toPath()), IoSupplier.create((Path)icon32x32.toPath()));
            ArrayList<ByteBuffer> list1 = new ArrayList<ByteBuffer>(iconList.size());
            try (MemoryStack memorystack = MemoryStack.stackPush();){
                GLFWImage.Buffer buffer = GLFWImage.malloc((int)iconList.size(), (MemoryStack)memorystack);
                for (int i = 0; i < iconList.size(); ++i) {
                    try (NativeImage nativeimage = NativeImage.read((InputStream)((InputStream)iconList.get(i).get()));){
                        ByteBuffer bytebuffer = MemoryUtil.memAlloc((int)(nativeimage.getWidth() * nativeimage.getHeight() * 4));
                        list1.add(bytebuffer);
                        bytebuffer.asIntBuffer().put(nativeimage.getPixelsABGR());
                        buffer.position(i);
                        buffer.width(nativeimage.getWidth());
                        buffer.height(nativeimage.getHeight());
                        buffer.pixels(bytebuffer);
                        continue;
                    }
                }
                GLFW.glfwSetWindowIcon((long)Minecraft.getInstance().getWindow().handle(), (GLFWImage.Buffer)buffer);
            }
            finally {
                list1.forEach(MemoryUtil::memFree);
            }
            Variables.loadedIconImage = true;
        }
        catch (IOException ex) {
            Constants.logger.warn("[Simple Menu] IOException when setting the custom window icon.");
        }
    }
}

