/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.simplemenu_common_fabric.util;

import com.natamus.collective_common_fabric.functions.DataFunctions;
import com.natamus.simplemenu_common_fabric.config.ConfigHandler;
import com.natamus.simplemenu_common_fabric.data.Constants;
import com.natamus.simplemenu_common_fabric.data.Variables;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_7367;
import net.minecraft.class_8518;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class Util {
    private static final String rootConfigPath = DataFunctions.getConfigDirectory() + File.separator + "simplemenu";
    private static final String backgroundPath = rootConfigPath + File.separator + "background";
    private static final String iconPath = rootConfigPath + File.separator + "icon";
    private static final String logoPath = rootConfigPath + File.separator + "logo";
    private static final File rootConfigDir = new File(rootConfigPath);
    private static final File backgroundDir = new File(backgroundPath);
    private static final File iconDir = new File(iconPath);
    private static final File logoDir = new File(logoPath);

    public static void init() {
        Constants.logger.info("[Simple Menu] Initiating.");
        if (!rootConfigDir.isDirectory()) {
            rootConfigDir.mkdirs();
        }
        if (!backgroundDir.isDirectory()) {
            backgroundDir.mkdirs();
        }
        if (!iconDir.isDirectory()) {
            iconDir.mkdirs();
        }
        if (!logoDir.isDirectory()) {
            logoDir.mkdirs();
        }
    }

    public static void initTextureData() throws IOException {
        String backgroundFilePath;
        File backgroundFile;
        String logoEditionFilePath;
        File logoEditionFile;
        Constants.logger.info("[Simple Menu] Loading texture data.");
        String logoFilePath = logoPath + File.separator + "logo.png";
        File logoFile = new File(logoFilePath);
        if (!logoFile.exists()) {
            InputStream defaultLogoInputStream = class_310.method_1551().method_1478().open(class_2960.method_60655((String)"minecraft", (String)"textures/gui/title/minecraft.png"));
            BufferedImage defaultLogoBufferedImage = ImageIO.read(defaultLogoInputStream);
            ImageIO.write((RenderedImage)defaultLogoBufferedImage, "png", logoFile);
            Constants.logger.warn("[Simple Menu] Copied the default Minecraft logo to: " + logoFilePath);
        }
        if (ConfigHandler.replaceMainMenuLogo) {
            class_2960 logoIdentifier = class_2960.method_60655((String)"simplemenu", (String)"logo");
            FileInputStream logoInputStream = new FileInputStream(logoFile);
            class_1011 logoNativeImage = class_1011.method_4309((InputStream)logoInputStream);
            class_1043 logoTexture = new class_1043(() -> ((class_2960)logoIdentifier).toString(), logoNativeImage);
            class_310.method_1551().method_1531().method_4616(logoIdentifier, (class_1044)logoTexture);
            logoNativeImage.close();
            Variables.loadedLogoImage = true;
        }
        if (!(logoEditionFile = new File(logoEditionFilePath = logoPath + File.separator + "edition.png")).exists()) {
            InputStream defaultEditionInputStream = class_310.method_1551().method_1478().open(class_2960.method_60655((String)"minecraft", (String)"textures/gui/title/edition.png"));
            BufferedImage defaultEditionBufferedImage = ImageIO.read(defaultEditionInputStream);
            ImageIO.write((RenderedImage)defaultEditionBufferedImage, "png", logoEditionFile);
            Constants.logger.warn("[Simple Menu] Copied default Edition logo to: " + logoEditionFilePath);
        }
        if (ConfigHandler.replaceMainMenuEditionLogo) {
            class_2960 editionIdentifier = class_2960.method_60655((String)"simplemenu", (String)"edition");
            FileInputStream logoEditionInputStream = new FileInputStream(logoEditionFile);
            class_1011 logoEditionNativeImage = class_1011.method_4309((InputStream)logoEditionInputStream);
            class_1043 logoEditionTexture = new class_1043(() -> ((class_2960)editionIdentifier).toString(), logoEditionNativeImage);
            class_310.method_1551().method_1531().method_4616(class_2960.method_60655((String)"simplemenu", (String)"edition"), (class_1044)logoEditionTexture);
            logoEditionNativeImage.close();
            Variables.loadedLogoEditionImage = true;
        }
        if (!(backgroundFile = new File(backgroundFilePath = backgroundPath + File.separator + "background.png")).exists()) {
            BufferedImage emptyBackgroundImage = new BufferedImage(1920, 1080, 2);
            Graphics2D g2d = emptyBackgroundImage.createGraphics();
            g2d.setComposite(AlphaComposite.Clear);
            g2d.fillRect(0, 0, 1920, 1080);
            ImageIO.write((RenderedImage)emptyBackgroundImage, "png", backgroundFile);
            Constants.logger.warn("[Simple Menu] Generated a default background in: " + backgroundFilePath);
        }
        if (ConfigHandler.setCustomBackground) {
            class_2960 backgroundIdentifier = class_2960.method_60655((String)"simplemenu", (String)"background");
            FileInputStream backgroundInputStream = new FileInputStream(backgroundFile);
            class_1011 backgroundNativeImage = class_1011.method_4309((InputStream)backgroundInputStream);
            class_1043 backgroundTexture = new class_1043(() -> ((class_2960)backgroundIdentifier).toString(), backgroundNativeImage);
            class_310.method_1551().method_1531().method_4616(backgroundIdentifier, (class_1044)backgroundTexture);
            backgroundNativeImage.close();
            Variables.loadedBackgroundImage = true;
        }
    }

    public static void openUrl(String url) {
        try {
            class_156.method_668().method_673(new URI(url));
        }
        catch (URISyntaxException ex) {
            Constants.logger.warn("[Simple Menu] Unable to open custom URL: " + url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processCustomWindowIcon() {
        try {
            File icon16x16 = new File(iconPath + File.separator + "/icon_16x16.png");
            File icon32x32 = new File(iconPath + File.separator + "/icon_32x32.png");
            if (!icon16x16.exists() || !icon32x32.exists()) {
                int n = 0;
                List defaultIconList = class_8518.field_44650.method_51418((class_3262)class_310.method_1551().method_45573());
                for (class_7367 defaultIcon : defaultIconList) {
                    InputStream iconInputStream = (InputStream)defaultIcon.get();
                    BufferedImage defaultIconBufferedImage = ImageIO.read(iconInputStream);
                    if (n == 0) {
                        ImageIO.write((RenderedImage)defaultIconBufferedImage, "png", icon16x16);
                    } else {
                        if (n != true) break;
                        ImageIO.write((RenderedImage)defaultIconBufferedImage, "png", icon32x32);
                    }
                    ++n;
                }
                Constants.logger.info("[Simple Menu] No custom icons found. Copied default to: " + iconPath);
                return;
            }
            if (!ConfigHandler.setCustomWindowIcon) {
                return;
            }
            BufferedImage bi16x16 = ImageIO.read(icon16x16);
            BufferedImage bi32x32 = ImageIO.read(icon32x32);
            if (bi16x16.getHeight() != 16 || bi16x16.getWidth() != 16 || bi32x32.getHeight() != 32 || bi32x32.getWidth() != 32) {
                Constants.logger.warn("[Simple Menu] Custom window icon enabled, but icon images have incorrect dimensions.");
                return;
            }
            List<class_7367> iconList = Arrays.asList(class_7367.create((Path)icon16x16.toPath()), class_7367.create((Path)icon32x32.toPath()));
            ArrayList<ByteBuffer> list1 = new ArrayList<ByteBuffer>(iconList.size());
            try (MemoryStack memorystack = MemoryStack.stackPush();){
                GLFWImage.Buffer buffer = GLFWImage.malloc((int)iconList.size(), (MemoryStack)memorystack);
                for (int i = 0; i < iconList.size(); ++i) {
                    try (class_1011 nativeimage = class_1011.method_4309((InputStream)((InputStream)iconList.get(i).get()));){
                        ByteBuffer bytebuffer = MemoryUtil.memAlloc((int)(nativeimage.method_4307() * nativeimage.method_4323() * 4));
                        list1.add(bytebuffer);
                        bytebuffer.asIntBuffer().put(nativeimage.method_48463());
                        buffer.position(i);
                        buffer.width(nativeimage.method_4307());
                        buffer.height(nativeimage.method_4323());
                        buffer.pixels(bytebuffer);
                        continue;
                    }
                }
                GLFW.glfwSetWindowIcon((long)class_310.method_1551().method_22683().method_4490(), (GLFWImage.Buffer)buffer);
            }
            finally {
                list1.forEach(MemoryUtil::memFree);
            }
            Variables.loadedIconImage = true;
        }
        catch (IOException ex) {
            Constants.logger.warn("[Simple Menu] IOException when setting the custom window icon.");
        }
    }
}

