/*
 * Decompiled with CFR 0.152.
 */
package b100.gui;

import b100.fullscreenfix.FullscreenFix;
import b100.fullscreenfix.util.ReflectUtils;
import b100.gui.GuiElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class ListenerList<ListenerType> {
    public static final boolean DEBUG = false;
    private GuiElement parentElement;
    private ArrayList<ListenerType> listeners = new ArrayList();
    private ArrayList<ListenerType> previousListeners = new ArrayList();
    private boolean iterating = false;
    private String name;

    public ListenerList(GuiElement parentElement) {
        this.parentElement = parentElement;
    }

    public GuiElement add(ListenerType e) {
        if (this.iterating) {
            throw new ConcurrentModificationException("Modified list " + String.valueOf(this) + " while iterating!");
        }
        if (this.listeners.contains(e)) {
            this.listeners.remove(e);
        }
        this.listeners.add(e);
        return this.parentElement;
    }

    public boolean remove(ListenerType e) {
        if (this.iterating) {
            throw new ConcurrentModificationException("Modified list " + String.valueOf(this) + " while iterating!");
        }
        return this.listeners.remove(e);
    }

    public void forEach(Consumer<ListenerType> action) {
        if (this.listeners.size() == 0) {
            return;
        }
        if (this.iterating) {
            throw new RuntimeException("Already iterating " + String.valueOf(this));
        }
        this.iterating = true;
        this.previousListeners.addAll(this.listeners);
        for (ListenerType listener : this.previousListeners) {
            action.accept(listener);
        }
        this.previousListeners.clear();
        this.iterating = false;
    }

    public String toString() {
        return this.parentElement.getClass().getSimpleName() + "." + this.getName() + "[" + this.listeners.size() + "] in " + String.valueOf(this.parentElement);
    }

    private String getName() {
        if (this.name != null) {
            return this.name;
        }
        try {
            List<Field> allFields = ReflectUtils.getAllFields(this.parentElement.getClass());
            for (Field field : allFields) {
                int mod = field.getModifiers();
                if (field.getType() != ListenerList.class || Modifier.isStatic(mod)) continue;
                field.setAccessible(true);
                Object obj = field.get(this.parentElement);
                if (obj != this) continue;
                return field.getName();
            }
            FullscreenFix.print("All Fields: ");
            for (Field field : allFields) {
                FullscreenFix.print("    " + field.getType().getName() + " " + field.getName());
            }
            throw new RuntimeException("Could not find list field in class " + this.parentElement.getClass().getName() + "!");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get list name!", e);
        }
    }
}

