/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat.resource;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.replaceitem.symbolchat.resource.SymbolList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SymbolTab
implements Comparable<SymbolTab> {
    private final class_2960 id;
    private final class_2960 icon;
    private final String textIcon;
    private final class_2561 tooltipText;
    private List<SymbolList> symbols;
    private final int order;
    private final Type type;
    private final boolean searchBar;

    public SymbolTab(class_2960 id, String icon, int order, Type type, boolean searchBar, List<SymbolList> symbols) {
        this.id = id;
        if (icon.codePoints().count() == 1L) {
            this.icon = null;
            this.textIcon = icon;
        } else {
            this.icon = class_2960.method_60654((String)icon);
            this.textIcon = null;
        }
        this.order = order;
        this.type = type;
        this.tooltipText = class_2561.method_43471((String)id.method_42093("symbolchat.tab"));
        this.searchBar = searchBar;
        this.symbols = symbols;
    }

    public class_2960 getId() {
        return this.id;
    }

    public void setSymbols(List<SymbolList> symbols) {
        this.symbols = symbols;
    }

    public boolean hasSearchBar() {
        return this.searchBar;
    }

    public List<SymbolList> getSymbols() {
        return this.symbols;
    }

    public Stream<String> streamSymbols() {
        return this.symbols.stream().flatMap(SymbolList::stream);
    }

    public class_2561 getTooltipText() {
        return this.tooltipText;
    }

    @Override
    public int compareTo(@NotNull SymbolTab o) {
        return Integer.compare(this.order, o.order);
    }

    public Type getType() {
        return this.type;
    }

    public class_2960 getIcon() {
        return this.icon;
    }

    public String getTextIcon() {
        return this.textIcon;
    }

    public static class Type {
        private static final Map<String, Type> TYPES = new HashMap<String, Type>();
        public static final Type SYMBOLS = Type.register("symbols", new Type(i -> i, true, false));
        public static final Type KAOMOJIS = Type.register("kaomojis", new Type(i -> 1, false, true));
        private final Int2IntFunction columnFunction;
        private final boolean hasTooltip;
        private final boolean fullWidthButtons;

        public Type(Int2IntFunction columnFunction, boolean hasTooltip, boolean fullWidthButtons) {
            this.columnFunction = columnFunction;
            this.hasTooltip = hasTooltip;
            this.fullWidthButtons = fullWidthButtons;
        }

        public static Type register(String name, Type type) {
            TYPES.put(name, type);
            return type;
        }

        @NotNull
        public static Type getOrDefault(String name, @NotNull Type defaultType) {
            Type type = Type.get(name);
            return type == null ? defaultType : type;
        }

        @Nullable
        public static Type get(String name) {
            return TYPES.get(name);
        }

        public int getColumns(int panelColumns) {
            return this.columnFunction.get(panelColumns);
        }

        public boolean hasTooltip() {
            return this.hasTooltip;
        }

        public boolean hasFullWidthButtons() {
            return this.fullWidthButtons;
        }
    }
}

