/*
 * Decompiled with CFR 0.152.
 */
package xeed.mc.streamotes.emoticon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import xeed.mc.streamotes.Streamotes;
import xeed.mc.streamotes.api.IEmoticonLoader;
import xeed.mc.streamotes.emoticon.Emoticon;

public class EmoticonRegistry {
    private static final HashMap<String, Emoticon> namedMap = new HashMap();
    private static final ArrayList<Emoticon> disposalList = new ArrayList();
    private static final ArrayList<Emoticon> tempList = new ArrayList();
    private static final Object loadingLock = new Object();
    private static final AtomicInteger loading = new AtomicInteger(0);

    public static void startLoading() {
        loading.incrementAndGet();
    }

    public static boolean endLoading() {
        return loading.decrementAndGet() == 0;
    }

    public static boolean isLoading() {
        return loading.get() > 1;
    }

    public static List<String> getEmoteNames() {
        return namedMap.keySet().stream().sorted().collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Emoticon> getEmotes() {
        tempList.clear();
        Object object = loadingLock;
        synchronized (object) {
            tempList.addAll(namedMap.values());
        }
        return tempList;
    }

    public static Emoticon registerEmoticon(String source, String name, int priority, IEmoticonLoader loader) {
        return EmoticonRegistry.registerEmoticon(source, name, false, priority, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Emoticon registerEmoticon(String source, String name, boolean zeroWidth, int priority, IEmoticonLoader loader) {
        if (!Streamotes.EMOTE_PATTERN.matcher(name).matches()) {
            return null;
        }
        Object object = loadingLock;
        synchronized (object) {
            Emoticon emoticon = namedMap.get(name);
            if (emoticon != null && emoticon.priority < priority) {
                return null;
            }
            emoticon = new Emoticon(source, name, zeroWidth, priority, loader);
            namedMap.put(name, emoticon);
            return emoticon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Emoticon fromName(String name) {
        Object object = loadingLock;
        synchronized (object) {
            return namedMap.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadEmoticons() {
        Object object = loadingLock;
        synchronized (object) {
            ArrayList<Emoticon> arrayList = disposalList;
            synchronized (arrayList) {
                disposalList.addAll(namedMap.values());
            }
            namedMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runDisposal() {
        ArrayList<Emoticon> arrayList = disposalList;
        synchronized (arrayList) {
            if (!disposalList.isEmpty()) {
                for (Emoticon emoticon : disposalList) {
                    emoticon.close();
                }
                disposalList.clear();
            }
        }
    }
}

