/*
 * Decompiled with CFR 0.152.
 */
package xeed.mc.streamotes.addon.pack;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import xeed.mc.streamotes.addon.TwitchEmotesAPI;
import xeed.mc.streamotes.api.EmoteLoaderException;
import xeed.mc.streamotes.emoticon.Emoticon;
import xeed.mc.streamotes.emoticon.EmoticonRegistry;

public class X7tvChannelPack {
    private static final String URL_TEMPLATE = "https://cdn.7tv.app/emote/{{id}}/2x.webp";
    private static final int PRIO = 6;

    public static void loadMetadata(String channelName) {
        try {
            String channelId = TwitchEmotesAPI.getChannelId(channelName);
            URL apiURL = TwitchEmotesAPI.getURL("https://7tv.io/v3/users/twitch/" + channelId);
            JsonObject obj = TwitchEmotesAPI.getJsonObj(apiURL);
            if (obj == null) {
                return;
            }
            JsonElement elem = obj.get("emote_set");
            if (elem == null) {
                return;
            }
            obj = elem.getAsJsonObject();
            if (obj == null) {
                return;
            }
            elem = obj.get("emotes");
            if (elem == null) {
                return;
            }
            JsonArray emotes = elem.getAsJsonArray();
            for (int i = 0; i < emotes.size(); ++i) {
                int flags;
                boolean zeroWidth;
                JsonObject entry = emotes.get(i).getAsJsonObject();
                String code = TwitchEmotesAPI.getJsonString(entry, "name");
                Emoticon emoticon = EmoticonRegistry.registerEmoticon(channelName, code, zeroWidth = ((flags = entry.getAsJsonObject("data").get("flags").getAsInt()) & 0x100) != 0, 6, X7tvChannelPack::loadEmoticonImage);
                if (emoticon == null) continue;
                emoticon.setLoadData(TwitchEmotesAPI.getJsonString(entry, "id"));
                emoticon.setTooltip(channelName + " (7tv)");
            }
        }
        catch (FileNotFoundException channelId) {
        }
        catch (Exception e) {
            throw new EmoteLoaderException("Unhandled exception", e);
        }
    }

    private static void loadEmoticonImage(Emoticon emoticon) {
        String data = (String)emoticon.getLoadData();
        try {
            TwitchEmotesAPI.loadEmoteImage(emoticon, new URI(URL_TEMPLATE.replace("{{id}}", data)), "7tv", data);
        }
        catch (URISyntaxException e) {
            throw new EmoteLoaderException(e);
        }
    }
}

