/*
 * Decompiled with CFR 0.152.
 */
package xeed.mc.streamotes.addon.pack;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.minecraft.class_3545;
import xeed.mc.streamotes.addon.TwitchEmotesAPI;
import xeed.mc.streamotes.api.EmoteLoaderException;
import xeed.mc.streamotes.emoticon.Emoticon;
import xeed.mc.streamotes.emoticon.EmoticonRegistry;

public class FFZPack {
    private static final int PRIO = 5;

    public static void loadMetadata() {
        try {
            URL apiURL = TwitchEmotesAPI.getURL("https://api.frankerfacez.com/v1/set/global");
            JsonObject root = TwitchEmotesAPI.getJsonObj(apiURL);
            if (root == null) {
                throw new EmoteLoaderException("Failed to grab FrankerFaceZ emotes");
            }
            JsonArray defaultSets = root.getAsJsonArray("default_sets");
            JsonObject sets = root.getAsJsonObject("sets");
            for (int i = 0; i < defaultSets.size(); ++i) {
                int setId = defaultSets.get(i).getAsInt();
                JsonObject set = sets.getAsJsonObject(String.valueOf(setId));
                JsonArray emoticons = set.getAsJsonArray("emoticons");
                for (int j = 0; j < emoticons.size(); ++j) {
                    JsonObject emoticonObject = emoticons.get(j).getAsJsonObject();
                    String code = emoticonObject.get("name").getAsString();
                    JsonObject urls = emoticonObject.getAsJsonObject("urls");
                    String url = (urls.has("2") ? urls.get("2") : urls.get("1")).getAsString();
                    String id = emoticonObject.get("id").getAsString();
                    Emoticon emoticon = EmoticonRegistry.registerEmoticon(".FFZ", code, 5, FFZPack::loadEmoticonImage);
                    if (emoticon == null) continue;
                    emoticon.setLoadData(new class_3545((Object)id, (Object)url));
                    emoticon.setTooltip("FFZ");
                }
            }
        }
        catch (FileNotFoundException apiURL) {
        }
        catch (Exception e) {
            throw new EmoteLoaderException("Unhandled exception", e);
        }
    }

    private static void loadEmoticonImage(Emoticon emoticon) {
        class_3545 data = (class_3545)emoticon.getLoadData();
        try {
            TwitchEmotesAPI.loadEmoteImage(emoticon, new URI((String)data.method_15441()), "ffz", (String)data.method_15442());
        }
        catch (URISyntaxException e) {
            throw new EmoteLoaderException(e);
        }
    }
}

