/*
 * Decompiled with CFR 0.152.
 */
package xeed.mc.streamotes;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Objects;
import java.util.regex.Pattern;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_12099;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xeed.mc.streamotes.CompatServer;
import xeed.mc.streamotes.ModConfigModel;

public class StreamotesCommon
implements ModInitializer {
    public static final String NAME = "streamotes";
    private static final String RELOAD = "reload";
    private static final String FORCE_RELOAD = "force-reload";
    public static final class_2960 IDENT = Objects.requireNonNull(class_2960.method_43902((String)"xeed", (String)"streamotes"));
    public static final Pattern VALID_CHANNEL_PATTERN = Pattern.compile("[_a-zA-Z]\\w+");
    private static final Logger LOGGER = LogManager.getLogger((String)"streamotes");

    public static ModConfigModel getOwnConfig() {
        return ModConfigModel.getInstance();
    }

    public static ModConfigModel configFromJson(String json) {
        Gson gson = new Gson();
        try {
            ModConfigModel result = (ModConfigModel)gson.fromJson(json, ModConfigModel.class);
            result.errorReporting = StreamotesCommon.getOwnConfig().errorReporting;
            return result;
        }
        catch (JsonSyntaxException ex) {
            return null;
        }
    }

    private static String configToJson(ModConfigModel cfg) {
        Gson gson = new Gson();
        return gson.toJson((Object)cfg, ModConfigModel.class);
    }

    public static void logi(String text) {
        LOGGER.info(text);
    }

    public static void loge(String text, Throwable t) {
        LOGGER.error(text, t);
    }

    public void onInitialize() {
        ModConfigModel.reload();
        CommandRegistrationCallback.EVENT.register(this::registerCommands);
        ServerPlayConnectionEvents.JOIN.register(this::onPlayerJoin);
        CompatServer.onInitializeServer();
    }

    private static class_2596<?> createConfigPacket(boolean forceClear) {
        ModConfigModel cfg = StreamotesCommon.getOwnConfig();
        cfg.forceClearCache = forceClear;
        return CompatServer.createConfigPacket(StreamotesCommon.configToJson(cfg));
    }

    private void onPlayerJoin(class_3244 serverPlayNetworkHandler, PacketSender packetSender, MinecraftServer minecraftServer) {
        serverPlayNetworkHandler.method_14364(StreamotesCommon.createConfigPacket(false));
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)NAME).requires(source -> source.method_75037().hasPermission(class_12099.field_63211))).then(class_2170.method_9247((String)RELOAD).executes(context -> {
            ModConfigModel.reload();
            ((class_2168)context.getSource()).method_9211().method_3760().method_14581(StreamotesCommon.createConfigPacket(false));
            return 1;
        }))).then(class_2170.method_9247((String)FORCE_RELOAD).executes(context -> {
            ModConfigModel.reload();
            ((class_2168)context.getSource()).method_9211().method_3760().method_14581(StreamotesCommon.createConfigPacket(true));
            return 1;
        }))).executes(context -> {
            CompatServer.sendFeedback((class_2168)context.getSource(), (class_2561)class_2561.method_43470((String)"Usage: /streamotes [reload|force-reload]"), false);
            return 1;
        }));
    }
}

