/*
 * Decompiled with CFR 0.152.
 */
package xeed.mc.streamotes;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_5250;
import xeed.mc.streamotes.Compat;
import xeed.mc.streamotes.DrawerCommons;
import xeed.mc.streamotes.ModConfigModel;
import xeed.mc.streamotes.ReportOption;
import xeed.mc.streamotes.StreamotesCommon;
import xeed.mc.streamotes.addon.TwitchEmotesAPI;
import xeed.mc.streamotes.addon.pack.BTTVChannelPack;
import xeed.mc.streamotes.addon.pack.BTTVPack;
import xeed.mc.streamotes.addon.pack.FFZChannelPack;
import xeed.mc.streamotes.addon.pack.FFZPack;
import xeed.mc.streamotes.addon.pack.TwitchGlobalPack;
import xeed.mc.streamotes.addon.pack.TwitchSubscriberPack;
import xeed.mc.streamotes.addon.pack.X7tvChannelPack;
import xeed.mc.streamotes.addon.pack.X7tvPack;
import xeed.mc.streamotes.api.EmoteLoaderException;
import xeed.mc.streamotes.emoticon.EmoticonRegistry;

public class Streamotes
implements ClientModInitializer {
    public static final Pattern EMOTE_PATTERN = Pattern.compile("[^\\s:]{2,}|:?[^\\s:]+:?", 256);
    private static final AtomicInteger LOAD_COUNTER = new AtomicInteger(0);
    private static final class_370.class_9037 STREAMOTES_TOAST = Compat.makeToastType();
    public static Streamotes INSTANCE;
    private ModConfigModel ovConfig = null;

    public static void log(String text) {
        StreamotesCommon.logi(text);
    }

    public static void loge(String text, Throwable t) {
        StreamotesCommon.loge(text, t);
        Streamotes.msg(text);
    }

    public static void msg(String text) {
        class_310 mc = class_310.method_1551();
        ReportOption mode = StreamotesCommon.getOwnConfig().errorReporting;
        if (mode == ReportOption.Toast) {
            class_5250 title = class_2561.method_43470((String)"Streamotes");
            class_5250 msg = class_2561.method_43470((String)text);
            mc.method_1566().method_1999((class_368)class_370.method_29047((class_310)mc, (class_370.class_9037)STREAMOTES_TOAST, (class_2561)title, (class_2561)msg));
        } else if (mode == ReportOption.Chat) {
            mc.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)("Streamotes: " + text)));
        }
    }

    public ModConfigModel getConfig() {
        return this.ovConfig != null ? this.ovConfig : StreamotesCommon.getOwnConfig();
    }

    public void onInitializeClient() {
        INSTANCE = this;
        ImageIO.scanForPlugins();
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> TwitchEmotesAPI.initialize(client.field_1697));
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> this.reloadEmoticons());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            this.ovConfig = null;
        });
        Compat.onInitializeClient(this::onReceiveJsonPacket);
    }

    private void onReceiveJsonPacket(String json) {
        ModConfigModel cfg = StreamotesCommon.configFromJson(json);
        if (cfg == null) {
            Streamotes.log("Received invalid config JSON: " + json);
            Streamotes.msg("Received invalid emote config! Contact server admin.");
        } else {
            this.ovConfig = cfg;
            Streamotes.msg("Received emote config, starting loading");
            if (cfg.forceClearCache) {
                Streamotes.msg("Force cache clear requested, clearing cache");
                TwitchEmotesAPI.clearFileCache();
                TwitchEmotesAPI.clearJsonCache();
                cfg.forceClearCache = false;
            }
            if (StreamotesCommon.getOwnConfig().versionCode != cfg.versionCode) {
                Streamotes.loge("Server reported different mod version: " + cfg.versionName, null);
            }
            this.reloadEmoticons();
        }
    }

    private void startLoadingDaemon(String name, Runnable action) {
        EmoticonRegistry.startLoading();
        Thread thread = new Thread(() -> {
            try {
                action.run();
            }
            finally {
                if (EmoticonRegistry.endLoading()) {
                    List<String> emotes = EmoticonRegistry.getEmoteNames();
                    Streamotes.msg("Finished loading, " + emotes.size() + " emotes from " + this.getConfig().emoteChannels.size() + " channels");
                }
            }
        }, name);
        thread.setDaemon(true);
        thread.start();
    }

    public static void sleepSweetPrince(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static EmoteLoaderException tryFewTimes(Runnable func, int maxTries) {
        int nr = 0;
        while (true) {
            try {
                func.run();
                return null;
            }
            catch (EmoteLoaderException t) {
                if (--maxTries <= 0) {
                    return t;
                }
                Streamotes.sleepSweetPrince(++nr * 50);
                continue;
            }
            break;
        }
    }

    private void reloadEmoticons() {
        int loadId = LOAD_COUNTER.incrementAndGet();
        this.startLoadingDaemon("Emote Load Manager", () -> {
            while (EmoticonRegistry.isLoading()) {
                Streamotes.sleepSweetPrince(10);
            }
            EmoticonRegistry.reloadEmoticons();
            DrawerCommons.clearLayerCache();
            class_310.method_1551().execute(EmoticonRegistry::runDisposal);
            ModConfigModel cfg = this.getConfig();
            ArrayList<String> channelList = new ArrayList<String>(cfg.emoteChannels);
            if (cfg.x7tvEmotes || cfg.x7tvChannelEmotes) {
                this.processPacks("7TV", loadId, channelList, cfg.x7tvEmotes ? X7tvPack::loadMetadata : null, cfg.x7tvChannelEmotes ? X7tvChannelPack::loadMetadata : null);
            }
            if (cfg.ffzEmotes || cfg.ffzChannelEmotes) {
                this.processPacks("FFZ", loadId, channelList, cfg.ffzEmotes ? FFZPack::loadMetadata : null, cfg.ffzChannelEmotes ? FFZChannelPack::loadMetadata : null);
            }
            if (cfg.bttvEmotes || cfg.bttvChannelEmotes) {
                this.processPacks("BTTV", loadId, channelList, cfg.bttvEmotes ? BTTVPack::loadMetadata : null, cfg.bttvChannelEmotes ? BTTVChannelPack::loadMetadata : null);
            }
            if (cfg.twitchGlobalEmotes || cfg.twitchSubscriberEmotes) {
                this.processPacks("Twitch", loadId, channelList, cfg.twitchGlobalEmotes ? TwitchGlobalPack::loadMetadata : null, cfg.twitchSubscriberEmotes ? TwitchSubscriberPack::loadMetadata : null);
            }
        });
    }

    public void processPacks(String sourceName, int loadId, ArrayList<String> channelList, Runnable globLoader, Consumer<String> subLoader) {
        this.startLoadingDaemon(sourceName + " Emote Loader", () -> {
            if (globLoader != null) {
                try {
                    if (LOAD_COUNTER.get() != loadId) {
                        return;
                    }
                    EmoteLoaderException ex = Streamotes.tryFewTimes(globLoader, 10);
                    if (ex != null) {
                        throw ex;
                    }
                }
                catch (EmoteLoaderException e) {
                    Streamotes.loge("Failed to load " + sourceName + " global emotes", e);
                }
            }
            if (subLoader != null) {
                for (String channel : channelList) {
                    try {
                        if (LOAD_COUNTER.get() != loadId) {
                            return;
                        }
                        EmoteLoaderException ex = Streamotes.tryFewTimes(() -> subLoader.accept(channel), 10);
                        if (ex == null) continue;
                        throw ex;
                    }
                    catch (EmoteLoaderException e) {
                        Streamotes.loge("Failed to load " + sourceName + " " + channel + " emotes", e);
                    }
                }
            }
        });
    }

    @FunctionalInterface
    public static interface StringAction {
        public void apply(String var1);
    }
}

