/*
 * Decompiled with CFR 0.152.
 */
package xeed.mc.streamotes;

import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import xeed.mc.streamotes.ActivationOption;
import xeed.mc.streamotes.ReportOption;
import xeed.mc.streamotes.StreamotesCommon;

public class ModConfigModel {
    private static final int SCHEMA_VERSION = 1;
    private static final ConfigClassHandler<ModConfigModel> HANDLER = ConfigClassHandler.createBuilder(ModConfigModel.class).id(StreamotesCommon.IDENT).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(FabricLoader.getInstance().getConfigDir().resolve("streamotes.json5")).setJson5(true).build()).build();
    @SerialEntry
    public List<String> emoteChannels = List.of("Spookie_Rose", "fifigoesree", "Mifuyu");
    @SerialEntry
    public boolean twitchGlobalEmotes = true;
    @SerialEntry
    public boolean twitchSubscriberEmotes = true;
    @SerialEntry
    public boolean bttvEmotes = true;
    @SerialEntry
    public boolean bttvChannelEmotes = true;
    @SerialEntry
    public boolean ffzEmotes = true;
    @SerialEntry
    public boolean ffzChannelEmotes = true;
    @SerialEntry
    public boolean x7tvEmotes = true;
    @SerialEntry
    public boolean x7tvChannelEmotes = true;
    @SerialEntry
    public boolean colorEmotes = true;
    @SerialEntry
    public ActivationOption activationMode = ActivationOption.Optional;
    @SerialEntry
    public ReportOption errorReporting = ReportOption.Toast;
    public String versionName = "<=1.2.11";
    public int versionCode = 0;
    public boolean forceClearCache = false;

    private static void verifyChannels(ModConfigModel model) {
        ArrayList<String> list = new ArrayList<String>(model.emoteChannels);
        int size = list.size();
        HashSet<String> set = new HashSet<String>(size);
        for (int i = list.size() - 1; i >= 0; --i) {
            String item = list.get(i);
            if (item != null && item.length() >= 3 && item.length() <= 25 && StreamotesCommon.VALID_CHANNEL_PATTERN.matcher(item).find() && set.add(item)) continue;
            list.remove(i);
        }
        if (size != list.size()) {
            model.emoteChannels = list;
        }
    }

    private static void setSelfVersion(ModConfigModel model) {
        String version = ((ModContainer)FabricLoader.getInstance().getModContainer("streamotes").orElseThrow()).getMetadata().getVersion().getFriendlyString();
        int ix = version.indexOf(43);
        model.versionName = ix != -1 ? version.substring(0, ix) : version;
        model.versionCode = 1;
    }

    public static ModConfigModel getInstance() {
        return (ModConfigModel)HANDLER.instance();
    }

    public static ModConfigModel getDefaults() {
        return (ModConfigModel)HANDLER.defaults();
    }

    public static void reload() {
        HANDLER.load();
        ModConfigModel inst = ModConfigModel.getInstance();
        ModConfigModel.setSelfVersion(inst);
        ModConfigModel.verifyChannels(inst);
    }

    public static void save() {
        ModConfigModel.verifyChannels(ModConfigModel.getInstance());
        HANDLER.save();
    }
}

