/*
 * Decompiled with CFR 0.152.
 */
package xeed.mc.streamotes;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_3545;
import xeed.mc.streamotes.ImageHandler;
import xeed.mc.streamotes.Streamotes;
import xeed.mc.streamotes.addon.TwitchEmotesAPI;
import xeed.mc.streamotes.emoticon.Emoticon;

public class InternalMethods {
    public static boolean loadImage(Emoticon emoticon, URI uri) {
        boolean bl;
        block8: {
            InputStream in = TwitchEmotesAPI.openStream(uri.toURL());
            try {
                Streamotes.log("Loading from " + String.valueOf(uri));
                bl = InternalMethods.loadImage(emoticon, in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Streamotes.loge("Emote " + emoticon.getName() + " load failed", e);
                    return false;
                }
            }
            in.close();
        }
        return bl;
    }

    private static int[] loadInts(File file) throws IOException {
        IntArrayList result = new IntArrayList();
        try (BufferedReader reader = new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.add(Integer.parseInt(line));
            }
        }
        return result.toIntArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean loadImage(Emoticon emoticon, File file) {
        Streamotes.log("Loading from " + file.getAbsolutePath());
        try (FileInputStream in = new FileInputStream(file);){
            if (!InternalMethods.loadImage(emoticon, in)) return false;
            File meta = new File(file.getParentFile(), file.getName() + ".txt");
            if (meta.exists()) {
                int[] data = InternalMethods.loadInts(meta);
                if (data.length < 3) {
                    boolean bl = false;
                    return bl;
                }
                int width = data[0];
                int height = data[1];
                int[] frameTimes = Arrays.copyOfRange(data, 2, data.length - 1);
                emoticon.setFrameData(frameTimes, width, height);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Streamotes.loge("Emote " + emoticon.getName() + " cache load failed", e);
        }
        return false;
    }

    public static boolean loadImage(Emoticon emoticon, InputStream obj) {
        try {
            List<class_3545<BufferedImage, Integer>> frames = ImageHandler.readImages(obj);
            if (frames.isEmpty()) {
                return false;
            }
            if (frames.size() == 1) {
                emoticon.setImage((BufferedImage)frames.get(0).method_15442());
            } else {
                BufferedImage[] images = new BufferedImage[frames.size()];
                int[] times = new int[images.length];
                for (int i = 0; i < images.length; ++i) {
                    images[i] = (BufferedImage)frames.get(i).method_15442();
                    times[i] = (Integer)frames.get(i).method_15441();
                }
                emoticon.setImages(images, times);
            }
            return true;
        }
        catch (IOException | IllegalArgumentException e) {
            Streamotes.loge("Emote " + emoticon.getName() + " data load failed", e);
            return false;
        }
    }

    public static class_1011 awtToNative(BufferedImage img) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            class_1011 class_10112;
            ImageIO.write((RenderedImage)img, "png", baos);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());){
                class_10112 = class_1011.method_4309((InputStream)bais);
            }
            return class_10112;
        }
    }
}

