/*
 * Decompiled with CFR 0.152.
 */
package xeed.mc.streamotes;

import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1921;
import net.minecraft.class_2583;
import xeed.mc.streamotes.Compat;
import xeed.mc.streamotes.emoticon.Emoticon;

public class DrawerCommons {
    private static final ConcurrentHashMap<Emoticon, class_1921> LAYER_CACHE = new ConcurrentHashMap();

    public static class_1921 getLayer(Emoticon emote) {
        return LAYER_CACHE.computeIfAbsent(emote, Compat::layerFunc);
    }

    public static void clearLayerCache() {
        LAYER_CACHE.clear();
    }

    public static void beforeAccept(State state, int codePoint) {
        if (Compat.getEmote(state.style) != null) {
            if (Character.isBmpCodePoint(codePoint)) {
                ++state.length;
            } else if (Character.isValidCodePoint(codePoint)) {
                state.length += 2;
            }
        }
    }

    public static void afterAccept(State state) {
        Emoticon emote = Compat.getEmote(state.style);
        if (emote == null || state.length >= emote.getName().length()) {
            state.length = 0;
        }
    }

    public static Float atGetAdvance(State state) {
        if (state.length == 0) {
            return null;
        }
        Emoticon icon = Compat.getEmote(state.style);
        if (icon == null) {
            return null;
        }
        return Float.valueOf(state.length >= icon.getName().length() ? icon.getChatRenderWidth() : 0.0f);
    }

    public static class State {
        public int length;
        public class_2583 style;
        public int color;
    }
}

