/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.occlusion;

import net.caffeinemc.mods.sodium.client.render.chunk.occlusion.GraphDirection;
import net.minecraft.class_854;
import org.jspecify.annotations.NonNull;

public class VisibilityEncoding {
    public static final long NULL = 0L;

    public static long encode(@NonNull class_854 occlusionData) {
        long visibilityData = 0L;
        for (int from = 0; from < 6; ++from) {
            for (int to = 0; to < 6; ++to) {
                if (!occlusionData.method_3695(GraphDirection.toEnum(from), GraphDirection.toEnum(to))) continue;
                visibilityData |= 1L << VisibilityEncoding.bit(from, to);
            }
        }
        return visibilityData;
    }

    public static int bit(int from, int to) {
        return from * 8 + to;
    }

    public static int getConnections(long visibilityData, int incoming) {
        return VisibilityEncoding.foldOutgoingDirections(visibilityData & VisibilityEncoding.createMask(incoming));
    }

    public static int getConnections(long visibilityData) {
        return VisibilityEncoding.foldOutgoingDirections(visibilityData);
    }

    private static long createMask(int incoming) {
        long expanded = 34630287489L * Integer.toUnsignedLong(incoming);
        return (expanded & 0x10101010101L) * 255L;
    }

    private static int foldOutgoingDirections(long data) {
        long folded = data;
        folded |= folded >> 32;
        folded |= folded >> 16;
        folded |= folded >> 8;
        return (int)(folded & 0x3FL);
    }
}

