/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.event;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.interfaces.IRenderDispatcher;
import fi.dy.masa.malilib.interfaces.IRenderer;
import fi.dy.masa.malilib.render.GuiContext;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10209;
import net.minecraft.class_11228;
import net.minecraft.class_11239;
import net.minecraft.class_11256;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_9909;
import net.minecraft.class_9916;
import net.minecraft.class_9925;
import net.minecraft.class_9960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class RenderEventHandler
implements IRenderDispatcher {
    private static final RenderEventHandler INSTANCE = new RenderEventHandler();
    private final List<IRenderer> overlayRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> tooltipLastRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> worldPostDebugRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> worldPreWeatherRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> worldLastRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> specialGuiRenderers = new ArrayList<IRenderer>();

    public static IRenderDispatcher getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerGameOverlayRenderer(IRenderer renderer) {
        if (!this.overlayRenderers.contains(renderer)) {
            this.overlayRenderers.add(renderer);
        }
    }

    @Override
    public void registerTooltipLastRenderer(IRenderer renderer) {
        if (!this.tooltipLastRenderers.contains(renderer)) {
            this.tooltipLastRenderers.add(renderer);
        }
    }

    @Override
    public void registerWorldPostDebugRenderer(IRenderer renderer) {
        if (!this.worldPostDebugRenderers.contains(renderer)) {
            this.worldPostDebugRenderers.add(renderer);
        }
    }

    @Override
    public void registerWorldPreWeatherRenderer(IRenderer renderer) {
        if (!this.worldPreWeatherRenderers.contains(renderer)) {
            this.worldPreWeatherRenderers.add(renderer);
        }
    }

    @Override
    public void registerWorldLastRenderer(IRenderer renderer) {
        if (!this.worldLastRenderers.contains(renderer)) {
            this.worldLastRenderers.add(renderer);
        }
    }

    @Override
    public void registerSpecialGuiRenderer(IRenderer renderer) {
        if (!this.specialGuiRenderers.contains(renderer)) {
            this.specialGuiRenderers.add(renderer);
        }
    }

    @ApiStatus.Internal
    public void onRenderGameOverlayPost(GuiContext ctx, float partialTicks) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("malilib_game_overlay");
        if (!this.overlayRenderers.isEmpty()) {
            for (IRenderer renderer : this.overlayRenderers) {
                profiler.method_15400(renderer.getProfilerSectionSupplier());
                renderer.onRenderGameOverlayPostAdvanced(ctx, partialTicks, profiler);
                renderer.onRenderGameOverlayPost(ctx);
                profiler.method_15407();
            }
        }
        profiler.method_15405("malilib_game_messages");
        InfoUtils.renderInGameMessages(ctx);
        profiler.method_15407();
    }

    @ApiStatus.Internal
    public void onRenderTooltipComponentInsertFirst(class_1792.class_9635 context, class_1799 stack, Consumer<class_2561> list) {
        if (!this.tooltipLastRenderers.isEmpty()) {
            for (IRenderer renderer : this.tooltipLastRenderers) {
                renderer.onRenderTooltipComponentInsertFirst(context, stack, list);
            }
        }
    }

    @ApiStatus.Internal
    public void onRenderTooltipComponentInsertMiddle(class_1792.class_9635 context, class_1799 stack, Consumer<class_2561> list) {
        if (!this.tooltipLastRenderers.isEmpty()) {
            for (IRenderer renderer : this.tooltipLastRenderers) {
                renderer.onRenderTooltipComponentInsertMiddle(context, stack, list);
            }
        }
    }

    @ApiStatus.Internal
    public void onRenderTooltipComponentInsertLast(class_1792.class_9635 context, class_1799 stack, Consumer<class_2561> list) {
        if (!this.tooltipLastRenderers.isEmpty()) {
            for (IRenderer renderer : this.tooltipLastRenderers) {
                renderer.onRenderTooltipComponentInsertLast(context, stack, list);
            }
        }
    }

    @ApiStatus.Internal
    public void onRenderTooltipLast(GuiContext ctx, class_1799 stack, int x, int y) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("malilib_tooltip");
        if (!this.tooltipLastRenderers.isEmpty()) {
            for (IRenderer renderer : this.tooltipLastRenderers) {
                profiler.method_15403(renderer.getProfilerSectionSupplier());
                renderer.onRenderTooltipLast(ctx, stack, x, y);
            }
        }
        profiler.method_15407();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @ApiStatus.Internal
    public void runRenderWorldPreWeather(Matrix4f posMatrix, Matrix4f projMatrix, class_310 mc, class_9909 frameGraphBuilder, class_9960 fbSet, class_4604 frustum, class_4184 camera, class_4599 buffers, class_3695 profiler) {
        profiler.method_15396("malilib_pre_weather");
        if (!this.worldPreWeatherRenderers.isEmpty()) {
            class_9916 pass = frameGraphBuilder.method_61911("malilib_pre_weather");
            @NotNull class_9925 handleMain = fbSet.field_53091 = pass.method_61933(fbSet.field_53091);
            pass.method_61929(() -> {
                GpuBufferSlice fog = RenderSystem.getShaderFog();
                class_276 fb = (class_276)handleMain.get();
                for (IRenderer renderer : this.worldPreWeatherRenderers) {
                    profiler.method_15400(renderer.getProfilerSectionSupplier());
                    renderer.onRenderWorldPreWeather(fb, posMatrix, projMatrix, frustum, camera, buffers, profiler);
                    profiler.method_15407();
                }
                RenderSystem.setShaderFog((GpuBufferSlice)fog);
            });
            if (!this.worldPreWeatherRenderers.isEmpty()) {
                pass.method_61924();
            }
        }
        profiler.method_15407();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @ApiStatus.Internal
    public void runRenderWorldLast(Matrix4f posMatrix, Matrix4f projMatrix, class_310 mc, class_9909 frameGraphBuilder, class_9960 fbSet, class_4604 frustum, class_4184 camera, class_4599 buffers, class_3695 profiler) {
        profiler.method_15396("malilib_world_last");
        if (!this.worldLastRenderers.isEmpty()) {
            class_9916 pass = frameGraphBuilder.method_61911("malilib_world_last");
            @NotNull class_9925 handleMain = fbSet.field_53091 = pass.method_61933(fbSet.field_53091);
            pass.method_61929(() -> {
                GpuBufferSlice fog = RenderSystem.getShaderFog();
                for (IRenderer renderer : this.worldLastRenderers) {
                    profiler.method_15400(renderer.getProfilerSectionSupplier());
                    renderer.onRenderWorldLastAdvanced((class_276)handleMain.get(), posMatrix, projMatrix, frustum, camera, buffers, profiler);
                    renderer.onRenderWorldLast(posMatrix, projMatrix);
                    profiler.method_15407();
                }
                RenderSystem.setShaderFog((GpuBufferSlice)fog);
            });
            if (!this.worldLastRenderers.isEmpty()) {
                pass.method_61924();
            }
        }
        profiler.method_15407();
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public void onRegisterSpecialGuiRenderer(class_11228 guiRenderer, class_4597.class_4598 immediate, class_310 mc, // Could not load outer class - annotation placement on inner may be incorrect
    ImmutableMap.Builder<@NotNull Class<? extends class_11256>, @NotNull class_11239<?>> builder) {
        if (!this.specialGuiRenderers.isEmpty()) {
            for (IRenderer renderer : this.specialGuiRenderers) {
                MaLiLib.LOGGER.warn("onRegisterSpecialGuiRenderer(): render for [{}]", (Object)renderer.getClass().getName());
                renderer.onRegisterSpecialGuiRenderer(guiRenderer, immediate, mc, builder);
            }
        }
    }
}

